/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.configuration.beanutils;

import com.secnium.iast.thirdparty.org.apache.commons.beanutils.BeanUtils;
import com.secnium.iast.thirdparty.org.apache.commons.beanutils.PropertyUtils;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConfigurationRuntimeException;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.beanutils.BeanDeclaration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.beanutils.BeanFactory;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.beanutils.DefaultBeanFactory;
import com.secnium.iast.thirdparty.org.apache.commons.lang.ClassUtils;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BeanHelper {
    private static final Map<String, BeanFactory> BEAN_FACTORIES = Collections.synchronizedMap(new HashMap());
    private static BeanFactory defaultBeanFactory = DefaultBeanFactory.INSTANCE;

    private BeanHelper() {
    }

    public static void registerBeanFactory(String string, BeanFactory beanFactory) {
        if (string == null) {
            throw new IllegalArgumentException("Name for bean factory must not be null!");
        }
        if (beanFactory == null) {
            throw new IllegalArgumentException("Bean factory must not be null!");
        }
        BEAN_FACTORIES.put(string, beanFactory);
    }

    public static BeanFactory deregisterBeanFactory(String string) {
        return BEAN_FACTORIES.remove(string);
    }

    public static Set<String> registeredFactoryNames() {
        return BEAN_FACTORIES.keySet();
    }

    public static BeanFactory getDefaultBeanFactory() {
        return defaultBeanFactory;
    }

    public static void setDefaultBeanFactory(BeanFactory beanFactory) {
        if (beanFactory == null) {
            throw new IllegalArgumentException("Default bean factory must not be null!");
        }
        defaultBeanFactory = beanFactory;
    }

    public static void initBean(Object object, BeanDeclaration beanDeclaration) throws ConfigurationRuntimeException {
        block6: {
            Map<String, Object> map;
            block7: {
                BeanHelper.initBeanProperties(object, beanDeclaration);
                map = beanDeclaration.getNestedBeanDeclarations();
                if (map == null) break block6;
                if (!(object instanceof Collection)) break block7;
                Collection collection = (Collection)object;
                if (map.size() != 1) break block6;
                Map.Entry<String, Object> entry = map.entrySet().iterator().next();
                String string = entry.getKey();
                Class<?> clazz = BeanHelper.getDefaultClass(object, string);
                if (entry.getValue() instanceof List) {
                    List list = (List)entry.getValue();
                    for (BeanDeclaration beanDeclaration2 : list) {
                        collection.add(BeanHelper.createBean(beanDeclaration2, clazz));
                    }
                } else {
                    BeanDeclaration beanDeclaration3 = (BeanDeclaration)entry.getValue();
                    collection.add(BeanHelper.createBean(beanDeclaration3, clazz));
                }
                break block6;
            }
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String string = entry.getKey();
                Class<?> clazz = BeanHelper.getDefaultClass(object, string);
                Object object2 = entry.getValue();
                if (object2 instanceof Collection) {
                    Collection<Object> collection = BeanHelper.createPropertyCollection(string, clazz);
                    for (Object e2 : (Collection)object2) {
                        collection.add(BeanHelper.createBean((BeanDeclaration)e2));
                    }
                    BeanHelper.initProperty(object, string, collection);
                    continue;
                }
                BeanHelper.initProperty(object, string, BeanHelper.createBean((BeanDeclaration)entry.getValue(), clazz));
            }
        }
    }

    public static void initBeanProperties(Object object, BeanDeclaration beanDeclaration) throws ConfigurationRuntimeException {
        Map<String, Object> map = beanDeclaration.getBeanProperties();
        if (map != null) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String string = entry.getKey();
                BeanHelper.initProperty(object, string, entry.getValue());
            }
        }
    }

    private static Class<?> getDefaultClass(Object object, String string) {
        try {
            PropertyDescriptor propertyDescriptor = PropertyUtils.getPropertyDescriptor((Object)object, (String)string);
            if (propertyDescriptor == null) {
                return null;
            }
            return propertyDescriptor.getPropertyType();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static void initProperty(Object object, String string, Object object2) throws ConfigurationRuntimeException {
        if (!PropertyUtils.isWriteable((Object)object, (String)string)) {
            throw new ConfigurationRuntimeException("Property " + string + " cannot be set on " + object.getClass().getName());
        }
        try {
            BeanUtils.setProperty((Object)object, (String)string, (Object)object2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ConfigurationRuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ConfigurationRuntimeException(invocationTargetException);
        }
    }

    private static Collection<Object> createPropertyCollection(String string, Class<?> clazz) {
        AbstractCollection abstractCollection = null;
        if (List.class.isAssignableFrom(clazz)) {
            abstractCollection = new ArrayList<Object>();
        } else if (Set.class.isAssignableFrom(clazz)) {
            abstractCollection = new TreeSet();
        } else {
            throw new UnsupportedOperationException("Unable to handle collection of type : " + clazz.getName() + " for property " + string);
        }
        return abstractCollection;
    }

    public static void setProperty(Object object, String string, Object object2) {
        if (PropertyUtils.isWriteable((Object)object, (String)string)) {
            BeanHelper.initProperty(object, string, object2);
        }
    }

    public static Object createBean(BeanDeclaration beanDeclaration, Class<?> clazz, Object object) throws ConfigurationRuntimeException {
        if (beanDeclaration == null) {
            throw new IllegalArgumentException("Bean declaration must not be null!");
        }
        BeanFactory beanFactory = BeanHelper.fetchBeanFactory(beanDeclaration);
        try {
            return beanFactory.createBean(BeanHelper.fetchBeanClass(beanDeclaration, clazz, beanFactory), beanDeclaration, object);
        }
        catch (Exception exception) {
            throw new ConfigurationRuntimeException(exception);
        }
    }

    public static Object createBean(BeanDeclaration beanDeclaration, Class<?> clazz) throws ConfigurationRuntimeException {
        return BeanHelper.createBean(beanDeclaration, clazz, null);
    }

    public static Object createBean(BeanDeclaration beanDeclaration) throws ConfigurationRuntimeException {
        return BeanHelper.createBean(beanDeclaration, null);
    }

    static Class<?> loadClass(String string, Class<?> clazz) throws ClassNotFoundException {
        return ClassUtils.getClass(string);
    }

    private static Class<?> fetchBeanClass(BeanDeclaration beanDeclaration, Class<?> clazz, BeanFactory beanFactory) throws ConfigurationRuntimeException {
        String string = beanDeclaration.getBeanClassName();
        if (string != null) {
            try {
                return BeanHelper.loadClass(string, beanFactory.getClass());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ConfigurationRuntimeException(classNotFoundException);
            }
        }
        if (clazz != null) {
            return clazz;
        }
        Class<?> clazz2 = beanFactory.getDefaultBeanClass();
        if (clazz2 == null) {
            throw new ConfigurationRuntimeException("Bean class is not specified!");
        }
        return clazz2;
    }

    private static BeanFactory fetchBeanFactory(BeanDeclaration beanDeclaration) throws ConfigurationRuntimeException {
        String string = beanDeclaration.getBeanFactoryName();
        if (string != null) {
            BeanFactory beanFactory = BEAN_FACTORIES.get(string);
            if (beanFactory == null) {
                throw new ConfigurationRuntimeException("Unknown bean factory: " + string);
            }
            return beanFactory;
        }
        return BeanHelper.getDefaultBeanFactory();
    }
}

