/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.configuration;

import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConfigurationException;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConfigurationRuntimeException;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.DefaultFileSystem;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.FileOptionsProvider;
import com.secnium.iast.thirdparty.org.apache.commons.vfs2.FileContent;
import com.secnium.iast.thirdparty.org.apache.commons.vfs2.FileName;
import com.secnium.iast.thirdparty.org.apache.commons.vfs2.FileObject;
import com.secnium.iast.thirdparty.org.apache.commons.vfs2.FileSystemConfigBuilder;
import com.secnium.iast.thirdparty.org.apache.commons.vfs2.FileSystemException;
import com.secnium.iast.thirdparty.org.apache.commons.vfs2.FileSystemManager;
import com.secnium.iast.thirdparty.org.apache.commons.vfs2.FileSystemOptions;
import com.secnium.iast.thirdparty.org.apache.commons.vfs2.FileType;
import com.secnium.iast.thirdparty.org.apache.commons.vfs2.VFS;
import com.secnium.iast.thirdparty.org.apache.commons.vfs2.provider.UriParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Map;

public class VFSFileSystem
extends DefaultFileSystem {
    public InputStream getInputStream(String string, String string2) throws ConfigurationException {
        try {
            FileName fileName;
            FileName fileName2;
            FileName fileName3;
            FileSystemManager fileSystemManager = VFS.getManager();
            if (string != null) {
                fileName3 = fileSystemManager.resolveURI(string);
                fileName2 = fileSystemManager.resolveName(fileName3, string2);
            } else {
                fileName3 = fileSystemManager.resolveURI(string2);
                fileName = fileName3.getParent();
                fileName2 = fileSystemManager.resolveName(fileName, fileName3.getBaseName());
            }
            fileName3 = this.getOptions(fileName2.getScheme());
            fileName = fileName3 == null ? fileSystemManager.resolveFile(fileName2.getURI()) : fileSystemManager.resolveFile(fileName2.getURI(), (FileSystemOptions)fileName3);
            FileContent fileContent = fileName.getContent();
            if (fileContent == null) {
                String string3 = "Cannot access content of " + fileName.getName().getFriendlyURI();
                throw new ConfigurationException(string3);
            }
            return fileContent.getInputStream();
        }
        catch (ConfigurationException configurationException) {
            throw configurationException;
        }
        catch (Exception exception) {
            throw new ConfigurationException("Unable to load the configuration file " + string2, exception);
        }
    }

    public InputStream getInputStream(URL uRL) throws ConfigurationException {
        try {
            FileObject fileObject;
            FileSystemOptions fileSystemOptions = this.getOptions(uRL.getProtocol());
            FileObject fileObject2 = fileObject = fileSystemOptions == null ? VFS.getManager().resolveFile(uRL.toString()) : VFS.getManager().resolveFile(uRL.toString(), fileSystemOptions);
            if (fileObject.getType() != FileType.FILE) {
                throw new ConfigurationException("Cannot load a configuration from a directory");
            }
            FileContent fileContent = fileObject.getContent();
            if (fileContent == null) {
                String string = "Cannot access content of " + fileObject.getName().getFriendlyURI();
                throw new ConfigurationException(string);
            }
            return fileContent.getInputStream();
        }
        catch (FileSystemException fileSystemException) {
            String string = "Unable to access " + uRL.toString();
            throw new ConfigurationException(string, fileSystemException);
        }
    }

    public OutputStream getOutputStream(URL uRL) throws ConfigurationException {
        try {
            FileObject fileObject;
            FileSystemOptions fileSystemOptions = this.getOptions(uRL.getProtocol());
            FileSystemManager fileSystemManager = VFS.getManager();
            FileObject fileObject2 = fileObject = fileSystemOptions == null ? fileSystemManager.resolveFile(uRL.toString()) : fileSystemManager.resolveFile(uRL.toString(), fileSystemOptions);
            if (fileObject == null || fileObject.getType() == FileType.FOLDER) {
                throw new ConfigurationException("Cannot save a configuration to a directory");
            }
            FileContent fileContent = fileObject.getContent();
            if (fileContent == null) {
                throw new ConfigurationException("Cannot access content of " + uRL);
            }
            return fileContent.getOutputStream();
        }
        catch (FileSystemException fileSystemException) {
            throw new ConfigurationException("Unable to access " + uRL, fileSystemException);
        }
    }

    public String getPath(File file, URL uRL, String string, String string2) {
        if (file != null) {
            return super.getPath(file, uRL, string, string2);
        }
        try {
            FileName fileName;
            FileSystemManager fileSystemManager = VFS.getManager();
            if (uRL != null && (fileName = fileSystemManager.resolveURI(uRL.toString())) != null) {
                return fileName.toString();
            }
            if (UriParser.extractScheme((String)string2) != null) {
                return string2;
            }
            if (string != null) {
                fileName = fileSystemManager.resolveURI(string);
                return fileSystemManager.resolveName(fileName, string2).getURI();
            }
            fileName = fileSystemManager.resolveURI(string2);
            FileName fileName2 = fileName.getParent();
            return fileSystemManager.resolveName(fileName2, fileName.getBaseName()).getURI();
        }
        catch (FileSystemException fileSystemException) {
            fileSystemException.printStackTrace();
            return null;
        }
    }

    public String getBasePath(String string) {
        if (UriParser.extractScheme((String)string) == null) {
            return super.getBasePath(string);
        }
        try {
            FileSystemManager fileSystemManager = VFS.getManager();
            FileName fileName = fileSystemManager.resolveURI(string);
            return fileName.getParent().getURI();
        }
        catch (FileSystemException fileSystemException) {
            fileSystemException.printStackTrace();
            return null;
        }
    }

    public String getFileName(String string) {
        if (UriParser.extractScheme((String)string) == null) {
            return super.getFileName(string);
        }
        try {
            FileSystemManager fileSystemManager = VFS.getManager();
            FileName fileName = fileSystemManager.resolveURI(string);
            return fileName.getBaseName();
        }
        catch (FileSystemException fileSystemException) {
            fileSystemException.printStackTrace();
            return null;
        }
    }

    public URL getURL(String string, String string2) throws MalformedURLException {
        if (string != null && UriParser.extractScheme((String)string) == null || string == null && UriParser.extractScheme((String)string2) == null) {
            return super.getURL(string, string2);
        }
        try {
            FileName fileName;
            Object object;
            FileSystemManager fileSystemManager = VFS.getManager();
            if (string != null && UriParser.extractScheme((String)string2) == null) {
                object = fileSystemManager.resolveURI(string);
                fileName = fileSystemManager.resolveName(object, string2);
            } else {
                fileName = fileSystemManager.resolveURI(string2);
            }
            object = new VFSURLStreamHandler(fileName);
            return new URL(null, fileName.getURI(), (URLStreamHandler)object);
        }
        catch (FileSystemException fileSystemException) {
            throw new ConfigurationRuntimeException("Could not parse basePath: " + string + " and fileName: " + string2, fileSystemException);
        }
    }

    public URL locateFromURL(String string, String string2) {
        String string3 = UriParser.extractScheme((String)string2);
        if ((string == null || UriParser.extractScheme((String)string) == null) && string3 == null) {
            return super.locateFromURL(string, string2);
        }
        try {
            FileObject fileObject;
            Object object;
            String string4;
            FileSystemManager fileSystemManager = VFS.getManager();
            if (string != null && string3 == null) {
                FileObject fileObject2;
                string4 = UriParser.extractScheme((String)string);
                object = string4 != null ? this.getOptions(string4) : null;
                FileObject fileObject3 = fileObject2 = object == null ? fileSystemManager.resolveFile(string) : fileSystemManager.resolveFile(string, object);
                if (fileObject2.getType() == FileType.FILE) {
                    fileObject2 = fileObject2.getParent();
                }
                fileObject = fileSystemManager.resolveFile(fileObject2, string2);
            } else {
                string4 = string3 != null ? this.getOptions(string3) : null;
                FileObject fileObject4 = fileObject = string4 == null ? fileSystemManager.resolveFile(string2) : fileSystemManager.resolveFile(string2, (FileSystemOptions)string4);
            }
            if (!fileObject.exists()) {
                return null;
            }
            string4 = fileObject.getName();
            object = new VFSURLStreamHandler((FileName)string4);
            return new URL(null, string4.getURI(), (URLStreamHandler)object);
        }
        catch (FileSystemException fileSystemException) {
            return null;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private FileSystemOptions getOptions(String string) {
        FileSystemConfigBuilder fileSystemConfigBuilder;
        FileSystemOptions fileSystemOptions = new FileSystemOptions();
        try {
            fileSystemConfigBuilder = VFS.getManager().getFileSystemConfigBuilder(string);
        }
        catch (Exception exception) {
            return null;
        }
        FileOptionsProvider fileOptionsProvider = this.getFileOptionsProvider();
        if (fileOptionsProvider != null) {
            Map<String, Object> map = fileOptionsProvider.getOptions();
            if (map == null) {
                return null;
            }
            int n = 0;
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                try {
                    String string2 = entry.getKey();
                    if ("currentUser".equals(string2)) {
                        string2 = "creatorName";
                    }
                    this.setProperty(fileSystemConfigBuilder, fileSystemOptions, string2, entry.getValue());
                    ++n;
                }
                catch (Exception exception) {}
            }
            if (n > 0) {
                return fileSystemOptions;
            }
        }
        return null;
    }

    private void setProperty(FileSystemConfigBuilder fileSystemConfigBuilder, FileSystemOptions fileSystemOptions, String string, Object object) {
        String string2 = "set" + string.substring(0, 1).toUpperCase() + string.substring(1);
        Class[] classArray = new Class[]{FileSystemOptions.class, object.getClass()};
        try {
            Method method = fileSystemConfigBuilder.getClass().getMethod(string2, classArray);
            Object[] objectArray = new Object[]{fileSystemOptions, object};
            method.invoke((Object)fileSystemConfigBuilder, objectArray);
        }
        catch (Exception exception) {
            return;
        }
    }

    private static class VFSURLStreamHandler
    extends URLStreamHandler {
        private final String protocol;

        public VFSURLStreamHandler(FileName fileName) {
            this.protocol = fileName.getScheme();
        }

        protected URLConnection openConnection(URL uRL) throws IOException {
            throw new IOException("VFS URLs can only be used with VFS APIs");
        }
    }
}

