/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.configuration;

import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConfigurationException;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConfigurationRuntimeException;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.PropertiesConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.event.ConfigurationEvent;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.event.ConfigurationListener;
import com.secnium.iast.thirdparty.org.apache.commons.lang.StringUtils;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesConfigurationLayout
implements ConfigurationListener {
    private static final String CR = "\n";
    private static final String COMMENT_PREFIX = "# ";
    private PropertiesConfiguration configuration;
    private Map<String, PropertyLayoutData> layoutData;
    private String headerComment;
    private String footerComment;
    private String globalSeparator;
    private String lineSeparator;
    private int loadCounter;
    private boolean forceSingleLine;

    public PropertiesConfigurationLayout(PropertiesConfiguration propertiesConfiguration) {
        this(propertiesConfiguration, null);
    }

    public PropertiesConfigurationLayout(PropertiesConfiguration propertiesConfiguration, PropertiesConfigurationLayout propertiesConfigurationLayout) {
        if (propertiesConfiguration == null) {
            throw new IllegalArgumentException("Configuration must not be null!");
        }
        this.configuration = propertiesConfiguration;
        this.layoutData = new LinkedHashMap<String, PropertyLayoutData>();
        propertiesConfiguration.addConfigurationListener(this);
        if (propertiesConfigurationLayout != null) {
            this.copyFrom(propertiesConfigurationLayout);
        }
    }

    public PropertiesConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getCanonicalComment(String string, boolean bl) {
        return PropertiesConfigurationLayout.constructCanonicalComment(this.getComment(string), bl);
    }

    public String getComment(String string) {
        return this.fetchLayoutData(string).getComment();
    }

    public void setComment(String string, String string2) {
        this.fetchLayoutData(string).setComment(string2);
    }

    public int getBlancLinesBefore(String string) {
        return this.fetchLayoutData(string).getBlancLines();
    }

    public void setBlancLinesBefore(String string, int n) {
        this.fetchLayoutData(string).setBlancLines(n);
    }

    public String getCanonicalHeaderComment(boolean bl) {
        return PropertiesConfigurationLayout.constructCanonicalComment(this.getHeaderComment(), bl);
    }

    public String getHeaderComment() {
        return this.headerComment;
    }

    public void setHeaderComment(String string) {
        this.headerComment = string;
    }

    public String getCanonicalFooterCooment(boolean bl) {
        return PropertiesConfigurationLayout.constructCanonicalComment(this.getFooterComment(), bl);
    }

    public String getFooterComment() {
        return this.footerComment;
    }

    public void setFooterComment(String string) {
        this.footerComment = string;
    }

    public boolean isSingleLine(String string) {
        return this.fetchLayoutData(string).isSingleLine();
    }

    public void setSingleLine(String string, boolean bl) {
        this.fetchLayoutData(string).setSingleLine(bl);
    }

    public boolean isForceSingleLine() {
        return this.forceSingleLine;
    }

    public void setForceSingleLine(boolean bl) {
        this.forceSingleLine = bl;
    }

    public String getSeparator(String string) {
        return this.fetchLayoutData(string).getSeparator();
    }

    public void setSeparator(String string, String string2) {
        this.fetchLayoutData(string).setSeparator(string2);
    }

    public String getGlobalSeparator() {
        return this.globalSeparator;
    }

    public void setGlobalSeparator(String string) {
        this.globalSeparator = string;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(String string) {
        this.lineSeparator = string;
    }

    public Set<String> getKeys() {
        return this.layoutData.keySet();
    }

    public void load(Reader reader) throws ConfigurationException {
        if (++this.loadCounter == 1) {
            this.getConfiguration().removeConfigurationListener(this);
        }
        PropertiesConfiguration.PropertiesReader propertiesReader = this.getConfiguration().getIOFactory().createPropertiesReader(reader, this.getConfiguration().getListDelimiter());
        try {
            while (propertiesReader.nextProperty()) {
                if (!this.getConfiguration().propertyLoaded(propertiesReader.getPropertyName(), propertiesReader.getPropertyValue())) continue;
                boolean bl = this.layoutData.containsKey(propertiesReader.getPropertyName());
                int n = 0;
                int n2 = this.checkHeaderComment(propertiesReader.getCommentLines());
                while (n2 < propertiesReader.getCommentLines().size() && propertiesReader.getCommentLines().get(n2).length() < 1) {
                    ++n2;
                    ++n;
                }
                String string = this.extractComment(propertiesReader.getCommentLines(), n2, propertiesReader.getCommentLines().size() - 1);
                PropertyLayoutData propertyLayoutData = this.fetchLayoutData(propertiesReader.getPropertyName());
                if (bl) {
                    propertyLayoutData.addComment(string);
                    propertyLayoutData.setSingleLine(false);
                    continue;
                }
                propertyLayoutData.setComment(string);
                propertyLayoutData.setBlancLines(n);
                propertyLayoutData.setSeparator(propertiesReader.getPropertySeparator());
            }
            this.setFooterComment(this.extractComment(propertiesReader.getCommentLines(), 0, propertiesReader.getCommentLines().size() - 1));
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException);
        }
        finally {
            if (--this.loadCounter == 0) {
                this.getConfiguration().addConfigurationListener(this);
            }
        }
    }

    public void save(Writer writer) throws ConfigurationException {
        try {
            char c2 = this.getConfiguration().isDelimiterParsingDisabled() ? (char)'\u0000' : this.getConfiguration().getListDelimiter();
            PropertiesConfiguration.PropertiesWriter propertiesWriter = this.getConfiguration().getIOFactory().createPropertiesWriter(writer, c2);
            propertiesWriter.setGlobalSeparator(this.getGlobalSeparator());
            if (this.getLineSeparator() != null) {
                propertiesWriter.setLineSeparator(this.getLineSeparator());
            }
            if (this.headerComment != null) {
                PropertiesConfigurationLayout.writeComment(propertiesWriter, this.getCanonicalHeaderComment(true));
                propertiesWriter.writeln(null);
            }
            for (String string : this.layoutData.keySet()) {
                int n;
                if (!this.getConfiguration().containsKey(string)) continue;
                for (n = 0; n < this.getBlancLinesBefore(string); n += 1) {
                    propertiesWriter.writeln(null);
                }
                PropertiesConfigurationLayout.writeComment(propertiesWriter, this.getCanonicalComment(string, true));
                n = (this.isForceSingleLine() || this.isSingleLine(string)) && !this.getConfiguration().isDelimiterParsingDisabled() ? 1 : 0;
                propertiesWriter.setCurrentSeparator(this.getSeparator(string));
                propertiesWriter.writeProperty(string, this.getConfiguration().getProperty(string), n != 0);
            }
            PropertiesConfigurationLayout.writeComment(propertiesWriter, this.getCanonicalFooterCooment(true));
            propertiesWriter.flush();
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException);
        }
    }

    @Override
    public void configurationChanged(ConfigurationEvent configurationEvent) {
        if (configurationEvent.isBeforeUpdate()) {
            if (20 == configurationEvent.getType()) {
                this.clear();
            }
        } else {
            switch (configurationEvent.getType()) {
                case 1: {
                    boolean bl = this.layoutData.containsKey(configurationEvent.getPropertyName());
                    PropertyLayoutData propertyLayoutData = this.fetchLayoutData(configurationEvent.getPropertyName());
                    propertyLayoutData.setSingleLine(!bl);
                    break;
                }
                case 2: {
                    this.layoutData.remove(configurationEvent.getPropertyName());
                    break;
                }
                case 4: {
                    this.clear();
                    break;
                }
                case 3: {
                    this.fetchLayoutData(configurationEvent.getPropertyName());
                }
            }
        }
    }

    private PropertyLayoutData fetchLayoutData(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Property key must not be null!");
        }
        PropertyLayoutData propertyLayoutData = this.layoutData.get(string);
        if (propertyLayoutData == null) {
            propertyLayoutData = new PropertyLayoutData();
            propertyLayoutData.setSingleLine(true);
            this.layoutData.put(string, propertyLayoutData);
        }
        return propertyLayoutData;
    }

    private void clear() {
        this.layoutData.clear();
        this.setHeaderComment(null);
    }

    static boolean isCommentLine(String string) {
        return PropertiesConfiguration.isCommentLine(string);
    }

    static String trimComment(String string, boolean bl) {
        int n;
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n2 = 0;
        do {
            if ((n = string.indexOf(CR, n2)) < 0) continue;
            String string2 = string.substring(n2, n);
            stringBuilder.append(PropertiesConfigurationLayout.stripCommentChar(string2, bl)).append(CR);
            n2 = n + CR.length();
        } while (n >= 0);
        if (n2 < string.length()) {
            stringBuilder.append(PropertiesConfigurationLayout.stripCommentChar(string.substring(n2), bl));
        }
        return stringBuilder.toString();
    }

    static String stripCommentChar(String string, boolean bl) {
        if (string.length() < 1 || PropertiesConfigurationLayout.isCommentLine(string) == bl) {
            return string;
        }
        if (!bl) {
            int n = 0;
            while ("#!".indexOf(string.charAt(n)) < 0) {
                ++n;
            }
            ++n;
            while (n < string.length() && Character.isWhitespace(string.charAt(n))) {
                ++n;
            }
            return n < string.length() ? string.substring(n) : "";
        }
        return COMMENT_PREFIX + string;
    }

    private String extractComment(List<String> list, int n, int n2) {
        if (n2 < n) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(list.get(n));
        for (int i = n + 1; i <= n2; ++i) {
            stringBuilder.append(CR);
            stringBuilder.append(list.get(i));
        }
        return stringBuilder.toString();
    }

    private int checkHeaderComment(List<String> list) {
        if (this.loadCounter == 1 && this.getHeaderComment() == null && this.layoutData.isEmpty()) {
            int n;
            for (n = list.size() - 1; n >= 0 && list.get(n).length() > 0; --n) {
            }
            this.setHeaderComment(this.extractComment(list, 0, n - 1));
            return n + 1;
        }
        return 0;
    }

    private void copyFrom(PropertiesConfigurationLayout propertiesConfigurationLayout) {
        for (String string : propertiesConfigurationLayout.getKeys()) {
            PropertyLayoutData propertyLayoutData = propertiesConfigurationLayout.layoutData.get(string);
            this.layoutData.put(string, propertyLayoutData.clone());
        }
        this.setHeaderComment(propertiesConfigurationLayout.getHeaderComment());
        this.setFooterComment(propertiesConfigurationLayout.getFooterComment());
    }

    private static void writeComment(PropertiesConfiguration.PropertiesWriter propertiesWriter, String string) throws IOException {
        if (string != null) {
            propertiesWriter.writeln(StringUtils.replace(string, CR, propertiesWriter.getLineSeparator()));
        }
    }

    private static String constructCanonicalComment(String string, boolean bl) {
        return string == null ? null : PropertiesConfigurationLayout.trimComment(string, bl);
    }

    static class PropertyLayoutData
    implements Cloneable {
        private StringBuffer comment;
        private String separator = " = ";
        private int blancLines;
        private boolean singleLine = true;

        public int getBlancLines() {
            return this.blancLines;
        }

        public void setBlancLines(int n) {
            this.blancLines = n;
        }

        public boolean isSingleLine() {
            return this.singleLine;
        }

        public void setSingleLine(boolean bl) {
            this.singleLine = bl;
        }

        public void addComment(String string) {
            if (string != null) {
                if (this.comment == null) {
                    this.comment = new StringBuffer(string);
                } else {
                    this.comment.append(PropertiesConfigurationLayout.CR).append(string);
                }
            }
        }

        public void setComment(String string) {
            this.comment = string == null ? null : new StringBuffer(string);
        }

        public String getComment() {
            return this.comment == null ? null : this.comment.toString();
        }

        public String getSeparator() {
            return this.separator;
        }

        public void setSeparator(String string) {
            this.separator = string;
        }

        public PropertyLayoutData clone() {
            try {
                PropertyLayoutData propertyLayoutData = (PropertyLayoutData)super.clone();
                if (this.comment != null) {
                    propertyLayoutData.comment = new StringBuffer(this.getComment());
                }
                return propertyLayoutData;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new ConfigurationRuntimeException(cloneNotSupportedException);
            }
        }
    }
}

