/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.configuration;

import com.secnium.iast.thirdparty.org.apache.commons.beanutils.BeanUtils;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.AbstractHierarchicalFileConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.Configuration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConfigurationException;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConfigurationRuntimeException;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.HierarchicalConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.SubnodeConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.XMLConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.event.ConfigurationErrorEvent;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.event.ConfigurationErrorListener;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.event.ConfigurationEvent;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.event.ConfigurationListener;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.interpol.ConfigurationInterpolator;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.reloading.ReloadingStrategy;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.resolver.EntityResolverSupport;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.tree.ConfigurationNode;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.tree.ExpressionEngine;
import com.secnium.iast.thirdparty.org.apache.commons.lang.text.StrSubstitutor;
import com.secnium.iast.thirdparty.org.apache.commons.logging.Log;
import com.secnium.iast.thirdparty.org.apache.commons.logging.LogFactory;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiFileHierarchicalConfiguration
extends AbstractHierarchicalFileConfiguration
implements ConfigurationErrorListener,
ConfigurationListener,
EntityResolverSupport {
    private static ThreadLocal<Boolean> recursive = new ThreadLocal<Boolean>(){

        @Override
        protected synchronized Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private final ConcurrentMap<String, XMLConfiguration> configurationsMap = new ConcurrentHashMap<String, XMLConfiguration>();
    private String pattern;
    private boolean init;
    private boolean ignoreException = true;
    private boolean schemaValidation;
    private boolean validating;
    private boolean attributeSplittingDisabled;
    private String loggerName = MultiFileHierarchicalConfiguration.class.getName();
    private ReloadingStrategy fileStrategy;
    private EntityResolver entityResolver;
    private StrSubstitutor localSubst = new StrSubstitutor(new ConfigurationInterpolator());

    public MultiFileHierarchicalConfiguration() {
        this.init = true;
        this.setLogger(LogFactory.getLog(this.loggerName));
    }

    public MultiFileHierarchicalConfiguration(String string) {
        this.pattern = string;
        this.init = true;
        this.setLogger(LogFactory.getLog(this.loggerName));
    }

    public void setLoggerName(String string) {
        this.loggerName = string;
    }

    public void setFilePattern(String string) {
        this.pattern = string;
    }

    public boolean isSchemaValidation() {
        return this.schemaValidation;
    }

    public void setSchemaValidation(boolean bl) {
        this.schemaValidation = bl;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setValidating(boolean bl) {
        this.validating = bl;
    }

    public boolean isAttributeSplittingDisabled() {
        return this.attributeSplittingDisabled;
    }

    public void setAttributeSplittingDisabled(boolean bl) {
        this.attributeSplittingDisabled = bl;
    }

    @Override
    public ReloadingStrategy getReloadingStrategy() {
        return this.fileStrategy;
    }

    @Override
    public void setReloadingStrategy(ReloadingStrategy reloadingStrategy) {
        this.fileStrategy = reloadingStrategy;
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setIgnoreException(boolean bl) {
        this.ignoreException = bl;
    }

    @Override
    public void addProperty(String string, Object object) {
        this.getConfiguration().addProperty(string, object);
    }

    @Override
    public void clear() {
        this.getConfiguration().clear();
    }

    @Override
    public void clearProperty(String string) {
        this.getConfiguration().clearProperty(string);
    }

    @Override
    public boolean containsKey(String string) {
        return this.getConfiguration().containsKey(string);
    }

    @Override
    public BigDecimal getBigDecimal(String string, BigDecimal bigDecimal) {
        return this.getConfiguration().getBigDecimal(string, bigDecimal);
    }

    @Override
    public BigDecimal getBigDecimal(String string) {
        return this.getConfiguration().getBigDecimal(string);
    }

    @Override
    public BigInteger getBigInteger(String string, BigInteger bigInteger) {
        return this.getConfiguration().getBigInteger(string, bigInteger);
    }

    @Override
    public BigInteger getBigInteger(String string) {
        return this.getConfiguration().getBigInteger(string);
    }

    @Override
    public boolean getBoolean(String string, boolean bl) {
        return this.getConfiguration().getBoolean(string, bl);
    }

    @Override
    public Boolean getBoolean(String string, Boolean bl) {
        return this.getConfiguration().getBoolean(string, bl);
    }

    @Override
    public boolean getBoolean(String string) {
        return this.getConfiguration().getBoolean(string);
    }

    @Override
    public byte getByte(String string, byte by) {
        return this.getConfiguration().getByte(string, by);
    }

    @Override
    public Byte getByte(String string, Byte by) {
        return this.getConfiguration().getByte(string, by);
    }

    @Override
    public byte getByte(String string) {
        return this.getConfiguration().getByte(string);
    }

    @Override
    public double getDouble(String string, double d2) {
        return this.getConfiguration().getDouble(string, d2);
    }

    @Override
    public Double getDouble(String string, Double d2) {
        return this.getConfiguration().getDouble(string, d2);
    }

    @Override
    public double getDouble(String string) {
        return this.getConfiguration().getDouble(string);
    }

    @Override
    public float getFloat(String string, float f2) {
        return this.getConfiguration().getFloat(string, f2);
    }

    @Override
    public Float getFloat(String string, Float f2) {
        return this.getConfiguration().getFloat(string, f2);
    }

    @Override
    public float getFloat(String string) {
        return this.getConfiguration().getFloat(string);
    }

    @Override
    public int getInt(String string, int n) {
        return this.getConfiguration().getInt(string, n);
    }

    @Override
    public int getInt(String string) {
        return this.getConfiguration().getInt(string);
    }

    @Override
    public Integer getInteger(String string, Integer n) {
        return this.getConfiguration().getInteger(string, n);
    }

    @Override
    public Iterator<String> getKeys() {
        return this.getConfiguration().getKeys();
    }

    @Override
    public Iterator<String> getKeys(String string) {
        return this.getConfiguration().getKeys(string);
    }

    @Override
    public List<Object> getList(String string, List<?> list) {
        return this.getConfiguration().getList(string, list);
    }

    @Override
    public List<Object> getList(String string) {
        return this.getConfiguration().getList(string);
    }

    @Override
    public long getLong(String string, long l) {
        return this.getConfiguration().getLong(string, l);
    }

    @Override
    public Long getLong(String string, Long l) {
        return this.getConfiguration().getLong(string, l);
    }

    @Override
    public long getLong(String string) {
        return this.getConfiguration().getLong(string);
    }

    @Override
    public Properties getProperties(String string) {
        return this.getConfiguration().getProperties(string);
    }

    @Override
    public Object getProperty(String string) {
        return this.getConfiguration().getProperty(string);
    }

    @Override
    public short getShort(String string, short s) {
        return this.getConfiguration().getShort(string, s);
    }

    @Override
    public Short getShort(String string, Short s) {
        return this.getConfiguration().getShort(string, s);
    }

    @Override
    public short getShort(String string) {
        return this.getConfiguration().getShort(string);
    }

    @Override
    public String getString(String string, String string2) {
        return this.getConfiguration().getString(string, string2);
    }

    @Override
    public String getString(String string) {
        return this.getConfiguration().getString(string);
    }

    @Override
    public String[] getStringArray(String string) {
        return this.getConfiguration().getStringArray(string);
    }

    @Override
    public boolean isEmpty() {
        return this.getConfiguration().isEmpty();
    }

    @Override
    public void setProperty(String string, Object object) {
        if (this.init) {
            this.getConfiguration().setProperty(string, object);
        }
    }

    @Override
    public Configuration subset(String string) {
        return this.getConfiguration().subset(string);
    }

    @Override
    public Object getReloadLock() {
        return this.getConfiguration().getReloadLock();
    }

    @Override
    public HierarchicalConfiguration.Node getRoot() {
        return this.getConfiguration().getRoot();
    }

    @Override
    public void setRoot(HierarchicalConfiguration.Node node) {
        if (this.init) {
            this.getConfiguration().setRoot(node);
        } else {
            super.setRoot(node);
        }
    }

    @Override
    public ConfigurationNode getRootNode() {
        return this.getConfiguration().getRootNode();
    }

    @Override
    public void setRootNode(ConfigurationNode configurationNode) {
        if (this.init) {
            this.getConfiguration().setRootNode(configurationNode);
        } else {
            super.setRootNode(configurationNode);
        }
    }

    @Override
    public ExpressionEngine getExpressionEngine() {
        return super.getExpressionEngine();
    }

    @Override
    public void setExpressionEngine(ExpressionEngine expressionEngine) {
        super.setExpressionEngine(expressionEngine);
    }

    @Override
    public void addNodes(String string, Collection<? extends ConfigurationNode> collection) {
        this.getConfiguration().addNodes(string, collection);
    }

    @Override
    public SubnodeConfiguration configurationAt(String string, boolean bl) {
        return this.getConfiguration().configurationAt(string, bl);
    }

    @Override
    public SubnodeConfiguration configurationAt(String string) {
        return this.getConfiguration().configurationAt(string);
    }

    @Override
    public List<HierarchicalConfiguration> configurationsAt(String string) {
        return this.getConfiguration().configurationsAt(string);
    }

    @Override
    public void clearTree(String string) {
        this.getConfiguration().clearTree(string);
    }

    @Override
    public int getMaxIndex(String string) {
        return this.getConfiguration().getMaxIndex(string);
    }

    @Override
    public Configuration interpolatedConfiguration() {
        return this.getConfiguration().interpolatedConfiguration();
    }

    @Override
    public void addConfigurationListener(ConfigurationListener configurationListener) {
        super.addConfigurationListener(configurationListener);
    }

    @Override
    public boolean removeConfigurationListener(ConfigurationListener configurationListener) {
        return super.removeConfigurationListener(configurationListener);
    }

    @Override
    public Collection<ConfigurationListener> getConfigurationListeners() {
        return super.getConfigurationListeners();
    }

    @Override
    public void clearConfigurationListeners() {
        super.clearConfigurationListeners();
    }

    @Override
    public void addErrorListener(ConfigurationErrorListener configurationErrorListener) {
        super.addErrorListener(configurationErrorListener);
    }

    @Override
    public boolean removeErrorListener(ConfigurationErrorListener configurationErrorListener) {
        return super.removeErrorListener(configurationErrorListener);
    }

    @Override
    public void clearErrorListeners() {
        super.clearErrorListeners();
    }

    @Override
    public Collection<ConfigurationErrorListener> getErrorListeners() {
        return super.getErrorListeners();
    }

    @Override
    public void save(Writer writer) throws ConfigurationException {
        if (this.init) {
            this.getConfiguration().save(writer);
        }
    }

    @Override
    public void load(Reader reader) throws ConfigurationException {
        if (this.init) {
            this.getConfiguration().load(reader);
        }
    }

    @Override
    public void load() throws ConfigurationException {
        this.getConfiguration();
    }

    @Override
    public void load(String string) throws ConfigurationException {
        this.getConfiguration().load(string);
    }

    @Override
    public void load(File file) throws ConfigurationException {
        this.getConfiguration().load(file);
    }

    @Override
    public void load(URL uRL) throws ConfigurationException {
        this.getConfiguration().load(uRL);
    }

    @Override
    public void load(InputStream inputStream) throws ConfigurationException {
        this.getConfiguration().load(inputStream);
    }

    @Override
    public void load(InputStream inputStream, String string) throws ConfigurationException {
        this.getConfiguration().load(inputStream, string);
    }

    @Override
    public void save() throws ConfigurationException {
        this.getConfiguration().save();
    }

    @Override
    public void save(String string) throws ConfigurationException {
        this.getConfiguration().save(string);
    }

    @Override
    public void save(File file) throws ConfigurationException {
        this.getConfiguration().save(file);
    }

    @Override
    public void save(URL uRL) throws ConfigurationException {
        this.getConfiguration().save(uRL);
    }

    @Override
    public void save(OutputStream outputStream) throws ConfigurationException {
        this.getConfiguration().save(outputStream);
    }

    @Override
    public void save(OutputStream outputStream, String string) throws ConfigurationException {
        this.getConfiguration().save(outputStream, string);
    }

    @Override
    public void configurationChanged(ConfigurationEvent configurationEvent) {
        if (configurationEvent.getSource() instanceof XMLConfiguration) {
            for (ConfigurationListener configurationListener : this.getConfigurationListeners()) {
                configurationListener.configurationChanged(configurationEvent);
            }
        }
    }

    @Override
    public void configurationError(ConfigurationErrorEvent configurationErrorEvent) {
        if (configurationErrorEvent.getSource() instanceof XMLConfiguration) {
            for (ConfigurationErrorListener configurationErrorListener : this.getErrorListeners()) {
                configurationErrorListener.configurationError(configurationErrorEvent);
            }
        }
        if (configurationErrorEvent.getType() == 20 && this.isThrowable(configurationErrorEvent.getCause())) {
            throw new ConfigurationRuntimeException(configurationErrorEvent.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object resolveContainerStore(String string) {
        if (recursive.get().booleanValue()) {
            return null;
        }
        recursive.set(Boolean.TRUE);
        try {
            Object object = super.resolveContainerStore(string);
            return object;
        }
        finally {
            recursive.set(Boolean.FALSE);
        }
    }

    public void removeConfiguration() {
        String string = this.getSubstitutor().replace(this.pattern);
        this.configurationsMap.remove(string);
    }

    private AbstractHierarchicalFileConfiguration getConfiguration() {
        XMLConfiguration xMLConfiguration;
        String string;
        block7: {
            Object object;
            if (this.pattern == null) {
                throw new ConfigurationRuntimeException("File pattern must be defined");
            }
            string = this.localSubst.replace(this.pattern);
            if (this.configurationsMap.containsKey(string)) {
                return (AbstractHierarchicalFileConfiguration)this.configurationsMap.get(string);
            }
            if (string.equals(this.pattern)) {
                XMLConfiguration xMLConfiguration2 = new XMLConfiguration(){

                    public void load() throws ConfigurationException {
                    }

                    public void save() throws ConfigurationException {
                    }
                };
                this.configurationsMap.putIfAbsent(this.pattern, xMLConfiguration2);
                return xMLConfiguration2;
            }
            xMLConfiguration = new XMLConfiguration();
            if (this.loggerName != null && (object = LogFactory.getLog(this.loggerName)) != null) {
                xMLConfiguration.setLogger((Log)object);
            }
            xMLConfiguration.setBasePath(this.getBasePath());
            xMLConfiguration.setFileName(string);
            xMLConfiguration.setFileSystem(this.getFileSystem());
            xMLConfiguration.setExpressionEngine(this.getExpressionEngine());
            object = this.createReloadingStrategy();
            if (object != null) {
                xMLConfiguration.setReloadingStrategy((ReloadingStrategy)object);
            }
            xMLConfiguration.setDelimiterParsingDisabled(this.isDelimiterParsingDisabled());
            xMLConfiguration.setAttributeSplittingDisabled(this.isAttributeSplittingDisabled());
            xMLConfiguration.setValidating(this.validating);
            xMLConfiguration.setSchemaValidation(this.schemaValidation);
            xMLConfiguration.setEntityResolver(this.entityResolver);
            xMLConfiguration.setListDelimiter(this.getListDelimiter());
            xMLConfiguration.addConfigurationListener(this);
            xMLConfiguration.addErrorListener(this);
            try {
                xMLConfiguration.load();
            }
            catch (ConfigurationException configurationException) {
                if (!this.isThrowable(configurationException)) break block7;
                throw new ConfigurationRuntimeException(configurationException);
            }
        }
        this.configurationsMap.putIfAbsent(string, xMLConfiguration);
        return (AbstractHierarchicalFileConfiguration)this.configurationsMap.get(string);
    }

    private boolean isThrowable(Throwable throwable) {
        Throwable throwable2;
        if (!this.ignoreException) {
            return true;
        }
        for (throwable2 = throwable.getCause(); throwable2 != null && !(throwable2 instanceof SAXParseException); throwable2 = throwable2.getCause()) {
        }
        return throwable2 != null;
    }

    private ReloadingStrategy createReloadingStrategy() {
        if (this.fileStrategy == null) {
            return null;
        }
        try {
            ReloadingStrategy reloadingStrategy = (ReloadingStrategy)BeanUtils.cloneBean((Object)this.fileStrategy);
            reloadingStrategy.setConfiguration(null);
            return reloadingStrategy;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

