/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.configuration;

import com.secnium.iast.thirdparty.org.apache.commons.configuration.AbstractConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConfigurationRuntimeException;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConfigurationUtils;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.PropertyConverter;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapConfiguration
extends AbstractConfiguration
implements Cloneable {
    protected Map<String, Object> map;
    private boolean trimmingDisabled;

    public MapConfiguration(Map<String, ?> map) {
        this.map = map;
    }

    public MapConfiguration(Properties properties) {
        this.map = MapConfiguration.convertPropertiesToMap(properties);
    }

    public Map<String, Object> getMap() {
        return this.map;
    }

    public boolean isTrimmingDisabled() {
        return this.trimmingDisabled;
    }

    public void setTrimmingDisabled(boolean bl) {
        this.trimmingDisabled = bl;
    }

    @Override
    public Object getProperty(String string) {
        Object object = this.map.get(string);
        if (object instanceof String && !this.isDelimiterParsingDisabled()) {
            List<String> list = PropertyConverter.split((String)object, this.getListDelimiter(), !this.isTrimmingDisabled());
            return list.size() > 1 ? list : list.get(0);
        }
        return object;
    }

    @Override
    protected void addPropertyDirect(String string, Object object) {
        Object object2 = this.getProperty(string);
        if (object2 == null) {
            this.map.put(string, object);
        } else if (object2 instanceof List) {
            ((List)object2).add(object);
        } else {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(object2);
            arrayList.add(object);
            this.map.put(string, arrayList);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(String string) {
        return this.map.containsKey(string);
    }

    @Override
    protected void clearPropertyDirect(String string) {
        this.map.remove(string);
    }

    @Override
    public Iterator<String> getKeys() {
        return this.map.keySet().iterator();
    }

    @Override
    public Object clone() {
        try {
            Map map;
            MapConfiguration mapConfiguration = (MapConfiguration)super.clone();
            mapConfiguration.clearConfigurationListeners();
            mapConfiguration.map = map = (Map)ConfigurationUtils.clone(this.map);
            return mapConfiguration;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ConfigurationRuntimeException(cloneNotSupportedException);
        }
    }

    private static Map<String, Object> convertPropertiesToMap(final Properties properties) {
        return new AbstractMap<String, Object>(){

            @Override
            public Set<Map.Entry<String, Object>> entrySet() {
                HashSet<Map.Entry<String, Object>> hashSet = new HashSet<Map.Entry<String, Object>>();
                for (final Map.Entry<Object, Object> entry : properties.entrySet()) {
                    if (!(entry.getKey() instanceof String)) continue;
                    hashSet.add(new Map.Entry<String, Object>(){

                        @Override
                        public String getKey() {
                            return entry.getKey().toString();
                        }

                        @Override
                        public Object getValue() {
                            return entry.getValue();
                        }

                        @Override
                        public Object setValue(Object object) {
                            throw new UnsupportedOperationException();
                        }
                    });
                }
                return hashSet;
            }
        };
    }
}

