/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.configuration;

import com.secnium.iast.thirdparty.org.apache.commons.configuration.AbstractHierarchicalFileConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConfigurationException;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.HierarchicalConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.PropertyConverter;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.SubnodeConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.tree.ConfigurationNode;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.tree.ViewNode;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchicalINIConfiguration
extends AbstractHierarchicalFileConfiguration {
    protected static final String COMMENT_CHARS = "#;";
    protected static final String SEPARATOR_CHARS = "=:";
    private static final long serialVersionUID = 2548006161386850670L;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String QUOTE_CHARACTERS = "\"'";
    private static final String LINE_CONT = "\\";

    public HierarchicalINIConfiguration() {
    }

    public HierarchicalINIConfiguration(String string) throws ConfigurationException {
        super(string);
    }

    public HierarchicalINIConfiguration(File file) throws ConfigurationException {
        super(file);
    }

    public HierarchicalINIConfiguration(URL uRL) throws ConfigurationException {
        super(uRL);
    }

    @Override
    public void save(Writer writer) throws ConfigurationException {
        PrintWriter printWriter = new PrintWriter(writer);
        for (String string : this.getSections()) {
            SubnodeConfiguration subnodeConfiguration;
            if (string != null) {
                printWriter.print("[");
                printWriter.print(string);
                printWriter.print("]");
                printWriter.println();
                subnodeConfiguration = this.createSubnodeConfiguration(this.getSectionNode(string));
            } else {
                subnodeConfiguration = this.getSection(null);
            }
            Iterator<String> iterator = subnodeConfiguration.getKeys();
            while (iterator.hasNext()) {
                String string2 = iterator.next();
                Object object2 = subnodeConfiguration.getProperty(string2);
                if (object2 instanceof Collection) {
                    for (Object object2 : (Collection)object2) {
                        printWriter.print(string2);
                        printWriter.print(" = ");
                        printWriter.print(this.formatValue(object2.toString()));
                        printWriter.println();
                    }
                    continue;
                }
                printWriter.print(string2);
                printWriter.print(" = ");
                printWriter.print(this.formatValue(object2.toString()));
                printWriter.println();
            }
            printWriter.println();
        }
        printWriter.flush();
    }

    @Override
    public void load(Reader reader) throws ConfigurationException {
        try {
            BufferedReader bufferedReader = new BufferedReader(reader);
            ConfigurationNode configurationNode = this.getRootNode();
            String string = bufferedReader.readLine();
            while (string != null) {
                if (!this.isCommentLine(string = string.trim())) {
                    String string2;
                    if (this.isSectionLine(string)) {
                        string2 = string.substring(1, string.length() - 1);
                        configurationNode = this.getSectionNode(string2);
                    } else {
                        string2 = "";
                        String string3 = "";
                        int n = HierarchicalINIConfiguration.findSeparator(string);
                        if (n >= 0) {
                            string2 = string.substring(0, n);
                            string3 = HierarchicalINIConfiguration.parseValue(string.substring(n + 1), bufferedReader);
                        } else {
                            string2 = string;
                        }
                        string2 = string2.trim();
                        if (string2.length() < 1) {
                            string2 = " ";
                        }
                        this.createValueNodes(configurationNode, string2, string3);
                    }
                }
                string = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            throw new ConfigurationException("Unable to load the configuration", iOException);
        }
    }

    private void createValueNodes(ConfigurationNode configurationNode, String string, String string2) {
        Collection<String> collection = this.isDelimiterParsingDisabled() ? Collections.singleton(string2) : PropertyConverter.split(string2, this.getListDelimiter(), false);
        for (String string3 : collection) {
            HierarchicalConfiguration.Node node = this.createNode(string);
            node.setValue(string3);
            configurationNode.addChild(node);
        }
    }

    private static String parseValue(String string, BufferedReader bufferedReader) throws IOException {
        boolean bl;
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = string.trim();
        do {
            int n;
            boolean bl2 = string2.startsWith("\"") || string2.startsWith("'");
            boolean bl3 = false;
            boolean bl4 = false;
            char c2 = bl2 ? string2.charAt(0) : (char)'\u0000';
            StringBuilder stringBuilder2 = new StringBuilder();
            char c3 = '\u0000';
            for (n = bl2 ? 1 : 0; n < string2.length() && !bl3; ++n) {
                char c4 = string2.charAt(n);
                if (bl2) {
                    if ('\\' == c4 && !bl4) {
                        bl4 = true;
                    } else if (!bl4 && c2 == c4) {
                        bl3 = true;
                    } else if (bl4 && c2 == c4) {
                        bl4 = false;
                        stringBuilder2.append(c4);
                    } else {
                        if (bl4) {
                            bl4 = false;
                            stringBuilder2.append('\\');
                        }
                        stringBuilder2.append(c4);
                    }
                } else if (HierarchicalINIConfiguration.isCommentChar(c4) && Character.isWhitespace(c3)) {
                    bl3 = true;
                } else {
                    stringBuilder2.append(c4);
                }
                c3 = c4;
            }
            String string3 = stringBuilder2.toString();
            if (!bl2) {
                bl = HierarchicalINIConfiguration.lineContinues(string3 = string3.trim());
                if (bl) {
                    string3 = string3.substring(0, string3.length() - 1).trim();
                }
            } else {
                bl = HierarchicalINIConfiguration.lineContinues(string2, n);
            }
            stringBuilder.append(string3);
            if (!bl) continue;
            stringBuilder.append(LINE_SEPARATOR);
            string2 = bufferedReader.readLine();
        } while (bl && string2 != null);
        return stringBuilder.toString();
    }

    private static boolean lineContinues(String string) {
        String string2 = string.trim();
        return string2.equals(LINE_CONT) || string2.length() > 2 && string2.endsWith(LINE_CONT) && Character.isWhitespace(string2.charAt(string2.length() - 2));
    }

    private static boolean lineContinues(String string, int n) {
        String string2;
        if (n >= string.length()) {
            string2 = string;
        } else {
            int n2;
            for (n2 = n; n2 < string.length() && !HierarchicalINIConfiguration.isCommentChar(string.charAt(n2)); ++n2) {
            }
            string2 = string.substring(n, n2);
        }
        return HierarchicalINIConfiguration.lineContinues(string2);
    }

    private static boolean isCommentChar(char c2) {
        return COMMENT_CHARS.indexOf(c2) >= 0;
    }

    private static int findSeparator(String string) {
        int n = HierarchicalINIConfiguration.findSeparatorBeforeQuote(string, HierarchicalINIConfiguration.findFirstOccurrence(string, QUOTE_CHARACTERS));
        if (n < 0) {
            n = HierarchicalINIConfiguration.findFirstOccurrence(string, SEPARATOR_CHARS);
        }
        return n;
    }

    private static int findFirstOccurrence(String string, String string2) {
        int n = -1;
        for (int i = 0; i < string2.length(); ++i) {
            char c2 = string2.charAt(i);
            int n2 = string.indexOf(c2);
            if (n2 < 0 || n >= 0 && n2 >= n) continue;
            n = n2;
        }
        return n;
    }

    private static int findSeparatorBeforeQuote(String string, int n) {
        int n2;
        for (n2 = n - 1; n2 >= 0 && Character.isWhitespace(string.charAt(n2)); --n2) {
        }
        if (n2 >= 0 && SEPARATOR_CHARS.indexOf(string.charAt(n2)) < 0) {
            n2 = -1;
        }
        return n2;
    }

    private String formatValue(String string) {
        boolean bl = false;
        for (int i = 0; i < COMMENT_CHARS.length() && !bl; ++i) {
            char c2 = COMMENT_CHARS.charAt(i);
            if (string.indexOf(c2) == -1) continue;
            bl = true;
        }
        if (bl) {
            return '\"' + string.replaceAll("\"", "\\\\\\\"") + '\"';
        }
        return string;
    }

    protected boolean isCommentLine(String string) {
        if (string == null) {
            return false;
        }
        return string.length() < 1 || COMMENT_CHARS.indexOf(string.charAt(0)) >= 0;
    }

    protected boolean isSectionLine(String string) {
        if (string == null) {
            return false;
        }
        return string.startsWith("[") && string.endsWith("]");
    }

    public Set<String> getSections() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        boolean bl = false;
        boolean bl2 = false;
        for (ConfigurationNode configurationNode : this.getRootNode().getChildren()) {
            if (HierarchicalINIConfiguration.isSectionNode(configurationNode)) {
                bl2 = true;
                linkedHashSet.add(configurationNode.getName());
                continue;
            }
            if (bl2 || bl) continue;
            bl = true;
            linkedHashSet.add(null);
        }
        return linkedHashSet;
    }

    public SubnodeConfiguration getSection(String string) {
        if (string == null) {
            return this.getGlobalSection();
        }
        try {
            return this.configurationAt(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new SubnodeConfiguration(this, this.getSectionNode(string));
        }
    }

    private ConfigurationNode getSectionNode(String string) {
        List<ConfigurationNode> list = this.getRootNode().getChildren(string);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        HierarchicalConfiguration.Node node = this.createNode(string);
        HierarchicalINIConfiguration.markSectionNode(node);
        this.getRootNode().addChild(node);
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SubnodeConfiguration getGlobalSection() {
        ViewNode viewNode = new ViewNode();
        for (ConfigurationNode configurationNode : this.getRootNode().getChildren()) {
            if (HierarchicalINIConfiguration.isSectionNode(configurationNode)) continue;
            ConfigurationNode configurationNode2 = configurationNode;
            synchronized (configurationNode2) {
                viewNode.addChild(configurationNode);
            }
        }
        return this.createSubnodeConfiguration(viewNode);
    }

    private static void markSectionNode(ConfigurationNode configurationNode) {
        configurationNode.setReference(Boolean.TRUE);
    }

    private static boolean isSectionNode(ConfigurationNode configurationNode) {
        return configurationNode.getReference() != null || configurationNode.getChildrenCount() > 0;
    }
}

