/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.configuration;

import com.secnium.iast.thirdparty.org.apache.commons.configuration.Configuration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConfigurationKey;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConfigurationXMLReader;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.HierarchicalConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.tree.ConfigurationNode;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class HierarchicalConfigurationXMLReader
extends ConfigurationXMLReader {
    private HierarchicalConfiguration configuration;

    public HierarchicalConfigurationXMLReader() {
    }

    public HierarchicalConfigurationXMLReader(HierarchicalConfiguration hierarchicalConfiguration) {
        this();
        this.setConfiguration(hierarchicalConfiguration);
    }

    public HierarchicalConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(HierarchicalConfiguration hierarchicalConfiguration) {
        this.configuration = hierarchicalConfiguration;
    }

    public Configuration getParsedConfiguration() {
        return this.getConfiguration();
    }

    protected void processKeys() {
        this.getConfiguration().getRoot().visit(new SAXVisitor(), null);
    }

    class SAXVisitor
    extends HierarchicalConfiguration.NodeVisitor {
        private static final String ATTR_TYPE = "CDATA";

        SAXVisitor() {
        }

        public void visitAfterChildren(HierarchicalConfiguration.Node node, ConfigurationKey configurationKey) {
            if (!this.isAttributeNode(node)) {
                HierarchicalConfigurationXMLReader.this.fireElementEnd(this.nodeName(node));
            }
        }

        public void visitBeforeChildren(HierarchicalConfiguration.Node node, ConfigurationKey configurationKey) {
            if (!this.isAttributeNode(node)) {
                HierarchicalConfigurationXMLReader.this.fireElementStart(this.nodeName(node), this.fetchAttributes(node));
                if (node.getValue() != null) {
                    HierarchicalConfigurationXMLReader.this.fireCharacters(node.getValue().toString());
                }
            }
        }

        public boolean terminate() {
            return HierarchicalConfigurationXMLReader.this.getException() != null;
        }

        protected Attributes fetchAttributes(HierarchicalConfiguration.Node node) {
            AttributesImpl attributesImpl = new AttributesImpl();
            for (ConfigurationNode configurationNode : node.getAttributes()) {
                if (configurationNode.getValue() == null) continue;
                String string = configurationNode.getName();
                attributesImpl.addAttribute("", string, string, ATTR_TYPE, configurationNode.getValue().toString());
            }
            return attributesImpl;
        }

        private String nodeName(HierarchicalConfiguration.Node node) {
            return node.getName() == null ? HierarchicalConfigurationXMLReader.this.getRootName() : node.getName();
        }

        private boolean isAttributeNode(HierarchicalConfiguration.Node node) {
            return node.isAttribute();
        }
    }
}

