/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.configuration;

import com.secnium.iast.thirdparty.org.apache.commons.configuration.AbstractConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.Configuration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConfigurationKey;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConfigurationRuntimeException;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.PropertyConverter;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.SubnodeConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.event.ConfigurationEvent;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.event.ConfigurationListener;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.tree.ConfigurationNode;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.tree.ConfigurationNodeVisitorAdapter;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.tree.DefaultConfigurationNode;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.tree.DefaultExpressionEngine;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.tree.ExpressionEngine;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.tree.NodeAddData;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.tree.ViewNode;
import com.secnium.iast.thirdparty.org.apache.commons.lang.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchicalConfiguration
extends AbstractConfiguration
implements Serializable,
Cloneable {
    public static final int EVENT_CLEAR_TREE = 10;
    public static final int EVENT_ADD_NODES = 11;
    public static final int EVENT_SUBNODE_CHANGED = 12;
    private static final long serialVersionUID = 3373812230395363192L;
    private static ExpressionEngine defaultExpressionEngine;
    private Node root;
    private ConfigurationNode rootNode;
    private transient ExpressionEngine expressionEngine;

    public HierarchicalConfiguration() {
        this.setRootNode(new Node());
    }

    public HierarchicalConfiguration(HierarchicalConfiguration hierarchicalConfiguration) {
        this();
        if (hierarchicalConfiguration != null) {
            CloneVisitor cloneVisitor = new CloneVisitor();
            hierarchicalConfiguration.getRootNode().visit(cloneVisitor);
            this.setRootNode(cloneVisitor.getClone());
        }
    }

    public Object getReloadLock() {
        return this;
    }

    public Node getRoot() {
        if (this.root == null && this.rootNode != null) {
            return new Node(this.rootNode);
        }
        return this.root;
    }

    public void setRoot(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("Root node must not be null!");
        }
        this.root = node;
        this.rootNode = null;
    }

    public ConfigurationNode getRootNode() {
        return this.rootNode != null ? this.rootNode : this.root;
    }

    public void setRootNode(ConfigurationNode configurationNode) {
        if (configurationNode == null) {
            throw new IllegalArgumentException("Root node must not be null!");
        }
        this.rootNode = configurationNode;
        this.root = configurationNode instanceof Node ? (Node)configurationNode : null;
    }

    public static synchronized ExpressionEngine getDefaultExpressionEngine() {
        if (defaultExpressionEngine == null) {
            defaultExpressionEngine = new DefaultExpressionEngine();
        }
        return defaultExpressionEngine;
    }

    public static synchronized void setDefaultExpressionEngine(ExpressionEngine expressionEngine) {
        if (expressionEngine == null) {
            throw new IllegalArgumentException("Default expression engine must not be null!");
        }
        defaultExpressionEngine = expressionEngine;
    }

    public ExpressionEngine getExpressionEngine() {
        return this.expressionEngine != null ? this.expressionEngine : HierarchicalConfiguration.getDefaultExpressionEngine();
    }

    public void setExpressionEngine(ExpressionEngine expressionEngine) {
        this.expressionEngine = expressionEngine;
    }

    @Override
    public Object getProperty(String string) {
        List<ConfigurationNode> list = this.fetchNodeList(string);
        if (list.size() == 0) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (ConfigurationNode configurationNode : list) {
            if (configurationNode.getValue() == null) continue;
            arrayList.add(configurationNode.getValue());
        }
        if (arrayList.size() < 1) {
            return null;
        }
        return arrayList.size() == 1 ? arrayList.get(0) : arrayList;
    }

    @Override
    protected void addPropertyDirect(String string, Object object) {
        NodeAddData nodeAddData = this.getExpressionEngine().prepareAdd(this.getRootNode(), string);
        ConfigurationNode configurationNode = this.processNodeAddData(nodeAddData);
        configurationNode.setValue(object);
    }

    public void addNodes(String string, Collection<? extends ConfigurationNode> collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        this.fireEvent(11, string, collection, true);
        List<ConfigurationNode> list = this.fetchNodeList(string);
        ConfigurationNode configurationNode = list.size() == 1 ? list.get(0) : this.processNodeAddData(this.getExpressionEngine().prepareAdd(this.getRootNode(), string));
        if (configurationNode.isAttribute()) {
            throw new IllegalArgumentException("Cannot add nodes to an attribute node!");
        }
        for (ConfigurationNode configurationNode2 : collection) {
            if (configurationNode2.isAttribute()) {
                configurationNode.addAttribute(configurationNode2);
            } else {
                configurationNode.addChild(configurationNode2);
            }
            HierarchicalConfiguration.clearReferences(configurationNode2);
        }
        this.fireEvent(11, string, collection, false);
    }

    @Override
    public boolean isEmpty() {
        return !this.nodeDefined(this.getRootNode());
    }

    @Override
    public Configuration subset(String string) {
        List<ConfigurationNode> list = this.fetchNodeList(string);
        if (list.isEmpty()) {
            return new HierarchicalConfiguration();
        }
        final HierarchicalConfiguration hierarchicalConfiguration = this;
        HierarchicalConfiguration hierarchicalConfiguration2 = new HierarchicalConfiguration(){

            protected Object interpolate(Object object) {
                return hierarchicalConfiguration.interpolate(object);
            }
        };
        CloneVisitor cloneVisitor = new CloneVisitor();
        Object object = null;
        int n = 0;
        for (ConfigurationNode configurationNode : list) {
            if (configurationNode.getValue() != null) {
                object = configurationNode.getValue();
                ++n;
            }
            configurationNode.visit(cloneVisitor);
            for (ConfigurationNode configurationNode2 : cloneVisitor.getClone().getChildren()) {
                hierarchicalConfiguration2.getRootNode().addChild(configurationNode2);
            }
            for (ConfigurationNode configurationNode2 : cloneVisitor.getClone().getAttributes()) {
                hierarchicalConfiguration2.getRootNode().addAttribute(configurationNode2);
            }
        }
        if (n == 1) {
            hierarchicalConfiguration2.getRootNode().setValue(object);
        }
        return hierarchicalConfiguration2.isEmpty() ? new HierarchicalConfiguration() : hierarchicalConfiguration2;
    }

    public SubnodeConfiguration configurationAt(String string, boolean bl) {
        List<ConfigurationNode> list = this.fetchNodeList(string);
        if (list.size() != 1) {
            throw new IllegalArgumentException("Passed in key must select exactly one node: " + string);
        }
        return bl ? this.createSubnodeConfiguration(list.get(0), string) : this.createSubnodeConfiguration(list.get(0));
    }

    public SubnodeConfiguration configurationAt(String string) {
        return this.configurationAt(string, false);
    }

    public List<HierarchicalConfiguration> configurationsAt(String string) {
        List<ConfigurationNode> list = this.fetchNodeList(string);
        ArrayList<HierarchicalConfiguration> arrayList = new ArrayList<HierarchicalConfiguration>(list.size());
        for (ConfigurationNode configurationNode : list) {
            arrayList.add(this.createSubnodeConfiguration(configurationNode));
        }
        return arrayList;
    }

    protected SubnodeConfiguration createSubnodeConfiguration(ConfigurationNode configurationNode) {
        SubnodeConfiguration subnodeConfiguration = new SubnodeConfiguration(this, configurationNode);
        this.registerSubnodeConfiguration(subnodeConfiguration);
        return subnodeConfiguration;
    }

    protected SubnodeConfiguration createSubnodeConfiguration(ConfigurationNode configurationNode, String string) {
        SubnodeConfiguration subnodeConfiguration = this.createSubnodeConfiguration(configurationNode);
        subnodeConfiguration.setSubnodeKey(string);
        return subnodeConfiguration;
    }

    protected void subnodeConfigurationChanged(ConfigurationEvent configurationEvent) {
        this.fireEvent(12, null, configurationEvent, configurationEvent.isBeforeUpdate());
    }

    void registerSubnodeConfiguration(SubnodeConfiguration subnodeConfiguration) {
        subnodeConfiguration.addConfigurationListener(new ConfigurationListener(){

            public void configurationChanged(ConfigurationEvent configurationEvent) {
                HierarchicalConfiguration.this.subnodeConfigurationChanged(configurationEvent);
            }
        });
    }

    @Override
    public boolean containsKey(String string) {
        return this.getProperty(string) != null;
    }

    @Override
    public void setProperty(String string, Object object) {
        this.fireEvent(3, string, object, true);
        Iterator<ConfigurationNode> iterator = this.fetchNodeList(string).iterator();
        Iterator<Object> iterator2 = !this.isDelimiterParsingDisabled() || !(object instanceof String) ? PropertyConverter.toIterator(object, this.getListDelimiter()) : Collections.singleton(object).iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            iterator.next().setValue(iterator2.next());
        }
        while (iterator2.hasNext()) {
            this.addPropertyDirect(string, iterator2.next());
        }
        while (iterator.hasNext()) {
            this.clearNode(iterator.next());
        }
        this.fireEvent(3, string, object, false);
    }

    @Override
    public void clear() {
        this.fireEvent(4, null, null, true);
        this.getRootNode().removeAttributes();
        this.getRootNode().removeChildren();
        this.getRootNode().setValue(null);
        this.fireEvent(4, null, null, false);
    }

    public void clearTree(String string) {
        this.fireEvent(10, string, null, true);
        List<ConfigurationNode> list = this.fetchNodeList(string);
        for (ConfigurationNode configurationNode : list) {
            this.removeNode(configurationNode);
        }
        this.fireEvent(10, string, list, false);
    }

    @Override
    public void clearProperty(String string) {
        this.fireEvent(2, string, null, true);
        List<ConfigurationNode> list = this.fetchNodeList(string);
        for (ConfigurationNode configurationNode : list) {
            this.clearNode(configurationNode);
        }
        this.fireEvent(2, string, null, false);
    }

    @Override
    public Iterator<String> getKeys() {
        DefinedKeysVisitor definedKeysVisitor = new DefinedKeysVisitor();
        this.getRootNode().visit(definedKeysVisitor);
        return definedKeysVisitor.getKeyList().iterator();
    }

    @Override
    public Iterator<String> getKeys(String string) {
        DefinedKeysVisitor definedKeysVisitor = new DefinedKeysVisitor(string);
        if (this.containsKey(string)) {
            definedKeysVisitor.getKeyList().add(string);
        }
        List<ConfigurationNode> list = this.fetchNodeList(string);
        for (ConfigurationNode configurationNode : list) {
            for (ConfigurationNode configurationNode2 : configurationNode.getChildren()) {
                configurationNode2.visit(definedKeysVisitor);
            }
            for (ConfigurationNode configurationNode2 : configurationNode.getAttributes()) {
                configurationNode2.visit(definedKeysVisitor);
            }
        }
        return definedKeysVisitor.getKeyList().iterator();
    }

    public int getMaxIndex(String string) {
        return this.fetchNodeList(string).size() - 1;
    }

    @Override
    public Object clone() {
        try {
            HierarchicalConfiguration hierarchicalConfiguration = (HierarchicalConfiguration)super.clone();
            CloneVisitor cloneVisitor = new CloneVisitor();
            this.getRootNode().visit(cloneVisitor);
            hierarchicalConfiguration.setRootNode(cloneVisitor.getClone());
            return hierarchicalConfiguration;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ConfigurationRuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public Configuration interpolatedConfiguration() {
        HierarchicalConfiguration hierarchicalConfiguration = (HierarchicalConfiguration)this.clone();
        hierarchicalConfiguration.getRootNode().visit(new ConfigurationNodeVisitorAdapter(){

            public void visitAfterChildren(ConfigurationNode configurationNode) {
                configurationNode.setValue(HierarchicalConfiguration.this.interpolate(configurationNode.getValue()));
            }
        });
        return hierarchicalConfiguration;
    }

    protected List<ConfigurationNode> fetchNodeList(String string) {
        return this.getExpressionEngine().query(this.getRootNode(), string);
    }

    @Deprecated
    protected void findPropertyNodes(ConfigurationKey.KeyIterator keyIterator, Node node, Collection<ConfigurationNode> collection) {
    }

    @Deprecated
    protected boolean nodeDefined(Node node) {
        return this.nodeDefined((ConfigurationNode)node);
    }

    protected boolean nodeDefined(ConfigurationNode configurationNode) {
        DefinedVisitor definedVisitor = new DefinedVisitor();
        configurationNode.visit(definedVisitor);
        return definedVisitor.isDefined();
    }

    @Deprecated
    protected void removeNode(Node node) {
        this.removeNode((ConfigurationNode)node);
    }

    protected void removeNode(ConfigurationNode configurationNode) {
        ConfigurationNode configurationNode2 = configurationNode.getParentNode();
        if (configurationNode2 != null) {
            configurationNode2.removeChild(configurationNode);
            if (!this.nodeDefined(configurationNode2)) {
                this.removeNode(configurationNode2);
            }
        }
    }

    @Deprecated
    protected void clearNode(Node node) {
        this.clearNode((ConfigurationNode)node);
    }

    protected void clearNode(ConfigurationNode configurationNode) {
        configurationNode.setValue(null);
        if (!this.nodeDefined(configurationNode)) {
            this.removeNode(configurationNode);
        }
    }

    @Deprecated
    protected Node fetchAddNode(ConfigurationKey.KeyIterator keyIterator, Node node) {
        return null;
    }

    @Deprecated
    protected Node findLastPathNode(ConfigurationKey.KeyIterator keyIterator, Node node) {
        return null;
    }

    @Deprecated
    protected Node createAddPath(ConfigurationKey.KeyIterator keyIterator, Node node) {
        return null;
    }

    protected Node createNode(String string) {
        return new Node(string);
    }

    private ConfigurationNode processNodeAddData(NodeAddData nodeAddData) {
        ConfigurationNode configurationNode = nodeAddData.getParent();
        for (String string : nodeAddData.getPathNodes()) {
            Node node = this.createNode(string);
            configurationNode.addChild(node);
            configurationNode = node;
        }
        Node node = this.createNode(nodeAddData.getNewNodeName());
        if (nodeAddData.isAttribute()) {
            configurationNode.addAttribute(node);
        } else {
            configurationNode.addChild(node);
        }
        return node;
    }

    protected static void clearReferences(ConfigurationNode configurationNode) {
        configurationNode.visit(new ConfigurationNodeVisitorAdapter(){

            public void visitBeforeChildren(ConfigurationNode configurationNode) {
                configurationNode.setReference(null);
            }
        });
    }

    private static Node getNodeFor(Object object) {
        Node node;
        if (object instanceof ViewNode) {
            final ViewNode viewNode = (ViewNode)object;
            node = new Node(viewNode){

                public void setReference(Object object) {
                    super.setReference(object);
                    viewNode.setReference(object);
                }
            };
        } else {
            node = (Node)object;
        }
        return node;
    }

    protected static abstract class BuilderVisitor
    extends NodeVisitor {
        protected BuilderVisitor() {
        }

        public void visitBeforeChildren(Node node, ConfigurationKey configurationKey) {
            LinkedList<ConfigurationNode> linkedList = new LinkedList<ConfigurationNode>(node.getChildren());
            linkedList.addAll(node.getAttributes());
            Iterator iterator = linkedList.iterator();
            Node node2 = null;
            Node node3 = null;
            while (iterator.hasNext()) {
                Object object;
                Object object2;
                do {
                    node2 = node3;
                } while ((node3 = HierarchicalConfiguration.getNodeFor(object2 = iterator.next())).getReference() != null && iterator.hasNext());
                if (node3.getReference() != null) continue;
                object2 = new LinkedList();
                object2.add((Node)node3);
                while (iterator.hasNext() && (node3 = HierarchicalConfiguration.getNodeFor(object = iterator.next())).getReference() == null) {
                    object2.add(node3);
                }
                object = node3.getReference() == null ? null : node3;
                Iterator iterator2 = object2.iterator();
                while (iterator2.hasNext()) {
                    Node node4 = (Node)iterator2.next();
                    if (node4.getReference() != null) continue;
                    Object object3 = this.insert(node4, node, node2, (Node)object);
                    if (object3 != null) {
                        node4.setReference(object3);
                    }
                    node2 = node4;
                }
            }
        }

        protected abstract Object insert(Node var1, Node var2, Node var3, Node var4);
    }

    static class CloneVisitor
    extends ConfigurationNodeVisitorAdapter {
        private Stack<ConfigurationNode> copyStack = new Stack();
        private ConfigurationNode result;

        public void visitAfterChildren(ConfigurationNode configurationNode) {
            ConfigurationNode configurationNode2 = this.copyStack.pop();
            if (this.copyStack.isEmpty()) {
                this.result = configurationNode2;
            }
        }

        public void visitBeforeChildren(ConfigurationNode configurationNode) {
            ConfigurationNode configurationNode2 = (ConfigurationNode)configurationNode.clone();
            configurationNode2.setParentNode(null);
            if (!this.copyStack.isEmpty()) {
                if (configurationNode.isAttribute()) {
                    this.copyStack.peek().addAttribute(configurationNode2);
                } else {
                    this.copyStack.peek().addChild(configurationNode2);
                }
            }
            this.copyStack.push(configurationNode2);
        }

        public ConfigurationNode getClone() {
            return this.result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DefinedKeysVisitor
    extends ConfigurationNodeVisitorAdapter {
        private Set<String> keyList = new LinkedHashSet<String>();
        private Stack<String> parentKeys = new Stack();

        public DefinedKeysVisitor() {
        }

        public DefinedKeysVisitor(String string) {
            this();
            this.parentKeys.push(string);
        }

        public Set<String> getKeyList() {
            return this.keyList;
        }

        @Override
        public void visitAfterChildren(ConfigurationNode configurationNode) {
            this.parentKeys.pop();
        }

        @Override
        public void visitBeforeChildren(ConfigurationNode configurationNode) {
            String string = this.parentKeys.isEmpty() ? null : this.parentKeys.peek();
            String string2 = HierarchicalConfiguration.this.getExpressionEngine().nodeKey(configurationNode, string);
            this.parentKeys.push(string2);
            if (configurationNode.getValue() != null) {
                this.keyList.add(string2);
            }
        }
    }

    static class DefinedVisitor
    extends ConfigurationNodeVisitorAdapter {
        private boolean defined;

        DefinedVisitor() {
        }

        public boolean terminate() {
            return this.isDefined();
        }

        public void visitBeforeChildren(ConfigurationNode configurationNode) {
            this.defined = configurationNode.getValue() != null;
        }

        public boolean isDefined() {
            return this.defined;
        }
    }

    public static class NodeVisitor {
        public void visitBeforeChildren(Node node, ConfigurationKey configurationKey) {
        }

        public void visitAfterChildren(Node node, ConfigurationKey configurationKey) {
        }

        public boolean terminate() {
            return false;
        }
    }

    public static class Node
    extends DefaultConfigurationNode
    implements Serializable {
        private static final long serialVersionUID = -6357500633536941775L;

        public Node() {
        }

        public Node(String string) {
            super(string);
        }

        public Node(String string, Object object) {
            super(string, object);
        }

        public Node(ConfigurationNode configurationNode) {
            this(configurationNode.getName(), configurationNode.getValue());
            ConfigurationNode configurationNode2;
            this.setReference(configurationNode.getReference());
            for (ConfigurationNode configurationNode3 : configurationNode.getChildren()) {
                configurationNode2 = configurationNode3.getParentNode();
                this.addChild(configurationNode3);
                configurationNode3.setParentNode(configurationNode2);
            }
            for (ConfigurationNode configurationNode3 : configurationNode.getAttributes()) {
                configurationNode2 = configurationNode3.getParentNode();
                this.addAttribute(configurationNode3);
                configurationNode3.setParentNode(configurationNode2);
            }
        }

        public Node getParent() {
            return (Node)this.getParentNode();
        }

        public void setParent(Node node) {
            this.setParentNode(node);
        }

        public void addChild(Node node) {
            this.addChild((ConfigurationNode)node);
        }

        public boolean hasChildren() {
            return this.getChildrenCount() > 0 || this.getAttributeCount() > 0;
        }

        public boolean remove(Node node) {
            return node.isAttribute() ? this.removeAttribute(node) : this.removeChild(node);
        }

        public boolean remove(String string) {
            boolean bl = this.removeChild(string);
            boolean bl2 = this.removeAttribute(string);
            return bl || bl2;
        }

        public void visit(NodeVisitor nodeVisitor, ConfigurationKey configurationKey) {
            ConfigurationNode configurationNode;
            int n = 0;
            if (configurationKey != null) {
                n = configurationKey.length();
                if (this.getName() != null) {
                    configurationKey.append(StringUtils.replace(this.isAttribute() ? ConfigurationKey.constructAttributeKey(this.getName()) : this.getName(), String.valueOf('.'), ConfigurationKey.ESCAPED_DELIMITER));
                }
            }
            nodeVisitor.visitBeforeChildren(this, configurationKey);
            Iterator<ConfigurationNode> iterator = this.getChildren().iterator();
            while (iterator.hasNext() && !nodeVisitor.terminate()) {
                configurationNode = iterator.next();
                HierarchicalConfiguration.getNodeFor(configurationNode).visit(nodeVisitor, configurationKey);
            }
            iterator = this.getAttributes().iterator();
            while (iterator.hasNext() && !nodeVisitor.terminate()) {
                configurationNode = iterator.next();
                HierarchicalConfiguration.getNodeFor(configurationNode).visit(nodeVisitor, configurationKey);
            }
            nodeVisitor.visitAfterChildren(this, configurationKey);
            if (configurationKey != null) {
                configurationKey.setLength(n);
            }
        }
    }
}

