/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.configuration;

import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConfigurationException;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.DefaultFileSystem;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.FileOptionsProvider;
import com.secnium.iast.thirdparty.org.apache.commons.logging.Log;
import com.secnium.iast.thirdparty.org.apache.commons.logging.LogFactory;
import com.secnium.iast.thirdparty.org.apache.commons.logging.impl.NoOpLog;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;

public abstract class FileSystem {
    private static final String FILE_SYSTEM = "com.secnium.iast.thirdparty.org.apache.commons.configuration.filesystem";
    private static FileSystem fileSystem;
    private Log log;
    private FileOptionsProvider optionsProvider;

    public FileSystem() {
        this.setLogger(null);
    }

    public Log getLogger() {
        return this.log;
    }

    public void setLogger(Log log) {
        this.log = log != null ? log : new NoOpLog();
    }

    public static void setDefaultFileSystem(FileSystem fileSystem) throws NullPointerException {
        if (fileSystem == null) {
            throw new NullPointerException("A FileSystem implementation is required");
        }
        FileSystem.fileSystem = fileSystem;
    }

    public static void resetDefaultFileSystem() {
        fileSystem = new DefaultFileSystem();
    }

    public static FileSystem getDefaultFileSystem() {
        return fileSystem;
    }

    public void setFileOptionsProvider(FileOptionsProvider fileOptionsProvider) {
        this.optionsProvider = fileOptionsProvider;
    }

    public FileOptionsProvider getFileOptionsProvider() {
        return this.optionsProvider;
    }

    public abstract InputStream getInputStream(String var1, String var2) throws ConfigurationException;

    public abstract InputStream getInputStream(URL var1) throws ConfigurationException;

    public abstract OutputStream getOutputStream(URL var1) throws ConfigurationException;

    public abstract OutputStream getOutputStream(File var1) throws ConfigurationException;

    public abstract String getPath(File var1, URL var2, String var3, String var4);

    public abstract String getBasePath(String var1);

    public abstract String getFileName(String var1);

    public abstract URL locateFromURL(String var1, String var2);

    public abstract URL getURL(String var1, String var2) throws MalformedURLException;

    static {
        String string = System.getProperty(FILE_SYSTEM);
        if (string != null) {
            Log log = LogFactory.getLog(FileSystem.class);
            try {
                Class<?> clazz = Class.forName(string);
                if (FileSystem.class.isAssignableFrom(clazz)) {
                    fileSystem = (FileSystem)clazz.newInstance();
                    if (log.isDebugEnabled()) {
                        log.debug("Using " + string);
                    }
                }
            }
            catch (InstantiationException instantiationException) {
                log.error("Unable to create " + string, instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                log.error("Unable to create " + string, illegalAccessException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                log.error("Unable to create " + string, classNotFoundException);
            }
        }
        if (fileSystem == null) {
            fileSystem = new DefaultFileSystem();
        }
    }
}

