/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.configuration;

import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConfigurationException;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConfigurationUtils;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.FileSystem;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.VerifiableOutputStream;
import com.secnium.iast.thirdparty.org.apache.commons.logging.Log;
import com.secnium.iast.thirdparty.org.apache.commons.logging.LogFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class DefaultFileSystem
extends FileSystem {
    private Log log = LogFactory.getLog(DefaultFileSystem.class);

    public InputStream getInputStream(String string, String string2) throws ConfigurationException {
        try {
            URL uRL = ConfigurationUtils.locate(this, string, string2);
            if (uRL == null) {
                throw new ConfigurationException("Cannot locate configuration source " + string2);
            }
            return this.getInputStream(uRL);
        }
        catch (ConfigurationException configurationException) {
            throw configurationException;
        }
        catch (Exception exception) {
            throw new ConfigurationException("Unable to load the configuration file " + string2, exception);
        }
    }

    public InputStream getInputStream(URL uRL) throws ConfigurationException {
        File file = ConfigurationUtils.fileFromURL(uRL);
        if (file != null && file.isDirectory()) {
            throw new ConfigurationException("Cannot load a configuration from a directory");
        }
        try {
            return uRL.openStream();
        }
        catch (Exception exception) {
            throw new ConfigurationException("Unable to load the configuration from the URL " + uRL, exception);
        }
    }

    public OutputStream getOutputStream(URL uRL) throws ConfigurationException {
        File file = ConfigurationUtils.fileFromURL(uRL);
        if (file != null) {
            return this.getOutputStream(file);
        }
        try {
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setDoOutput(true);
            if (uRLConnection instanceof HttpURLConnection) {
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                httpURLConnection.setRequestMethod("PUT");
            }
            OutputStream outputStream = uRLConnection.getOutputStream();
            if (uRLConnection instanceof HttpURLConnection) {
                outputStream = new HttpOutputStream(outputStream, (HttpURLConnection)uRLConnection);
            }
            return outputStream;
        }
        catch (IOException iOException) {
            throw new ConfigurationException("Could not save to URL " + uRL, iOException);
        }
    }

    public OutputStream getOutputStream(File file) throws ConfigurationException {
        try {
            this.createPath(file);
            return new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ConfigurationException("Unable to save to file " + file, fileNotFoundException);
        }
    }

    public String getPath(File file, URL uRL, String string, String string2) {
        String string3;
        block6: {
            string3 = null;
            if (file != null) {
                string3 = file.getAbsolutePath();
            }
            if (string3 == null) {
                if (uRL != null) {
                    string3 = uRL.getPath();
                } else {
                    try {
                        string3 = this.getURL(string, string2).getPath();
                    }
                    catch (Exception exception) {
                        if (!this.log.isDebugEnabled()) break block6;
                        this.log.debug(String.format("Could not determine URL for basePath = %s, fileName = %s.", string, string2), exception);
                    }
                }
            }
        }
        return string3;
    }

    public String getBasePath(String string) {
        try {
            URL uRL = this.getURL(null, string);
            return ConfigurationUtils.getBasePath(uRL);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getFileName(String string) {
        try {
            URL uRL = this.getURL(null, string);
            return ConfigurationUtils.getFileName(uRL);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public URL getURL(String string, String string2) throws MalformedURLException {
        File file = new File(string2);
        if (file.isAbsolute()) {
            return ConfigurationUtils.toURL(file);
        }
        try {
            if (string == null) {
                return new URL(string2);
            }
            URL uRL = new URL(string);
            return new URL(uRL, string2);
        }
        catch (MalformedURLException malformedURLException) {
            return ConfigurationUtils.toURL(ConfigurationUtils.constructFile(string, string2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL locateFromURL(String string, String string2) {
        try {
            if (string == null) {
                return new URL(string2);
            }
            URL uRL = new URL(string);
            URL uRL2 = new URL(uRL, string2);
            InputStream inputStream = null;
            try {
                inputStream = uRL2.openStream();
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            return uRL2;
        }
        catch (IOException iOException) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Could not locate file " + string2 + " at " + string + ": " + iOException.getMessage());
            }
            return null;
        }
    }

    private void createPath(File file) {
        File file2;
        if (file != null && !file.exists() && (file2 = file.getParentFile()) != null && !file2.exists()) {
            file2.mkdirs();
        }
    }

    private static class HttpOutputStream
    extends VerifiableOutputStream {
        private final OutputStream stream;
        private final HttpURLConnection connection;

        public HttpOutputStream(OutputStream outputStream, HttpURLConnection httpURLConnection) {
            this.stream = outputStream;
            this.connection = httpURLConnection;
        }

        public void write(byte[] byArray) throws IOException {
            this.stream.write(byArray);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.stream.write(byArray, n, n2);
        }

        public void flush() throws IOException {
            this.stream.flush();
        }

        public void close() throws IOException {
            this.stream.close();
        }

        public void write(int n) throws IOException {
            this.stream.write(n);
        }

        public String toString() {
            return this.stream.toString();
        }

        public void verify() throws IOException {
            if (this.connection.getResponseCode() >= 400) {
                throw new IOException("HTTP Error " + this.connection.getResponseCode() + " " + this.connection.getResponseMessage());
            }
        }
    }
}

