/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.configuration;

import com.secnium.iast.thirdparty.org.apache.commons.configuration.AbstractConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.PropertyConverter;
import com.secnium.iast.thirdparty.org.apache.commons.logging.LogFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseConfiguration
extends AbstractConfiguration {
    private final DataSource datasource;
    private final String table;
    private final String nameColumn;
    private final String keyColumn;
    private final String valueColumn;
    private final String name;
    private final boolean doCommits;

    public DatabaseConfiguration(DataSource dataSource, String string, String string2, String string3, String string4, String string5) {
        this(dataSource, string, string2, string3, string4, string5, false);
    }

    public DatabaseConfiguration(DataSource dataSource, String string, String string2, String string3, String string4, String string5, boolean bl) {
        this.datasource = dataSource;
        this.table = string;
        this.nameColumn = string2;
        this.keyColumn = string3;
        this.valueColumn = string4;
        this.name = string5;
        this.doCommits = bl;
        this.setLogger(LogFactory.getLog(this.getClass()));
        this.addErrorLogListener();
    }

    public DatabaseConfiguration(DataSource dataSource, String string, String string2, String string3) {
        this(dataSource, string, null, string2, string3, null);
    }

    public DatabaseConfiguration(DataSource dataSource, String string, String string2, String string3, boolean bl) {
        this(dataSource, string, null, string2, string3, null, bl);
    }

    public boolean isDoCommits() {
        return this.doCommits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getProperty(String string) {
        ArrayList<Object> arrayList = null;
        StringBuilder stringBuilder = new StringBuilder("SELECT * FROM ");
        stringBuilder.append(this.table).append(" WHERE ");
        stringBuilder.append(this.keyColumn).append("=?");
        if (this.nameColumn != null) {
            stringBuilder.append(" AND " + this.nameColumn + "=?");
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement(stringBuilder.toString());
            preparedStatement.setString(1, string);
            if (this.nameColumn != null) {
                preparedStatement.setString(2, this.name);
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            while (resultSet.next()) {
                Object object = resultSet.getObject(this.valueColumn);
                if (this.isDelimiterParsingDisabled()) {
                    arrayList2.add(object);
                    continue;
                }
                Iterator<?> iterator = PropertyConverter.toIterator(object, this.getListDelimiter());
                while (iterator.hasNext()) {
                    arrayList2.add(iterator.next());
                }
            }
            if (!arrayList2.isEmpty()) {
                arrayList = arrayList2.size() > 1 ? arrayList2 : arrayList2.get(0);
            }
            this.close(connection, preparedStatement, resultSet);
        }
        catch (SQLException sQLException) {
            try {
                this.fireError(5, string, null, sQLException);
                this.close(connection, preparedStatement, resultSet);
            }
            catch (Throwable throwable) {
                this.close(connection, preparedStatement, resultSet);
                throw throwable;
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addPropertyDirect(String string, Object object) {
        StringBuilder stringBuilder = new StringBuilder("INSERT INTO " + this.table);
        if (this.nameColumn != null) {
            stringBuilder.append(" (" + this.nameColumn + ", " + this.keyColumn + ", " + this.valueColumn + ") VALUES (?, ?, ?)");
        } else {
            stringBuilder.append(" (" + this.keyColumn + ", " + this.valueColumn + ") VALUES (?, ?)");
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement(stringBuilder.toString());
            int n = 1;
            if (this.nameColumn != null) {
                preparedStatement.setString(n++, this.name);
            }
            preparedStatement.setString(n++, string);
            preparedStatement.setString(n++, String.valueOf(object));
            preparedStatement.executeUpdate();
            this.commitIfRequired(connection);
            this.close(connection, preparedStatement, null);
        }
        catch (SQLException sQLException) {
            try {
                this.fireError(1, string, object, sQLException);
                this.close(connection, preparedStatement, null);
            }
            catch (Throwable throwable) {
                this.close(connection, preparedStatement, null);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addProperty(String string, Object object) {
        boolean bl = this.isDelimiterParsingDisabled();
        try {
            if (object instanceof String) {
                this.setDelimiterParsingDisabled(true);
            }
            super.addProperty(string, object);
        }
        finally {
            this.setDelimiterParsingDisabled(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        boolean bl = true;
        StringBuilder stringBuilder = new StringBuilder("SELECT count(*) FROM " + this.table);
        if (this.nameColumn != null) {
            stringBuilder.append(" WHERE " + this.nameColumn + "=?");
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement(stringBuilder.toString());
            if (this.nameColumn != null) {
                preparedStatement.setString(1, this.name);
            }
            if ((resultSet = preparedStatement.executeQuery()).next()) {
                bl = resultSet.getInt(1) == 0;
            }
            this.close(connection, preparedStatement, resultSet);
        }
        catch (SQLException sQLException) {
            try {
                this.fireError(5, null, null, sQLException);
                this.close(connection, preparedStatement, resultSet);
            }
            catch (Throwable throwable) {
                this.close(connection, preparedStatement, resultSet);
                throw throwable;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(String string) {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder("SELECT * FROM " + this.table + " WHERE " + this.keyColumn + "=?");
        if (this.nameColumn != null) {
            stringBuilder.append(" AND " + this.nameColumn + "=?");
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement(stringBuilder.toString());
            preparedStatement.setString(1, string);
            if (this.nameColumn != null) {
                preparedStatement.setString(2, this.name);
            }
            resultSet = preparedStatement.executeQuery();
            bl = resultSet.next();
            this.close(connection, preparedStatement, resultSet);
        }
        catch (SQLException sQLException) {
            try {
                this.fireError(5, string, null, sQLException);
                this.close(connection, preparedStatement, resultSet);
            }
            catch (Throwable throwable) {
                this.close(connection, preparedStatement, resultSet);
                throw throwable;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void clearPropertyDirect(String string) {
        StringBuilder stringBuilder = new StringBuilder("DELETE FROM " + this.table + " WHERE " + this.keyColumn + "=?");
        if (this.nameColumn != null) {
            stringBuilder.append(" AND " + this.nameColumn + "=?");
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement(stringBuilder.toString());
            preparedStatement.setString(1, string);
            if (this.nameColumn != null) {
                preparedStatement.setString(2, this.name);
            }
            preparedStatement.executeUpdate();
            this.commitIfRequired(connection);
            this.close(connection, preparedStatement, null);
        }
        catch (SQLException sQLException) {
            try {
                this.fireError(2, string, null, sQLException);
                this.close(connection, preparedStatement, null);
            }
            catch (Throwable throwable) {
                this.close(connection, preparedStatement, null);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.fireEvent(4, null, null, true);
        StringBuilder stringBuilder = new StringBuilder("DELETE FROM " + this.table);
        if (this.nameColumn != null) {
            stringBuilder.append(" WHERE " + this.nameColumn + "=?");
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement(stringBuilder.toString());
            if (this.nameColumn != null) {
                preparedStatement.setString(1, this.name);
            }
            preparedStatement.executeUpdate();
            this.commitIfRequired(connection);
            this.close(connection, preparedStatement, null);
        }
        catch (SQLException sQLException) {
            try {
                this.fireError(4, null, null, sQLException);
                this.close(connection, preparedStatement, null);
            }
            catch (Throwable throwable) {
                this.close(connection, preparedStatement, null);
                throw throwable;
            }
        }
        this.fireEvent(4, null, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<String> getKeys() {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder("SELECT DISTINCT " + this.keyColumn + " FROM " + this.table);
        if (this.nameColumn != null) {
            stringBuilder.append(" WHERE " + this.nameColumn + "=?");
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement(stringBuilder.toString());
            if (this.nameColumn != null) {
                preparedStatement.setString(1, this.name);
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(1));
            }
            this.close(connection, preparedStatement, resultSet);
        }
        catch (SQLException sQLException) {
            try {
                this.fireError(5, null, null, sQLException);
                this.close(connection, preparedStatement, resultSet);
            }
            catch (Throwable throwable) {
                this.close(connection, preparedStatement, resultSet);
                throw throwable;
            }
        }
        return arrayList.iterator();
    }

    public DataSource getDatasource() {
        return this.datasource;
    }

    @Deprecated
    protected Connection getConnection() throws SQLException {
        return this.getDatasource().getConnection();
    }

    private void close(Connection connection, Statement statement, ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            this.getLogger().error("An error occurred on closing the result set", sQLException);
        }
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            this.getLogger().error("An error occured on closing the statement", sQLException);
        }
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            this.getLogger().error("An error occured on closing the connection", sQLException);
        }
    }

    private void commitIfRequired(Connection connection) throws SQLException {
        if (this.isDoCommits()) {
            connection.commit();
        }
    }
}

