/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.configuration;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

@Deprecated
public class ConfigurationKey
implements Serializable {
    public static final char PROPERTY_DELIMITER = '.';
    public static final String ESCAPED_DELIMITER = String.valueOf('.') + String.valueOf('.');
    private static final String ATTRIBUTE_START = "[@";
    private static final String ATTRIBUTE_END = "]";
    private static final char INDEX_START = '(';
    private static final char INDEX_END = ')';
    private static final int INITIAL_SIZE = 32;
    private static final long serialVersionUID = -4299732083605277656L;
    private StringBuilder keyBuffer;

    public ConfigurationKey() {
        this.keyBuffer = new StringBuilder(32);
    }

    public ConfigurationKey(String string) {
        this.keyBuffer = new StringBuilder(string);
        this.removeTrailingDelimiter();
    }

    public ConfigurationKey append(String string) {
        if (this.keyBuffer.length() > 0 && !this.hasDelimiter() && !ConfigurationKey.isAttributeKey(string)) {
            this.keyBuffer.append('.');
        }
        this.keyBuffer.append(string);
        this.removeTrailingDelimiter();
        return this;
    }

    public ConfigurationKey appendIndex(int n) {
        this.keyBuffer.append('(').append(n);
        this.keyBuffer.append(')');
        return this;
    }

    public ConfigurationKey appendAttribute(String string) {
        this.keyBuffer.append(ConfigurationKey.constructAttributeKey(string));
        return this;
    }

    public boolean isAttributeKey() {
        return ConfigurationKey.isAttributeKey(this.keyBuffer.toString());
    }

    public static boolean isAttributeKey(String string) {
        return string != null && string.startsWith(ATTRIBUTE_START) && string.endsWith(ATTRIBUTE_END);
    }

    public static String constructAttributeKey(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ATTRIBUTE_START).append(string).append(ATTRIBUTE_END);
        return stringBuilder.toString();
    }

    public static String attributeName(String string) {
        return ConfigurationKey.isAttributeKey(string) ? ConfigurationKey.removeAttributeMarkers(string) : string;
    }

    static String removeAttributeMarkers(String string) {
        return string.substring(ATTRIBUTE_START.length(), string.length() - ATTRIBUTE_END.length());
    }

    private boolean hasDelimiter() {
        int n = 0;
        for (int i = this.keyBuffer.length() - 1; i >= 0 && this.keyBuffer.charAt(i) == '.'; --i) {
            ++n;
        }
        return n % 2 != 0;
    }

    private void removeTrailingDelimiter() {
        while (this.hasDelimiter()) {
            this.keyBuffer.deleteCharAt(this.keyBuffer.length() - 1);
        }
    }

    public String toString() {
        return this.keyBuffer.toString();
    }

    public KeyIterator iterator() {
        return new KeyIterator();
    }

    public int length() {
        return this.keyBuffer.length();
    }

    public void setLength(int n) {
        this.keyBuffer.setLength(n);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        return this.keyBuffer.toString().equals(object.toString());
    }

    public int hashCode() {
        return String.valueOf(this.keyBuffer).hashCode();
    }

    public ConfigurationKey commonKey(ConfigurationKey configurationKey) {
        if (configurationKey == null) {
            throw new IllegalArgumentException("Other key must no be null!");
        }
        ConfigurationKey configurationKey2 = new ConfigurationKey();
        KeyIterator keyIterator = this.iterator();
        KeyIterator keyIterator2 = configurationKey.iterator();
        while (keyIterator.hasNext() && keyIterator2.hasNext() && ConfigurationKey.partsEqual(keyIterator, keyIterator2)) {
            if (keyIterator.isAttribute()) {
                configurationKey2.appendAttribute(keyIterator.currentKey());
                continue;
            }
            configurationKey2.append(keyIterator.currentKey());
            if (!keyIterator.hasIndex) continue;
            configurationKey2.appendIndex(keyIterator.getIndex());
        }
        return configurationKey2;
    }

    public ConfigurationKey differenceKey(ConfigurationKey configurationKey) {
        ConfigurationKey configurationKey2 = this.commonKey(configurationKey);
        ConfigurationKey configurationKey3 = new ConfigurationKey();
        if (configurationKey2.length() < configurationKey.length()) {
            int n;
            String string = configurationKey.toString().substring(configurationKey2.length());
            for (n = 0; n < string.length() && string.charAt(n) == '.'; ++n) {
            }
            if (n < string.length()) {
                configurationKey3.append(string.substring(n));
            }
        }
        return configurationKey3;
    }

    private static boolean partsEqual(KeyIterator keyIterator, KeyIterator keyIterator2) {
        return keyIterator.nextKey().equals(keyIterator2.nextKey()) && keyIterator.getIndex() == keyIterator2.getIndex() && keyIterator.isAttribute() == keyIterator2.isAttribute();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class KeyIterator
    implements Cloneable,
    Iterator<Object> {
        private String current;
        private int startIndex;
        private int endIndex;
        private int indexValue;
        private boolean hasIndex;
        private boolean attribute;

        private String findNextIndices() {
            this.startIndex = this.endIndex;
            while (this.startIndex < ConfigurationKey.this.keyBuffer.length() && ConfigurationKey.this.keyBuffer.charAt(this.startIndex) == '.') {
                ++this.startIndex;
            }
            if (this.startIndex >= ConfigurationKey.this.keyBuffer.length()) {
                this.endIndex = ConfigurationKey.this.keyBuffer.length();
                this.startIndex = this.endIndex - 1;
                return ConfigurationKey.this.keyBuffer.substring(this.startIndex, this.endIndex);
            }
            return this.nextKeyPart();
        }

        private String nextKeyPart() {
            StringBuilder stringBuilder = new StringBuilder(32);
            int n = this.startIndex;
            int n2 = ConfigurationKey.this.keyBuffer.toString().indexOf(ConfigurationKey.ATTRIBUTE_START, this.startIndex);
            if (n2 < 0 || n2 == this.startIndex) {
                n2 = ConfigurationKey.this.keyBuffer.length();
            }
            boolean bl = false;
            while (!bl && n < n2) {
                char c2 = ConfigurationKey.this.keyBuffer.charAt(n);
                if (c2 == '.') {
                    if (n == n2 - 1 || ConfigurationKey.this.keyBuffer.charAt(n + 1) != '.') {
                        bl = true;
                    } else {
                        ++n;
                    }
                }
                if (bl) continue;
                stringBuilder.append(c2);
                ++n;
            }
            this.endIndex = n;
            return stringBuilder.toString();
        }

        public String nextKey() {
            return this.nextKey(false);
        }

        public String nextKey(boolean bl) {
            String string;
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more key parts!");
            }
            this.hasIndex = false;
            this.indexValue = -1;
            this.current = string = this.findNextIndices();
            this.hasIndex = this.checkIndex(string);
            this.attribute = this.checkAttribute(this.current);
            return this.currentKey(bl);
        }

        private boolean checkAttribute(String string) {
            if (ConfigurationKey.isAttributeKey(string)) {
                this.current = ConfigurationKey.removeAttributeMarkers(string);
                return true;
            }
            return false;
        }

        private boolean checkIndex(String string) {
            int n;
            boolean bl = false;
            int n2 = string.lastIndexOf(40);
            if (n2 > 0 && (n = string.indexOf(41, n2)) > n2 + 1) {
                this.indexValue = Integer.parseInt(string.substring(n2 + 1, n));
                this.current = string.substring(0, n2);
                bl = true;
            }
            return bl;
        }

        @Override
        public boolean hasNext() {
            return this.endIndex < ConfigurationKey.this.keyBuffer.length();
        }

        @Override
        public Object next() {
            return this.nextKey();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported!");
        }

        public String currentKey() {
            return this.currentKey(false);
        }

        public String currentKey(boolean bl) {
            return bl && this.isAttribute() ? ConfigurationKey.constructAttributeKey(this.current) : this.current;
        }

        public boolean isAttribute() {
            return this.attribute;
        }

        public int getIndex() {
            return this.indexValue;
        }

        public boolean hasIndex() {
            return this.hasIndex;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }
    }
}

