/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.configuration;

import com.secnium.iast.thirdparty.org.apache.commons.configuration.AbstractFileConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConfigurationException;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.FileConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.FileSystem;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.FileSystemBased;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.HierarchicalConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.event.ConfigurationErrorEvent;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.event.ConfigurationErrorListener;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.event.ConfigurationEvent;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.event.ConfigurationListener;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.reloading.Reloadable;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.reloading.ReloadingStrategy;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.tree.ConfigurationNode;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHierarchicalFileConfiguration
extends HierarchicalConfiguration
implements FileConfiguration,
FileSystemBased,
ConfigurationErrorListener,
ConfigurationListener,
Reloadable {
    private FileConfigurationDelegate delegate;

    protected AbstractHierarchicalFileConfiguration() {
        this.initialize();
    }

    protected AbstractHierarchicalFileConfiguration(HierarchicalConfiguration hierarchicalConfiguration) {
        super(hierarchicalConfiguration);
        this.initialize();
    }

    public AbstractHierarchicalFileConfiguration(String string) throws ConfigurationException {
        this();
        this.delegate.setFileName(string);
        this.load();
    }

    public AbstractHierarchicalFileConfiguration(File file) throws ConfigurationException {
        this();
        this.setFile(file);
        if (file.exists()) {
            this.load();
        }
    }

    public AbstractHierarchicalFileConfiguration(URL uRL) throws ConfigurationException {
        this();
        this.setURL(uRL);
        this.load();
    }

    private void initialize() {
        this.delegate = this.createDelegate();
        this.initDelegate(this.delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addPropertyDirect(String string, Object object) {
        Object object2 = this.delegate.getReloadLock();
        synchronized (object2) {
            super.addPropertyDirect(string, object);
            this.delegate.possiblySave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearProperty(String string) {
        Object object = this.delegate.getReloadLock();
        synchronized (object) {
            super.clearProperty(string);
            this.delegate.possiblySave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearTree(String string) {
        Object object = this.delegate.getReloadLock();
        synchronized (object) {
            super.clearTree(string);
            this.delegate.possiblySave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperty(String string, Object object) {
        Object object2 = this.delegate.getReloadLock();
        synchronized (object2) {
            super.setProperty(string, object);
            this.delegate.possiblySave();
        }
    }

    @Override
    public void load() throws ConfigurationException {
        this.delegate.load();
    }

    @Override
    public void load(String string) throws ConfigurationException {
        this.delegate.load(string);
    }

    @Override
    public void load(File file) throws ConfigurationException {
        this.delegate.load(file);
    }

    @Override
    public void load(URL uRL) throws ConfigurationException {
        this.delegate.load(uRL);
    }

    @Override
    public void load(InputStream inputStream) throws ConfigurationException {
        this.delegate.load(inputStream);
    }

    @Override
    public void load(InputStream inputStream, String string) throws ConfigurationException {
        this.delegate.load(inputStream, string);
    }

    @Override
    public void save() throws ConfigurationException {
        this.delegate.save();
    }

    @Override
    public void save(String string) throws ConfigurationException {
        this.delegate.save(string);
    }

    @Override
    public void save(File file) throws ConfigurationException {
        this.delegate.save(file);
    }

    @Override
    public void save(URL uRL) throws ConfigurationException {
        this.delegate.save(uRL);
    }

    @Override
    public void save(OutputStream outputStream) throws ConfigurationException {
        this.delegate.save(outputStream);
    }

    @Override
    public void save(OutputStream outputStream, String string) throws ConfigurationException {
        this.delegate.save(outputStream, string);
    }

    @Override
    public String getFileName() {
        return this.delegate.getFileName();
    }

    @Override
    public void setFileName(String string) {
        this.delegate.setFileName(string);
    }

    @Override
    public String getBasePath() {
        return this.delegate.getBasePath();
    }

    @Override
    public void setBasePath(String string) {
        this.delegate.setBasePath(string);
    }

    @Override
    public File getFile() {
        return this.delegate.getFile();
    }

    @Override
    public void setFile(File file) {
        this.delegate.setFile(file);
    }

    @Override
    public URL getURL() {
        return this.delegate.getURL();
    }

    @Override
    public void setURL(URL uRL) {
        this.delegate.setURL(uRL);
    }

    @Override
    public void setAutoSave(boolean bl) {
        this.delegate.setAutoSave(bl);
    }

    @Override
    public boolean isAutoSave() {
        return this.delegate.isAutoSave();
    }

    @Override
    public ReloadingStrategy getReloadingStrategy() {
        return this.delegate.getReloadingStrategy();
    }

    @Override
    public void setReloadingStrategy(ReloadingStrategy reloadingStrategy) {
        this.delegate.setReloadingStrategy(reloadingStrategy);
    }

    @Override
    public void reload() {
        this.reload(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reload(boolean bl) {
        Object object = this.delegate.getReloadLock();
        synchronized (object) {
            boolean bl2;
            this.setDetailEvents(false);
            try {
                bl2 = this.delegate.reload(bl);
            }
            catch (Throwable throwable) {
                this.setDetailEvents(true);
                throw throwable;
            }
            this.setDetailEvents(true);
            return bl2;
        }
    }

    public void refresh() throws ConfigurationException {
        this.delegate.refresh();
    }

    @Override
    public String getEncoding() {
        return this.delegate.getEncoding();
    }

    @Override
    public void setEncoding(String string) {
        this.delegate.setEncoding(string);
    }

    @Override
    public Object getReloadLock() {
        return this.delegate.getReloadLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(String string) {
        this.reload();
        Object object = this.delegate.getReloadLock();
        synchronized (object) {
            return super.containsKey(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<String> getKeys() {
        this.reload();
        Object object = this.delegate.getReloadLock();
        synchronized (object) {
            return super.getKeys();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<String> getKeys(String string) {
        this.reload();
        Object object = this.delegate.getReloadLock();
        synchronized (object) {
            return super.getKeys(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getProperty(String string) {
        if (this.reload(true)) {
            Object object = this.delegate.getReloadLock();
            synchronized (object) {
                return super.getProperty(string);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        this.reload();
        Object object = this.delegate.getReloadLock();
        synchronized (object) {
            return super.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNodes(String string, Collection<? extends ConfigurationNode> collection) {
        Object object = this.delegate.getReloadLock();
        synchronized (object) {
            super.addNodes(string, collection);
            this.delegate.possiblySave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<ConfigurationNode> fetchNodeList(String string) {
        this.reload();
        Object object = this.delegate.getReloadLock();
        synchronized (object) {
            return super.fetchNodeList(string);
        }
    }

    @Override
    protected void subnodeConfigurationChanged(ConfigurationEvent configurationEvent) {
        this.delegate.possiblySave();
        super.subnodeConfigurationChanged(configurationEvent);
    }

    protected FileConfigurationDelegate createDelegate() {
        return new FileConfigurationDelegate();
    }

    private void initDelegate(FileConfigurationDelegate fileConfigurationDelegate) {
        fileConfigurationDelegate.addConfigurationListener(this);
        fileConfigurationDelegate.addErrorListener(this);
        fileConfigurationDelegate.setLogger(this.getLogger());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configurationChanged(ConfigurationEvent configurationEvent) {
        this.setDetailEvents(true);
        try {
            this.fireEvent(configurationEvent.getType(), configurationEvent.getPropertyName(), configurationEvent.getPropertyValue(), configurationEvent.isBeforeUpdate());
        }
        finally {
            this.setDetailEvents(false);
        }
    }

    @Override
    public void configurationError(ConfigurationErrorEvent configurationErrorEvent) {
        this.fireError(configurationErrorEvent.getType(), configurationErrorEvent.getPropertyName(), configurationErrorEvent.getPropertyValue(), configurationErrorEvent.getCause());
    }

    protected FileConfigurationDelegate getDelegate() {
        return this.delegate;
    }

    protected void setDelegate(FileConfigurationDelegate fileConfigurationDelegate) {
        this.delegate = fileConfigurationDelegate;
    }

    @Override
    public void setFileSystem(FileSystem fileSystem) {
        this.delegate.setFileSystem(fileSystem);
    }

    @Override
    public void resetFileSystem() {
        this.delegate.resetFileSystem();
    }

    @Override
    public FileSystem getFileSystem() {
        return this.delegate.getFileSystem();
    }

    protected class FileConfigurationDelegate
    extends AbstractFileConfiguration {
        protected FileConfigurationDelegate() {
        }

        public void load(Reader reader) throws ConfigurationException {
            AbstractHierarchicalFileConfiguration.this.load(reader);
        }

        public void save(Writer writer) throws ConfigurationException {
            AbstractHierarchicalFileConfiguration.this.save(writer);
        }

        public void clear() {
            AbstractHierarchicalFileConfiguration.this.clear();
        }
    }
}

