/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.cli;

import com.secnium.iast.thirdparty.org.apache.commons.cli.Option;
import com.secnium.iast.thirdparty.org.apache.commons.cli.OptionGroup;
import com.secnium.iast.thirdparty.org.apache.commons.cli.Options;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HelpFormatter {
    public static final int DEFAULT_WIDTH = 74;
    public static final int DEFAULT_LEFT_PAD = 1;
    public static final int DEFAULT_DESC_PAD = 3;
    public static final String DEFAULT_SYNTAX_PREFIX = "usage: ";
    public static final String DEFAULT_OPT_PREFIX = "-";
    public static final String DEFAULT_LONG_OPT_PREFIX = "--";
    public static final String DEFAULT_LONG_OPT_SEPARATOR = " ";
    public static final String DEFAULT_ARG_NAME = "arg";
    @Deprecated
    public int defaultWidth = 74;
    @Deprecated
    public int defaultLeftPad = 1;
    @Deprecated
    public int defaultDescPad = 3;
    @Deprecated
    public String defaultSyntaxPrefix = "usage: ";
    @Deprecated
    public String defaultNewLine = System.getProperty("line.separator");
    @Deprecated
    public String defaultOptPrefix = "-";
    @Deprecated
    public String defaultLongOptPrefix = "--";
    @Deprecated
    public String defaultArgName = "arg";
    protected Comparator<Option> optionComparator = new OptionComparator();
    private String longOptSeparator = " ";

    public void setWidth(int n) {
        this.defaultWidth = n;
    }

    public int getWidth() {
        return this.defaultWidth;
    }

    public void setLeftPadding(int n) {
        this.defaultLeftPad = n;
    }

    public int getLeftPadding() {
        return this.defaultLeftPad;
    }

    public void setDescPadding(int n) {
        this.defaultDescPad = n;
    }

    public int getDescPadding() {
        return this.defaultDescPad;
    }

    public void setSyntaxPrefix(String string) {
        this.defaultSyntaxPrefix = string;
    }

    public String getSyntaxPrefix() {
        return this.defaultSyntaxPrefix;
    }

    public void setNewLine(String string) {
        this.defaultNewLine = string;
    }

    public String getNewLine() {
        return this.defaultNewLine;
    }

    public void setOptPrefix(String string) {
        this.defaultOptPrefix = string;
    }

    public String getOptPrefix() {
        return this.defaultOptPrefix;
    }

    public void setLongOptPrefix(String string) {
        this.defaultLongOptPrefix = string;
    }

    public String getLongOptPrefix() {
        return this.defaultLongOptPrefix;
    }

    public void setLongOptSeparator(String string) {
        this.longOptSeparator = string;
    }

    public String getLongOptSeparator() {
        return this.longOptSeparator;
    }

    public void setArgName(String string) {
        this.defaultArgName = string;
    }

    public String getArgName() {
        return this.defaultArgName;
    }

    public Comparator<Option> getOptionComparator() {
        return this.optionComparator;
    }

    public void setOptionComparator(Comparator<Option> comparator) {
        this.optionComparator = comparator;
    }

    public void printHelp(String string, Options options) {
        this.printHelp(this.getWidth(), string, null, options, null, false);
    }

    public void printHelp(String string, Options options, boolean bl) {
        this.printHelp(this.getWidth(), string, null, options, null, bl);
    }

    public void printHelp(String string, String string2, Options options, String string3) {
        this.printHelp(string, string2, options, string3, false);
    }

    public void printHelp(String string, String string2, Options options, String string3, boolean bl) {
        this.printHelp(this.getWidth(), string, string2, options, string3, bl);
    }

    public void printHelp(int n, String string, String string2, Options options, String string3) {
        this.printHelp(n, string, string2, options, string3, false);
    }

    public void printHelp(int n, String string, String string2, Options options, String string3, boolean bl) {
        PrintWriter printWriter = new PrintWriter(System.out);
        this.printHelp(printWriter, n, string, string2, options, this.getLeftPadding(), this.getDescPadding(), string3, bl);
        printWriter.flush();
    }

    public void printHelp(PrintWriter printWriter, int n, String string, String string2, Options options, int n2, int n3, String string3) {
        this.printHelp(printWriter, n, string, string2, options, n2, n3, string3, false);
    }

    public void printHelp(PrintWriter printWriter, int n, String string, String string2, Options options, int n2, int n3, String string3, boolean bl) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("cmdLineSyntax not provided");
        }
        if (bl) {
            this.printUsage(printWriter, n, string, options);
        } else {
            this.printUsage(printWriter, n, string);
        }
        if (string2 != null && string2.trim().length() > 0) {
            this.printWrapped(printWriter, n, string2);
        }
        this.printOptions(printWriter, n, options, n2, n3);
        if (string3 != null && string3.trim().length() > 0) {
            this.printWrapped(printWriter, n, string3);
        }
    }

    public void printUsage(PrintWriter printWriter, int n, String string, Options options) {
        StringBuffer stringBuffer = new StringBuffer(this.getSyntaxPrefix()).append(string).append(DEFAULT_LONG_OPT_SEPARATOR);
        ArrayList<OptionGroup> arrayList = new ArrayList<OptionGroup>();
        ArrayList<Option> arrayList2 = new ArrayList<Option>(options.getOptions());
        if (this.getOptionComparator() != null) {
            Collections.sort(arrayList2, this.getOptionComparator());
        }
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            Option option = (Option)iterator.next();
            OptionGroup optionGroup = options.getOptionGroup(option);
            if (optionGroup != null) {
                if (!arrayList.contains(optionGroup)) {
                    arrayList.add(optionGroup);
                    this.appendOptionGroup(stringBuffer, optionGroup);
                }
            } else {
                this.appendOption(stringBuffer, option, option.isRequired());
            }
            if (!iterator.hasNext()) continue;
            stringBuffer.append(DEFAULT_LONG_OPT_SEPARATOR);
        }
        this.printWrapped(printWriter, n, stringBuffer.toString().indexOf(32) + 1, stringBuffer.toString());
    }

    private void appendOptionGroup(StringBuffer stringBuffer, OptionGroup optionGroup) {
        if (!optionGroup.isRequired()) {
            stringBuffer.append("[");
        }
        ArrayList<Option> arrayList = new ArrayList<Option>(optionGroup.getOptions());
        if (this.getOptionComparator() != null) {
            Collections.sort(arrayList, this.getOptionComparator());
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.appendOption(stringBuffer, (Option)iterator.next(), true);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(" | ");
        }
        if (!optionGroup.isRequired()) {
            stringBuffer.append("]");
        }
    }

    private void appendOption(StringBuffer stringBuffer, Option option, boolean bl) {
        if (!bl) {
            stringBuffer.append("[");
        }
        if (option.getOpt() != null) {
            stringBuffer.append(DEFAULT_OPT_PREFIX).append(option.getOpt());
        } else {
            stringBuffer.append(DEFAULT_LONG_OPT_PREFIX).append(option.getLongOpt());
        }
        if (option.hasArg() && (option.getArgName() == null || option.getArgName().length() != 0)) {
            stringBuffer.append(option.getOpt() == null ? this.longOptSeparator : DEFAULT_LONG_OPT_SEPARATOR);
            stringBuffer.append("<").append(option.getArgName() != null ? option.getArgName() : this.getArgName()).append(">");
        }
        if (!bl) {
            stringBuffer.append("]");
        }
    }

    public void printUsage(PrintWriter printWriter, int n, String string) {
        int n2 = string.indexOf(32) + 1;
        this.printWrapped(printWriter, n, this.getSyntaxPrefix().length() + n2, this.getSyntaxPrefix() + string);
    }

    public void printOptions(PrintWriter printWriter, int n, Options options, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        this.renderOptions(stringBuffer, n, options, n2, n3);
        printWriter.println(stringBuffer.toString());
    }

    public void printWrapped(PrintWriter printWriter, int n, String string) {
        this.printWrapped(printWriter, n, 0, string);
    }

    public void printWrapped(PrintWriter printWriter, int n, int n2, String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        this.renderWrappedTextBlock(stringBuffer, n, n2, string);
        printWriter.println(stringBuffer.toString());
    }

    protected StringBuffer renderOptions(StringBuffer stringBuffer, int n, Options options, int n2, int n3) {
        CharSequence charSequence;
        Serializable serializable;
        String string = this.createPadding(n2);
        String string2 = this.createPadding(n3);
        int n4 = 0;
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
        List<Option> list = options.helpOptions();
        if (this.getOptionComparator() != null) {
            Collections.sort(list, this.getOptionComparator());
        }
        for (Option object2 : list) {
            serializable = new StringBuffer();
            if (object2.getOpt() == null) {
                ((StringBuffer)serializable).append(string).append("   ").append(this.getLongOptPrefix()).append(object2.getLongOpt());
            } else {
                ((StringBuffer)serializable).append(string).append(this.getOptPrefix()).append(object2.getOpt());
                if (object2.hasLongOpt()) {
                    ((StringBuffer)serializable).append(',').append(this.getLongOptPrefix()).append(object2.getLongOpt());
                }
            }
            if (object2.hasArg()) {
                charSequence = object2.getArgName();
                if (charSequence != null && ((String)charSequence).length() == 0) {
                    ((StringBuffer)serializable).append(' ');
                } else {
                    ((StringBuffer)serializable).append(object2.hasLongOpt() ? this.longOptSeparator : DEFAULT_LONG_OPT_SEPARATOR);
                    ((StringBuffer)serializable).append("<").append(charSequence != null ? object2.getArgName() : this.getArgName()).append(">");
                }
            }
            arrayList.add(serializable);
            n4 = ((StringBuffer)serializable).length() > n4 ? ((StringBuffer)serializable).length() : n4;
        }
        int n5 = 0;
        Iterator<Option> iterator = list.iterator();
        while (iterator.hasNext()) {
            serializable = iterator.next();
            if (((StringBuilder)(charSequence = new StringBuilder(((StringBuffer)arrayList.get(n5++)).toString()))).length() < n4) {
                ((StringBuilder)charSequence).append(this.createPadding(n4 - ((StringBuilder)charSequence).length()));
            }
            ((StringBuilder)charSequence).append(string2);
            int n6 = n4 + n3;
            if (((Option)serializable).getDescription() != null) {
                ((StringBuilder)charSequence).append(((Option)serializable).getDescription());
            }
            this.renderWrappedText(stringBuffer, n, n6, ((StringBuilder)charSequence).toString());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(this.getNewLine());
        }
        return stringBuffer;
    }

    protected StringBuffer renderWrappedText(StringBuffer stringBuffer, int n, int n2, String string) {
        int n3 = this.findWrapPos(string, n, 0);
        if (n3 == -1) {
            stringBuffer.append(this.rtrim(string));
            return stringBuffer;
        }
        stringBuffer.append(this.rtrim(string.substring(0, n3))).append(this.getNewLine());
        if (n2 >= n) {
            n2 = 1;
        }
        String string2 = this.createPadding(n2);
        while (true) {
            if ((n3 = this.findWrapPos(string = string2 + string.substring(n3).trim(), n, 0)) == -1) {
                stringBuffer.append(string);
                return stringBuffer;
            }
            if (string.length() > n && n3 == n2 - 1) {
                n3 = n;
            }
            stringBuffer.append(this.rtrim(string.substring(0, n3))).append(this.getNewLine());
        }
    }

    private Appendable renderWrappedTextBlock(StringBuffer stringBuffer, int n, int n2, String string) {
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            boolean bl = true;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (!bl) {
                    stringBuffer.append(this.getNewLine());
                } else {
                    bl = false;
                }
                this.renderWrappedText(stringBuffer, n, n2, string2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringBuffer;
    }

    protected int findWrapPos(String string, int n, int n2) {
        char c2;
        int n3 = string.indexOf(10, n2);
        if (n3 != -1 && n3 <= n) {
            return n3 + 1;
        }
        n3 = string.indexOf(9, n2);
        if (n3 != -1 && n3 <= n) {
            return n3 + 1;
        }
        if (n2 + n >= string.length()) {
            return -1;
        }
        for (n3 = n2 + n; n3 >= n2 && (c2 = string.charAt(n3)) != ' ' && c2 != '\n' && c2 != '\r'; --n3) {
        }
        if (n3 > n2) {
            return n3;
        }
        n3 = n2 + n;
        return n3 == string.length() ? -1 : n3;
    }

    protected String createPadding(int n) {
        char[] cArray = new char[n];
        Arrays.fill(cArray, ' ');
        return new String(cArray);
    }

    protected String rtrim(String string) {
        int n;
        if (string == null || string.length() == 0) {
            return string;
        }
        for (n = string.length(); n > 0 && Character.isWhitespace(string.charAt(n - 1)); --n) {
        }
        return string.substring(0, n);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OptionComparator
    implements Serializable,
    Comparator<Option> {
        private static final long serialVersionUID = 5305467873966684014L;

        private OptionComparator() {
        }

        @Override
        public int compare(Option option, Option option2) {
            return option.getKey().compareToIgnoreCase(option2.getKey());
        }
    }
}

