/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.log4j;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.NotFoundInstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.bootstrap.plugin.util.InstrumentUtils;
import com.navercorp.pinpoint.plugin.log4j.Log4jConfig;
import java.security.ProtectionDomain;
import java.util.Arrays;

public class Log4jPlugin
implements ProfilerPlugin,
TransformTemplateAware {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private TransformTemplate transformTemplate;

    public void setup(ProfilerPluginSetupContext context) {
        Log4jConfig config = new Log4jConfig(context.getConfig());
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Log4jPlugin config:{}", (Object)config);
        }
        if (!config.isLog4jLoggingTransactionInfo()) {
            this.logger.info("Log4j plugin is not executed because log4j transform enable config value is false.");
            return;
        }
        this.transformTemplate.transform("org.apache.log4j.spi.LoggingEvent", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass mdcClass = instrumentor.getInstrumentClass(loader, "org.apache.log4j.MDC", null);
                if (mdcClass == null) {
                    Log4jPlugin.this.logger.warn("Can not modify. Because org.apache.log4j.MDC does not exist.");
                    return null;
                }
                if (!mdcClass.hasMethod("put", new String[]{"java.lang.String", "java.lang.Object"})) {
                    Log4jPlugin.this.logger.warn("Can not modify. Because put method does not exist at org.apache.log4j.MDC class.");
                    return null;
                }
                if (!mdcClass.hasMethod("remove", new String[]{"java.lang.String"})) {
                    Log4jPlugin.this.logger.warn("Can not modify. Because remove method does not exist at org.apache.log4j.MDC class.");
                    return null;
                }
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                if (!target.hasConstructor(new String[]{"java.lang.String", "org.apache.log4j.Category", "org.apache.log4j.Priority", "java.lang.Object", "java.lang.Throwable"})) {
                    Log4jPlugin.this.logger.warn("Can not modify. Because constructor to modify not exist at org.apache.log4j.MDC class.\nThere is a strong presumption that your application use under version 1.2.14 log4j.\nconstructor prototype : LoggingEvent(String fqnOfCategoryClass, Category logger, Priority level, Object message, Throwable throwable);");
                    return null;
                }
                if (!target.hasConstructor(new String[]{"java.lang.String", "org.apache.log4j.Category", "long", "org.apache.log4j.Priority", "java.lang.Object", "java.lang.Throwable"})) {
                    Log4jPlugin.this.logger.warn("Can not modify. Because constructor to modify not exist at org.apache.log4j.MDC class.\nThere is a strong presumption that your application use under version 1.2.14 log4j.\nconstructor prototype : LoggingEvent(String fqnOfCategoryClass, Category logger, long timeStamp, Priority level, Object message, Throwable throwable);");
                    return null;
                }
                if (!target.hasConstructor(new String[]{"java.lang.String", "org.apache.log4j.Category", "long", "org.apache.log4j.Level", "java.lang.Object", "java.lang.String", "org.apache.log4j.spi.ThrowableInformation", "java.lang.String", "org.apache.log4j.spi.LocationInfo", "java.util.Map"})) {
                    Log4jPlugin.this.logger.warn("Can not modify. Because constructor to modify not exist at org.apache.log4j.MDC class. \nThere is a strong presumption that your application use under version 1.2.14 log4j.\nconstructor prototype : LoggingEvent(final String fqnOfCategoryClass, final Category logger, final long timeStamp, final Level level, final Object message, final String threadName, final ThrowableInformation throwable, final String ndc, final LocationInfo info, final java.util.Map properties);");
                    return null;
                }
                String interceptorClassName = "com.navercorp.pinpoint.plugin.log4j.interceptor.LoggingEventOfLog4jInterceptor";
                this.addInterceptor(target, new String[]{"java.lang.String", "org.apache.log4j.Category", "org.apache.log4j.Priority", "java.lang.Object", "java.lang.Throwable"}, "com.navercorp.pinpoint.plugin.log4j.interceptor.LoggingEventOfLog4jInterceptor");
                this.addInterceptor(target, new String[]{"java.lang.String", "org.apache.log4j.Category", "long", "org.apache.log4j.Priority", "java.lang.Object", "java.lang.Throwable"}, "com.navercorp.pinpoint.plugin.log4j.interceptor.LoggingEventOfLog4jInterceptor");
                this.addInterceptor(target, new String[]{"java.lang.String", "org.apache.log4j.Category", "long", "org.apache.log4j.Level", "java.lang.Object", "java.lang.String", "org.apache.log4j.spi.ThrowableInformation", "java.lang.String", "org.apache.log4j.spi.LocationInfo", "java.util.Map"}, "com.navercorp.pinpoint.plugin.log4j.interceptor.LoggingEventOfLog4jInterceptor");
                return target.toBytecode();
            }

            private void addInterceptor(InstrumentClass target, String[] parameterTypes, String interceptorClassName) throws InstrumentException {
                InstrumentMethod constructor = InstrumentUtils.findConstructor((InstrumentClass)target, (String[])parameterTypes);
                if (constructor == null) {
                    throw new NotFoundInstrumentException("Cannot find constructor with parameter types: " + Arrays.toString(parameterTypes));
                }
                constructor.addInterceptor(interceptorClassName);
            }
        });
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }
}

