/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.agent.manager;

import com.secnium.iast.agent.Agent;
import com.secnium.iast.agent.AttachLauncher;
import com.secnium.iast.agent.IastClassLoader;
import com.secnium.iast.agent.IastProperties;
import com.secnium.iast.agent.UpdateUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarFile;

public class EngineManager {
    private static final String IAST_NAMESPACE = "DONGTAI";
    private static final String ENGINE_ENTRYPOINT_CLASS = "com.secnium.iast.core.AgentEngine";
    private static final String INJECT_PACKAGE_REMOTE_URI = "/api/v1/engine/download?package_name=iast-inject&jdk.version=";
    private static final String ENGINE_PACKAGE_REMOTE_URI = "/api/v1/engine/download?package_name=iast-core&jdk.version=";
    private static final Map<String, IastClassLoader> IAST_CLASS_LOADER_CACHE = new ConcurrentHashMap<String, IastClassLoader>();
    private static EngineManager INSTANCE;
    private final Instrumentation inst;
    private int runningStatus;
    private final IastProperties properties;
    private final String launchMode;
    private Class<?> classOfEngine;
    private final String ppid;

    public int getRunningStatus() {
        return this.runningStatus;
    }

    public void setRunningStatus(int runningStatus) {
        this.runningStatus = runningStatus;
    }

    public static EngineManager getInstance(Instrumentation inst, String launchMode, String ppid) {
        if (INSTANCE == null) {
            INSTANCE = new EngineManager(inst, launchMode, ppid);
        }
        return INSTANCE;
    }

    public static EngineManager getInstance() {
        return INSTANCE;
    }

    public EngineManager(Instrumentation inst, String launchMode, String ppid) {
        this.inst = inst;
        this.runningStatus = 0;
        this.launchMode = launchMode;
        this.properties = IastProperties.getInstance();
        this.ppid = ppid;
    }

    public static String getEnginePackageCachePath() {
        return System.getProperty("java.io.tmpdir") + File.separator + "iast-core.jar";
    }

    public static String getInjectPackageCachePath() {
        return System.getProperty("java.io.tmpdir") + File.separator + "iast-inject.jar";
    }

    private boolean downloadJarPackageToCacheFromUrl(String fileUrl, String fileName) {
        boolean status = false;
        try {
            int bytesRead;
            URL url = new URL(fileUrl);
            Proxy proxy = UpdateUtils.loadProxy();
            HttpURLConnection connection = proxy == null ? (HttpURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection(proxy);
            connection.setRequestMethod("GET");
            connection.setRequestProperty("User-Agent", "DongTai-IAST-Agent");
            connection.setRequestProperty("Authorization", "Token " + this.properties.getIastServerToken());
            connection.setUseCaches(false);
            connection.setDoOutput(true);
            BufferedInputStream in = new BufferedInputStream(connection.getInputStream());
            File classPath = new File(new File(fileName).getParent());
            if (!classPath.mkdirs() && !classPath.exists()) {
                System.out.println("[cn.huoxian.dongtai.iast] Check or create local file cache path, path is " + classPath);
            }
            FileOutputStream fileOutputStream = new FileOutputStream(fileName);
            byte[] dataBuffer = new byte[1024];
            while ((bytesRead = in.read(dataBuffer, 0, 1024)) != -1) {
                fileOutputStream.write(dataBuffer, 0, bytesRead);
            }
            System.out.println("[cn.huoxian.dongtai.iast] The remote file " + fileUrl + " was successfully written to the local cache.");
            status = true;
        }
        catch (Exception ignore) {
            System.err.println("[cn.huoxian.dongtai.iast] The remote file " + fileUrl + " download failure, please check the iast-token.");
        }
        return status;
    }

    public boolean updateEnginePackage() {
        String jdkVersion = EngineManager.getJdkVersion();
        String baseUrl = this.properties.getBaseUrl();
        if (this.downloadJarPackageToCacheFromUrl(baseUrl + INJECT_PACKAGE_REMOTE_URI + jdkVersion, EngineManager.getInjectPackageCachePath()) && this.downloadJarPackageToCacheFromUrl(baseUrl + ENGINE_PACKAGE_REMOTE_URI + jdkVersion, EngineManager.getEnginePackageCachePath())) {
            UpdateUtils.setUpdateSuccess();
            return true;
        }
        return false;
    }

    public boolean downloadEnginePackage() {
        System.out.println("[cn.huoxian.dongtai.iast] Check if the engine needs to be updated");
        if (UpdateUtils.needUpdate()) {
            System.out.println("[cn.huoxian.dongtai.iast] Receive an instruction from the remote server to update the engine, update the engine immediately");
            return this.updateEnginePackage();
        }
        if (EngineManager.engineNotExist(EngineManager.getInjectPackageCachePath()) || EngineManager.engineNotExist(EngineManager.getEnginePackageCachePath())) {
            System.out.println("[cn.huoxian.dongtai.iast] Engine does not exist in local cache, the engine will be downloaded.");
            return this.updateEnginePackage();
        }
        return true;
    }

    public boolean install() {
        try {
            this.inst.appendToBootstrapClassLoaderSearch(new JarFile(new File(EngineManager.getInjectPackageCachePath())));
            ClassLoader iastClassLoader = IAST_CLASS_LOADER_CACHE.get(IAST_NAMESPACE);
            if (iastClassLoader == null) {
                iastClassLoader = EngineManager.loadOrDefineClassLoader(EngineManager.getEnginePackageCachePath());
            }
            this.classOfEngine = iastClassLoader.loadClass(ENGINE_ENTRYPOINT_CLASS);
            this.classOfEngine.getMethod("install", String.class, String.class, Instrumentation.class).invoke(null, this.launchMode, this.properties.getPropertiesFilePath(), this.inst);
            return true;
        }
        catch (IOException e) {
            System.err.println("[cn.huoxian.dongtai.iast] DongTai engine installation failed, please contact staff for help.");
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            System.err.println("[cn.huoxian.dongtai.iast] DongTai engine installation failed, please contact staff for help.");
            e.printStackTrace();
        }
        catch (Throwable throwable) {
            System.err.println("[cn.huoxian.dongtai.iast] DongTai engine installation failed, please contact staff for help.");
            throwable.printStackTrace();
        }
        return false;
    }

    public boolean start() {
        try {
            if (this.classOfEngine != null) {
                this.classOfEngine.getMethod("start", new Class[0]).invoke(null, new Object[0]);
                return true;
            }
            return false;
        }
        catch (InvocationTargetException e) {
            System.err.println("[cn.huoxian.dongtai.iast] DongTai engine start failed, please contact staff for help.");
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            System.err.println("[cn.huoxian.dongtai.iast] DongTai engine start failed, please contact staff for help.");
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            System.err.println("[cn.huoxian.dongtai.iast] DongTai engine start failed, please contact staff for help.");
            e.printStackTrace();
        }
        catch (Throwable throwable) {
            System.err.println("[cn.huoxian.dongtai.iast] DongTai engine start failed, please contact staff for help.");
            throwable.printStackTrace();
        }
        return false;
    }

    public boolean stop() {
        try {
            if (this.classOfEngine != null) {
                this.classOfEngine.getMethod("stop", new Class[0]).invoke(null, new Object[0]);
                return true;
            }
            return false;
        }
        catch (InvocationTargetException e) {
            System.err.println("[cn.huoxian.dongtai.iast] DongTai engine stop failed, please contact staff for help.");
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            System.err.println(sw.toString());
        }
        catch (NoSuchMethodException e) {
            System.err.println("[cn.huoxian.dongtai.iast] DongTai engine stop failed, please contact staff for help.");
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            System.err.println("[cn.huoxian.dongtai.iast] DongTai engine stop failed, please contact staff for help.");
            e.printStackTrace();
        }
        catch (Throwable throwable) {
            System.err.println("[cn.huoxian.dongtai.iast] DongTai engine stop failed, please contact staff for help.");
            throwable.printStackTrace();
        }
        return false;
    }

    public boolean restart() {
        return true;
    }

    public synchronized boolean uninstall() {
        IastClassLoader classLoader = IAST_CLASS_LOADER_CACHE.get(IAST_NAMESPACE);
        if (null == classLoader) {
            return true;
        }
        try {
            if (this.classOfEngine != null) {
                this.classOfEngine.getMethod("destroy", String.class, String.class, Instrumentation.class).invoke(null, this.launchMode, this.properties.getPropertiesFilePath(), this.inst);
                Agent.appendToolsPath();
                AttachLauncher.detach(this.ppid);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        this.classOfEngine = null;
        classLoader.closeIfPossible();
        IAST_CLASS_LOADER_CACHE.remove(IAST_NAMESPACE);
        return true;
    }

    private static synchronized ClassLoader loadOrDefineClassLoader(String coreJar) throws Throwable {
        IastClassLoader classLoader;
        if (IAST_CLASS_LOADER_CACHE.containsKey(IAST_NAMESPACE) && null != IAST_CLASS_LOADER_CACHE.get(IAST_NAMESPACE)) {
            classLoader = IAST_CLASS_LOADER_CACHE.get(IAST_NAMESPACE);
        } else {
            classLoader = new IastClassLoader(IAST_NAMESPACE, coreJar);
            IAST_CLASS_LOADER_CACHE.put(IAST_NAMESPACE, classLoader);
        }
        return classLoader;
    }

    private static boolean engineNotExist(String jarPath) {
        String isDebug = System.getProperty("debug");
        if ("true".equals(isDebug)) {
            System.out.println("[cn.huoxian.dongtai.iast] current mode: debug, load engine from " + jarPath);
            File tempFile = new File(jarPath);
            return !tempFile.exists();
        }
        return true;
    }

    private static String getJdkVersion() {
        String jdkVersion = System.getProperty("java.version", "1.8");
        System.out.println("current jdk version is : " + jdkVersion);
        String[] jdkVersionItem = jdkVersion.split("\\.");
        boolean isHighJdk = true;
        if (jdkVersionItem.length > 1 && ("6".equals(jdkVersionItem[1]) || "7".equals(jdkVersionItem[1]) || "8".equals(jdkVersionItem[1]))) {
            isHighJdk = false;
        }
        return isHighJdk ? "2" : "1";
    }
}

