/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.agent;

import com.secnium.iast.agent.IastProperties;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class AgentRegister {
    private static String AGENT_NAME = null;

    public static String getAgentToken() {
        if (AGENT_NAME == null) {
            String osName = System.getProperty("os.name");
            String hostname = AgentRegister.getInternalHostName();
            AGENT_NAME = osName + "-" + hostname + "-" + "v1.0.0" + "-" + IastProperties.getInstance().getEngineName();
        }
        return AGENT_NAME;
    }

    private static String getInternalHostName() {
        if (System.getenv("COMPUTERNAME") != null) {
            return System.getenv("COMPUTERNAME");
        }
        return AgentRegister.getHostNameForLinux();
    }

    private static String getHostNameForLinux() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhe) {
            int colon;
            String host = uhe.getMessage();
            if (host != null && (colon = host.indexOf(58)) > 0) {
                return host.substring(0, colon);
            }
            return "UnknownHost";
        }
    }
}

