/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap;

import com.navercorp.pinpoint.bootstrap.BootLogger;
import com.navercorp.pinpoint.common.util.IdValidateUtils;
import java.util.Properties;

public class IdValidator {
    private final BootLogger logger = BootLogger.getLogger(IdValidator.class.getName());
    private final Properties property;
    private static final int MAX_ID_LENGTH = 24;

    public IdValidator() {
        this(System.getProperties());
    }

    public IdValidator(Properties property) {
        if (property == null) {
            throw new NullPointerException("property must not be null");
        }
        this.property = property;
    }

    private String getValidId(String propertyName, int maxSize) {
        this.logger.info("check -D" + propertyName);
        String value = this.property.getProperty(propertyName);
        if (value == null) {
            this.logger.warn("-D" + propertyName + " is null. value:null");
            return null;
        }
        if ((value = value.trim()).isEmpty()) {
            this.logger.warn("-D" + propertyName + " is empty. value:''");
            return null;
        }
        if (!IdValidateUtils.validateId((String)value, (int)maxSize)) {
            this.logger.warn("invalid Id. " + propertyName + " can only contain [a-zA-Z0-9], '.', '-', '_'. maxLength:" + maxSize + " value:" + value);
            return null;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("check success. -D" + propertyName + ":" + value + " length:" + IdValidateUtils.getLength((String)value));
        }
        return value;
    }

    public String getApplicationName() {
        return this.getValidId("pinpoint.applicationName", 24);
    }

    public String getAgentId() {
        return this.getValidId("pinpoint.agentId", 24);
    }
}

