/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap;

import com.navercorp.pinpoint.bootstrap.Agent;
import com.navercorp.pinpoint.bootstrap.AgentOption;
import com.navercorp.pinpoint.bootstrap.BootStrapException;
import com.navercorp.pinpoint.bootstrap.ContextClassLoaderExecuteTemplate;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.concurrent.Callable;

public class AgentBootLoader {
    private static final SecurityManager SECURITY_MANAGER = System.getSecurityManager();
    private final ClassLoader classLoader;
    private final String bootClass;
    private final ContextClassLoaderExecuteTemplate<Object> executeTemplate;

    public AgentBootLoader(String bootClass, URL[] urls, ClassLoader agentClassLoader) {
        if (bootClass == null) {
            throw new NullPointerException("bootClass must not be null");
        }
        if (urls == null) {
            throw new NullPointerException("urls");
        }
        this.bootClass = bootClass;
        this.classLoader = agentClassLoader;
        this.executeTemplate = new ContextClassLoaderExecuteTemplate(agentClassLoader);
    }

    public Agent boot(final AgentOption agentOption) {
        final Class<?> bootStrapClazz = this.getBootStrapClass();
        Object agent = this.executeTemplate.execute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    Constructor constructor = bootStrapClazz.getDeclaredConstructor(AgentOption.class);
                    return constructor.newInstance(agentOption);
                }
                catch (InstantiationException e) {
                    throw new BootStrapException("boot create failed. Error:" + e.getMessage(), e);
                }
                catch (IllegalAccessException e) {
                    throw new BootStrapException("boot method invoke failed. Error:" + e.getMessage(), e);
                }
            }
        });
        if (agent instanceof Agent) {
            return (Agent)agent;
        }
        String agentClassName = agent == null ? "Agent is null" : agent.getClass().getName();
        throw new BootStrapException("Invalid AgentType. boot failed. AgentClass:" + agentClassName);
    }

    private Class<?> getBootStrapClass() {
        try {
            return this.classLoader.loadClass(this.bootClass);
        }
        catch (ClassNotFoundException e) {
            throw new BootStrapException("boot class not found. bootClass:" + this.bootClass + " Error:" + e.getMessage(), e);
        }
    }
}

