/*
 * Decompiled with CFR 0.152.
 */
package com.tapm.starter.logger.autolog.processor;

import com.tapm.starter.flow.IProcessor;
import com.tapm.starter.flow.ProcessContext;
import com.tapm.starter.flow.exception.ProcessException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;

public class LockFileCreatorProcessor
implements IProcessor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String process(ProcessContext context) throws ProcessException {
        int logSuffix = (Integer)context.get("suffixIndex");
        File processDir = (File)context.get("processDir");
        String lockFileName = "log_lock." + logSuffix;
        File file = new File(processDir, lockFileName);
        try {
            if (file.createNewFile()) {
                FilterOutputStream bos = null;
                try {
                    bos = new BufferedOutputStream(new FileOutputStream(file));
                    String containerId = (String)context.get("containerId");
                    if (containerId == null) {
                        String processId = (String)context.get("processId");
                        bos.write((processId + ":" + System.currentTimeMillis()).getBytes());
                    } else {
                        String processId = (String)context.get("processId");
                        bos.write((containerId + ":" + processId + ":" + System.currentTimeMillis()).getBytes());
                    }
                    ((BufferedOutputStream)bos).flush();
                }
                catch (FileNotFoundException e) {
                    System.err.println("LockFileCreatorProcessor: found FileNotFoundException : " + e.getMessage());
                }
                catch (IOException e) {
                    System.err.println("LockFileCreatorProcessor: write lock file found IOException : " + e.getMessage());
                }
                finally {
                    if (bos != null) {
                        bos.close();
                    }
                }
                context.put("lockFile", file);
                return "next";
            }
            Integer index = (Integer)context.get("index");
            index = index + 1;
            context.put("index", index);
            return "reScan";
        }
        catch (IOException e) {
            System.err.println("LockFileCreatorProcessor: create lock file  found IOException : " + e.getMessage());
            Integer index = (Integer)context.get("index");
            index = index + 1;
            context.put("index", index);
            return "reScan";
        }
    }
}

