/*
 * Decompiled with CFR 0.152.
 */
package com.tapm.starter.logger.appender;

import com.tapm.starter.logger.appender.IAppender;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

public class FileAppender
implements IAppender {
    private File file;
    private String lineSeparator = System.getProperty("line.separator");
    private String charset = "utf-8";
    private FileOutputStream outStream;
    private final int maxScroll;

    public FileAppender(File file, int maxScroll) {
        this.file = file;
        this.maxScroll = maxScroll;
        if (this.lineSeparator == null || this.lineSeparator.isEmpty()) {
            this.lineSeparator = "\r\n";
        }
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    @Override
    public void open() throws Exception {
        if (this.file.exists()) {
            this.renameLogFile(new File(this.file.getAbsolutePath()), 0);
        }
        if (this.outStream == null) {
            this.outStream = new FileOutputStream(this.file, false);
        }
    }

    private void renameLogFile(File currentFile, int currentIndex) {
        try {
            int index = currentIndex + 1;
            String fileName = this.file.getName() + "." + index;
            File newFile = new File(this.file.getParentFile(), fileName);
            if (newFile.exists()) {
                if (index == this.maxScroll) {
                    newFile.delete();
                } else {
                    this.renameLogFile(newFile, index);
                }
            }
            currentFile.renameTo(newFile);
        }
        catch (Exception e) {
            System.err.println("Tapm agent log rename failed, reason: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(String msg) {
        FileChannel fc = this.outStream.getChannel();
        if (fc == null) {
            return;
        }
        FileLock fileLock = null;
        try {
            fileLock = fc.lock();
            long position = fc.position();
            long size = fc.size();
            if (size != position) {
                fc.position(size);
            }
            fc.write(ByteBuffer.wrap(msg.getBytes(this.charset)));
            fc.write(ByteBuffer.wrap(this.lineSeparator.getBytes()));
            fc.force(true);
        }
        catch (Exception e) {
            System.err.println("Tapm agent log appender failed, reason: " + e.getMessage());
        }
        finally {
            if (fileLock != null) {
                try {
                    fileLock.release();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void close() {
        if (this.outStream != null) {
            try {
                this.outStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.outStream = null;
        }
    }
}

