/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.monitor.metric.cpu;

import com.navercorp.pinpoint.common.util.CpuUtils;

public class JvmCpuUsageCalculator {
    private static final int CPU_COUNT = CpuUtils.cpuCount();
    private static final int UNSUPPORTED = -1;
    private static final int UNINITIALIZED = -1;
    private long lastCpuTimeNS = -1L;
    private long lastUpTimeMS = -1L;

    public double getJvmCpuUsage(long cpuTimeNS, long upTimeMS) {
        if (cpuTimeNS == -1L) {
            return -1.0;
        }
        if (this.lastCpuTimeNS == -1L || this.lastUpTimeMS == -1L) {
            this.lastCpuTimeNS = cpuTimeNS;
            this.lastUpTimeMS = upTimeMS;
            return 0.0;
        }
        long totalCpuTimeNS = cpuTimeNS - this.lastCpuTimeNS;
        long diffUpTimeMS = upTimeMS - this.lastUpTimeMS;
        long totalUpTimeNS = diffUpTimeMS * 1000000L * (long)CPU_COUNT;
        double cpuUsage = -1.0;
        if (totalUpTimeNS > 0L) {
            cpuUsage = Math.min(100.0f, (float)totalCpuTimeNS / (float)totalUpTimeNS);
        }
        this.lastCpuTimeNS = cpuTimeNS;
        this.lastUpTimeMS = upTimeMS;
        return cpuUsage;
    }
}

