/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.config;

import com.navercorp.pinpoint.bootstrap.config.Filter;
import com.navercorp.pinpoint.bootstrap.util.AntPathMatcher;
import com.navercorp.pinpoint.bootstrap.util.EqualsPathMatcher;
import com.navercorp.pinpoint.bootstrap.util.PathMatcher;
import com.navercorp.pinpoint.common.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class ExcludePathFilter
implements Filter<String> {
    public static final String DEFAULT_PATH_SEAPARATOR = "/";
    public static final String DEFAULT_FORMAT_SEPARATOR = ",";
    protected final PathMatcher[] excludePathMatchers;

    public ExcludePathFilter(String excludePathFormatString) {
        this(excludePathFormatString, DEFAULT_PATH_SEAPARATOR);
    }

    public ExcludePathFilter(String excludePathFormatString, String pathSeparator) {
        this(excludePathFormatString, pathSeparator, DEFAULT_FORMAT_SEPARATOR);
    }

    public ExcludePathFilter(String excludePathFormatString, String pathSeparator, String formatSeparator) {
        if (StringUtils.isEmpty((String)pathSeparator)) {
            throw new IllegalArgumentException("pathSeparator must not be empty");
        }
        if (StringUtils.isEmpty((String)excludePathFormatString)) {
            this.excludePathMatchers = new PathMatcher[0];
            return;
        }
        List excludePathFormats = StringUtils.tokenizeToStringList((String)excludePathFormatString, (String)formatSeparator);
        ArrayList<PathMatcher> excludePathMatchers = new ArrayList<PathMatcher>(excludePathFormats.size());
        for (String excludePathFormat : excludePathFormats) {
            PathMatcher pathMatcher = this.createPathMatcher(excludePathFormat, pathSeparator);
            excludePathMatchers.add(pathMatcher);
        }
        this.excludePathMatchers = this.toArray(excludePathMatchers);
    }

    public PathMatcher[] toArray(Collection<PathMatcher> collection) {
        if (collection == null) {
            throw new NullPointerException("collection must not be null");
        }
        return collection.toArray(new PathMatcher[0]);
    }

    protected PathMatcher createPathMatcher(String pattern, String pathSeparator) {
        if (AntPathMatcher.isAntStylePattern(pattern)) {
            return new AntPathMatcher(pattern, pathSeparator);
        }
        return new EqualsPathMatcher(pattern);
    }

    @Override
    public boolean filter(String value) {
        for (PathMatcher excludePathMatcher : this.excludePathMatchers) {
            if (!excludePathMatcher.isMatched(value)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ExcludePathFilter{");
        sb.append("excludePathMatchers=").append(Arrays.toString(this.excludePathMatchers));
        sb.append('}');
        return sb.toString();
    }
}

