/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.openwhisk;

import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessor;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilter;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilters;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ApplicationTypeDetector;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.plugin.openwhisk.OpenwhiskConfig;
import com.navercorp.pinpoint.plugin.openwhisk.OpenwhiskDetector;
import com.navercorp.pinpoint.plugin.openwhisk.accessor.PinpointTraceAccessor;
import java.security.ProtectionDomain;

public class OpenwhiskPlugin
implements ProfilerPlugin,
TransformTemplateAware {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private TransformTemplate transformTemplate;

    public void setup(ProfilerPluginSetupContext context) {
        OpenwhiskConfig config = new OpenwhiskConfig(context.getConfig());
        if (!config.isEnable()) {
            return;
        }
        OpenwhiskDetector openwhiskDetector = new OpenwhiskDetector();
        context.addApplicationTypeDetector(new ApplicationTypeDetector[]{openwhiskDetector});
        this.transformTemplate.transform(config.getTransformTargetName(), new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                InstrumentMethod method = target.getDeclaredMethod("apply", new String[]{"akka.http.scaladsl.server.RequestContext"});
                method.addInterceptor("com.navercorp.pinpoint.plugin.openwhisk.interceptor.TransactionIdCreateInterceptor");
                return target.toBytecode();
            }
        });
        this.transformTemplate.transform("whisk.connector.kafka.KafkaProducerConnector", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                MethodFilter applyMethodFilter = MethodFilters.chain((MethodFilter[])new MethodFilter[]{MethodFilters.name((String[])new String[]{"send"})});
                for (InstrumentMethod method : target.getDeclaredMethods(applyMethodFilter)) {
                    try {
                        method.addInterceptor("com.navercorp.pinpoint.plugin.openwhisk.interceptor.KafkaProducerSendInterceptor");
                        break;
                    }
                    catch (Exception e) {
                        if (!OpenwhiskPlugin.this.logger.isWarnEnabled()) continue;
                        OpenwhiskPlugin.this.logger.warn("Unsupported method " + method, (Throwable)e);
                    }
                }
                return target.toBytecode();
            }
        });
        this.transformTemplate.transform("whisk.core.connector.ActivationMessage", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                target.addSetter("com.navercorp.pinpoint.plugin.openwhisk.setter.TraceContextSetter", "traceContext", true);
                return target.toBytecode();
            }
        });
        this.transformTemplate.transform("whisk.common.tracing.NoopTracer$", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                MethodFilter applyMethodFilter = MethodFilters.chain((MethodFilter[])new MethodFilter[]{MethodFilters.name((String[])new String[]{"setTraceContext"})});
                for (InstrumentMethod method : target.getDeclaredMethods(applyMethodFilter)) {
                    try {
                        method.addInterceptor("com.navercorp.pinpoint.plugin.openwhisk.interceptor.NoopTracerSetTraceContextInterceptor");
                        break;
                    }
                    catch (Exception e) {
                        if (!OpenwhiskPlugin.this.logger.isWarnEnabled()) continue;
                        OpenwhiskPlugin.this.logger.warn("Unsupported method " + method, (Throwable)e);
                    }
                }
                return target.toBytecode();
            }
        });
        this.transformTemplate.transform("whisk.common.TransactionId$", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                MethodFilter startedMethodFilter = MethodFilters.chain((MethodFilter[])new MethodFilter[]{MethodFilters.name((String[])new String[]{"started$extension"}), MethodFilters.argAt((int)2, (String)"whisk.common.LogMarkerToken"), MethodFilters.argAt((int)3, (String)"scala.Function0")});
                for (Object method : target.getDeclaredMethods(startedMethodFilter)) {
                    try {
                        method.addInterceptor("com.navercorp.pinpoint.plugin.openwhisk.interceptor.TransactionIdStartedInterceptor");
                    }
                    catch (Exception e) {
                        if (!OpenwhiskPlugin.this.logger.isWarnEnabled()) continue;
                        OpenwhiskPlugin.this.logger.warn("Unsupported method " + method, (Throwable)e);
                    }
                }
                MethodFilter finishedMethodFilter = MethodFilters.chain((MethodFilter[])new MethodFilter[]{MethodFilters.name((String[])new String[]{"finished$extension"}), MethodFilters.argAt((int)2, (String)"whisk.common.StartMarker")});
                for (Object method : target.getDeclaredMethods(finishedMethodFilter)) {
                    try {
                        method.addInterceptor("com.navercorp.pinpoint.plugin.openwhisk.interceptor.TransactionIdFinishedInterceptor");
                    }
                    catch (Exception e) {
                        if (!OpenwhiskPlugin.this.logger.isWarnEnabled()) continue;
                        OpenwhiskPlugin.this.logger.warn("Unsupported method " + method, (Throwable)e);
                    }
                }
                MethodFilter failedMethodFilter = MethodFilters.chain((MethodFilter[])new MethodFilter[]{MethodFilters.name((String[])new String[]{"failed$extension"}), MethodFilters.argAt((int)2, (String)"whisk.common.StartMarker"), MethodFilters.argAt((int)3, (String)"scala.Function0")});
                for (InstrumentMethod method : target.getDeclaredMethods(failedMethodFilter)) {
                    try {
                        method.addInterceptor("com.navercorp.pinpoint.plugin.openwhisk.interceptor.TransactionIdFailedInterceptor");
                    }
                    catch (Exception e) {
                        if (!OpenwhiskPlugin.this.logger.isWarnEnabled()) continue;
                        OpenwhiskPlugin.this.logger.warn("Unsupported method " + method, (Throwable)e);
                    }
                }
                MethodFilter markMethodFilter = MethodFilters.chain((MethodFilter[])new MethodFilter[]{MethodFilters.name((String[])new String[]{"mark$extension"}), MethodFilters.argAt((int)2, (String)"whisk.common.LogMarkerToken"), MethodFilters.argAt((int)3, (String)"scala.Function0")});
                for (InstrumentMethod method : target.getDeclaredMethods(markMethodFilter)) {
                    try {
                        method.addInterceptor("com.navercorp.pinpoint.plugin.openwhisk.interceptor.TransactionIdMarkInterceptor");
                    }
                    catch (Exception e) {
                        if (!OpenwhiskPlugin.this.logger.isWarnEnabled()) continue;
                        OpenwhiskPlugin.this.logger.warn("Unsupported method " + method, (Throwable)e);
                    }
                }
                return target.toBytecode();
            }
        });
        this.transformTemplate.transform("whisk.common.StartMarker", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                target.addField(AsyncContextAccessor.class.getName());
                target.addField(PinpointTraceAccessor.class.getName());
                MethodFilter copyMethodFilter = MethodFilters.chain((MethodFilter[])new MethodFilter[]{MethodFilters.name((String[])new String[]{"copy"})});
                for (InstrumentMethod method : target.getDeclaredMethods(copyMethodFilter)) {
                    try {
                        method.addInterceptor("com.navercorp.pinpoint.plugin.openwhisk.interceptor.StartMarkerCopyInterceptor");
                    }
                    catch (Exception e) {
                        if (!OpenwhiskPlugin.this.logger.isWarnEnabled()) continue;
                        OpenwhiskPlugin.this.logger.warn("Unsupported method " + method, (Throwable)e);
                    }
                }
                return target.toBytecode();
            }
        });
        this.transformTemplate.transform("whisk.common.TransactionMetadata", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                target.addField(AsyncContextAccessor.class.getName());
                return target.toBytecode();
            }
        });
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }
}

