/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.sampler;

import com.google.common.util.concurrent.RateLimiter;
import com.navercorp.pinpoint.bootstrap.sampler.TraceSampler;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.context.id.IdGenerator;

public class RateLimitTraceSampler
implements TraceSampler {
    private final TraceSampler traceSampler;
    private final RateLimiter newRateLimiter;
    private final TraceSampler.State newSkipState;
    private final RateLimiter continueRateLimiter;
    private final TraceSampler.State continueSkipState;

    public RateLimitTraceSampler(int newMaxNewThroughput, int newMaxContinueThroughput, final IdGenerator idGenerator, TraceSampler traceSampler) {
        Assert.requireNonNull((Object)idGenerator, (String)"idGenerator");
        this.traceSampler = (TraceSampler)Assert.requireNonNull((Object)traceSampler, (String)"traceSampler");
        this.newRateLimiter = this.newRateLimiter(newMaxNewThroughput);
        this.newSkipState = new TraceSampler.State(){

            public boolean isSampled() {
                return false;
            }

            public long nextId() {
                return idGenerator.nextSkippedId();
            }
        };
        this.continueRateLimiter = this.newRateLimiter(newMaxContinueThroughput);
        this.continueSkipState = new TraceSampler.State(){

            public boolean isSampled() {
                return false;
            }

            public long nextId() {
                return idGenerator.nextContinuedSkippedId();
            }
        };
    }

    private RateLimiter newRateLimiter(int newMaxThroughput) {
        if (newMaxThroughput > 0) {
            return RateLimiter.create((double)newMaxThroughput);
        }
        return null;
    }

    public TraceSampler.State isNewSampled() {
        TraceSampler.State newState = this.traceSampler.isNewSampled();
        if (newState.isSampled()) {
            return this.getState(this.newRateLimiter, newState, this.newSkipState);
        }
        return newState;
    }

    public TraceSampler.State isContinueSampled() {
        TraceSampler.State continueState = this.traceSampler.isContinueSampled();
        if (continueState.isSampled()) {
            return this.getState(this.continueRateLimiter, continueState, this.continueSkipState);
        }
        return continueState;
    }

    private TraceSampler.State getState(RateLimiter rateLimiter, TraceSampler.State successState, TraceSampler.State failState) {
        if (rateLimiter == null) {
            return successState;
        }
        boolean acquire = rateLimiter.tryAcquire();
        if (acquire) {
            return successState;
        }
        return failState;
    }

    public TraceSampler.State getContinueDisableState() {
        return this.traceSampler.getContinueDisableState();
    }
}

