/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.monitor.collector.jvmgc;

import com.navercorp.pinpoint.profiler.monitor.collector.AgentStatMetricCollector;
import com.navercorp.pinpoint.profiler.monitor.collector.jvmgc.TJvmGcTypeUtils;
import com.navercorp.pinpoint.profiler.monitor.metric.gc.GarbageCollectorMetric;
import com.navercorp.pinpoint.profiler.monitor.metric.gc.GarbageCollectorMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.gc.JvmGcType;
import com.navercorp.pinpoint.profiler.monitor.metric.memory.MemoryMetric;
import com.navercorp.pinpoint.profiler.monitor.metric.memory.MemoryMetricSnapshot;
import com.navercorp.pinpoint.thrift.dto.TJvmGc;
import com.navercorp.pinpoint.thrift.dto.TJvmGcType;

public class BasicJvmGcMetricCollector
implements AgentStatMetricCollector<TJvmGc> {
    private final MemoryMetric memoryMetric;
    private final GarbageCollectorMetric garbageCollectorMetric;

    public BasicJvmGcMetricCollector(MemoryMetric memoryMetric, GarbageCollectorMetric garbageCollectorMetric) {
        if (memoryMetric == null) {
            throw new NullPointerException("memoryMetric must not be null");
        }
        if (garbageCollectorMetric == null) {
            throw new NullPointerException("garbageCollectorMetric must not be null");
        }
        this.memoryMetric = memoryMetric;
        this.garbageCollectorMetric = garbageCollectorMetric;
    }

    @Override
    public TJvmGc collect() {
        JvmGcType jvmGcType = this.garbageCollectorMetric.getGcType();
        TJvmGcType tJvmGcType = TJvmGcTypeUtils.toTJvmGcType(jvmGcType.getValue());
        MemoryMetricSnapshot memoryMetricSnapshot = this.memoryMetric.getSnapshot();
        GarbageCollectorMetricSnapshot garbageCollectorMetricSnapshot = this.garbageCollectorMetric.getSnapshot();
        TJvmGc jvmGc = new TJvmGc();
        jvmGc.setJvmMemoryHeapMax(memoryMetricSnapshot.getHeapMax());
        jvmGc.setJvmMemoryHeapUsed(memoryMetricSnapshot.getHeapUsed());
        jvmGc.setJvmMemoryNonHeapMax(memoryMetricSnapshot.getNonHeapMax());
        jvmGc.setJvmMemoryNonHeapUsed(memoryMetricSnapshot.getNonHeapUsed());
        jvmGc.setJvmGcOldCount(garbageCollectorMetricSnapshot.getGcOldCount());
        jvmGc.setJvmGcOldTime(garbageCollectorMetricSnapshot.getGcOldTime());
        jvmGc.setType(tJvmGcType);
        return jvmGc;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BasicJvmGcMetricCollector{");
        sb.append("memoryMetric=").append(this.memoryMetric);
        sb.append(", garbageCollectorMetric=").append(this.garbageCollectorMetric);
        sb.append('}');
        return sb.toString();
    }
}

