/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.recorder;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.context.AsyncState;
import com.navercorp.pinpoint.bootstrap.context.SpanRecorder;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.context.AsyncContextFactory;
import com.navercorp.pinpoint.profiler.context.Span;
import com.navercorp.pinpoint.profiler.context.id.TraceRoot;
import com.navercorp.pinpoint.profiler.context.recorder.DefaultSpanRecorder;
import com.navercorp.pinpoint.profiler.context.recorder.RecorderFactory;
import com.navercorp.pinpoint.profiler.context.recorder.TraceRootSpanRecorder;
import com.navercorp.pinpoint.profiler.context.recorder.WrappedSpanEventRecorder;
import com.navercorp.pinpoint.profiler.metadata.SqlMetaDataService;
import com.navercorp.pinpoint.profiler.metadata.StringMetaDataService;

public class DefaultRecorderFactory
implements RecorderFactory {
    private final StringMetaDataService stringMetaDataService;
    private final SqlMetaDataService sqlMetaDataService;
    private final Provider<AsyncContextFactory> asyncContextFactoryProvider;

    @Inject
    public DefaultRecorderFactory(Provider<AsyncContextFactory> asyncContextFactoryProvider, StringMetaDataService stringMetaDataService, SqlMetaDataService sqlMetaDataService) {
        this.asyncContextFactoryProvider = (Provider)Assert.requireNonNull(asyncContextFactoryProvider, (String)"asyncContextFactoryProvider must not be null");
        this.stringMetaDataService = (StringMetaDataService)Assert.requireNonNull((Object)stringMetaDataService, (String)"stringMetaDataService must not be null");
        this.sqlMetaDataService = (SqlMetaDataService)Assert.requireNonNull((Object)sqlMetaDataService, (String)"sqlMetaDataService must not be null");
    }

    @Override
    public SpanRecorder newSpanRecorder(Span span, boolean isRoot, boolean sampling) {
        return new DefaultSpanRecorder(span, isRoot, sampling, this.stringMetaDataService, this.sqlMetaDataService);
    }

    @Override
    public SpanRecorder newTraceRootSpanRecorder(TraceRoot traceRoot, boolean sampling) {
        return new TraceRootSpanRecorder(traceRoot, sampling);
    }

    @Override
    public WrappedSpanEventRecorder newWrappedSpanEventRecorder(TraceRoot traceRoot) {
        AsyncContextFactory asyncContextFactory = (AsyncContextFactory)this.asyncContextFactoryProvider.get();
        return new WrappedSpanEventRecorder(traceRoot, asyncContextFactory, this.stringMetaDataService, this.sqlMetaDataService, null);
    }

    @Override
    public WrappedSpanEventRecorder newWrappedSpanEventRecorder(TraceRoot traceRoot, AsyncState asyncState) {
        Assert.requireNonNull((Object)asyncState, (String)"asyncState must not be null");
        AsyncContextFactory asyncContextFactory = (AsyncContextFactory)this.asyncContextFactoryProvider.get();
        return new WrappedSpanEventRecorder(traceRoot, asyncContextFactory, this.stringMetaDataService, this.sqlMetaDataService, asyncState);
    }
}

