/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider.plugin;

import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.common.plugin.Plugin;
import com.navercorp.pinpoint.common.plugin.PluginLoader;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.instrument.classloading.ClassInjector;
import com.navercorp.pinpoint.profiler.instrument.classloading.ClassInjectorFactory;
import com.navercorp.pinpoint.profiler.plugin.ClassNameFilter;
import com.navercorp.pinpoint.profiler.plugin.ClassNameFilterChain;
import com.navercorp.pinpoint.profiler.plugin.PinpointProfilerPackageSkipFilter;
import com.navercorp.pinpoint.profiler.plugin.PluginConfig;
import com.navercorp.pinpoint.profiler.plugin.PluginPackageFilter;
import com.navercorp.pinpoint.profiler.plugin.PluginSetup;
import com.navercorp.pinpoint.profiler.plugin.SetupResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfilerPluginLoader {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ClassNameFilter profilerPackageFilter = new PinpointProfilerPackageSkipFilter();
    private final ProfilerConfig profilerConfig;
    private final PluginSetup pluginSetup;
    private final ClassInjectorFactory classInjectorFactory;
    private final PluginLoader pluginLoader;

    public ProfilerPluginLoader(ProfilerConfig profilerConfig, PluginSetup pluginSetup, ClassInjectorFactory classInjectorFactory, PluginLoader pluginLoader) {
        this.profilerConfig = (ProfilerConfig)Assert.requireNonNull((Object)profilerConfig, (String)"profilerConfig must not be null");
        this.pluginSetup = (PluginSetup)Assert.requireNonNull((Object)pluginSetup, (String)"pluginSetup must not be null");
        this.classInjectorFactory = (ClassInjectorFactory)Assert.requireNonNull((Object)classInjectorFactory, (String)"classInjectorFactory must not be null");
        this.pluginLoader = (PluginLoader)Assert.requireNonNull((Object)pluginLoader, (String)"pluginLoader must not be null");
    }

    public List<SetupResult> load() {
        List plugins = this.pluginLoader.load(ProfilerPlugin.class);
        ArrayList<SetupResult> pluginContexts = new ArrayList<SetupResult>(plugins.size());
        for (Plugin plugin : plugins) {
            List<SetupResult> setupResults = this.loadProfilerPlugin((Plugin<ProfilerPlugin>)plugin);
            pluginContexts.addAll(setupResults);
        }
        return pluginContexts;
    }

    private List<SetupResult> loadProfilerPlugin(Plugin<ProfilerPlugin> plugin) {
        List pluginPackageList = plugin.getPackageList();
        ClassNameFilter pluginFilterChain = this.createPluginFilterChain(pluginPackageList);
        List<ProfilerPlugin> filterProfilerPlugin = this.filterProfilerPlugin(plugin.getInstanceList(), this.profilerConfig.getDisabledPlugins());
        ArrayList<SetupResult> result = new ArrayList<SetupResult>();
        for (ProfilerPlugin profilerPlugin : filterProfilerPlugin) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("{} Plugin {}:{}", new Object[]{profilerPlugin.getClass(), "Pinpoint-Plugin-Package", pluginPackageList});
                this.logger.info("Loading plugin:{} pluginPackage:{}", (Object)profilerPlugin.getClass().getName(), (Object)profilerPlugin);
            }
            PluginConfig pluginConfig = new PluginConfig(plugin, pluginFilterChain);
            ClassInjector classInjector = this.classInjectorFactory.newClassInjector(pluginConfig);
            SetupResult setupResult = this.pluginSetup.setupPlugin(profilerPlugin, classInjector);
            result.add(setupResult);
        }
        return result;
    }

    private List<ProfilerPlugin> filterProfilerPlugin(List<ProfilerPlugin> originalProfilerPlugin, List<String> disabled) {
        ArrayList<ProfilerPlugin> result = new ArrayList<ProfilerPlugin>();
        for (ProfilerPlugin profilerPlugin : originalProfilerPlugin) {
            if (disabled.contains(profilerPlugin.getClass().getName())) {
                this.logger.info("Skip disabled plugin: {}", (Object)profilerPlugin.getClass().getName());
                continue;
            }
            result.add(profilerPlugin);
        }
        return result;
    }

    private ClassNameFilter createPluginFilterChain(List<String> packageList) {
        PluginPackageFilter pluginPackageFilter = new PluginPackageFilter(packageList);
        List<ClassNameFilter> chain = Arrays.asList(this.profilerPackageFilter, pluginPackageFilter);
        ClassNameFilterChain filterChain = new ClassNameFilterChain(chain);
        return filterChain;
    }
}

