/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context;

import com.navercorp.pinpoint.bootstrap.context.ServerMetaDataHolder;
import com.navercorp.pinpoint.profiler.context.DefaultServiceInfo;
import com.navercorp.pinpoint.profiler.context.ServerMetaDataRegistryService;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class DefaultServerMetaDataHolder
implements ServerMetaDataHolder {
    private final List<ServerMetaDataHolder.ServerMetaDataListener> listeners = new CopyOnWriteArrayList<ServerMetaDataHolder.ServerMetaDataListener>();
    private final ServerMetaDataRegistryService serverMetaDataRegistryService;

    public DefaultServerMetaDataHolder(ServerMetaDataRegistryService serverMetaDataRegistryService) {
        if (serverMetaDataRegistryService == null) {
            throw new NullPointerException("serverMetaDataRegistryService must not be null");
        }
        this.serverMetaDataRegistryService = serverMetaDataRegistryService;
    }

    public void setServerName(String serverName) {
        this.serverMetaDataRegistryService.setServerName(serverName);
    }

    public void addConnector(String protocol, int port) {
        this.serverMetaDataRegistryService.addConnector(protocol, port);
    }

    public void addServiceInfo(String serviceName, List<String> serviceLibs) {
        DefaultServiceInfo serviceInfo = new DefaultServiceInfo(serviceName, serviceLibs);
        this.serverMetaDataRegistryService.addServiceInfo(serviceInfo);
    }

    public void addListener(ServerMetaDataHolder.ServerMetaDataListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ServerMetaDataHolder.ServerMetaDataListener listener) {
        this.listeners.remove(listener);
    }

    public void notifyListeners() {
        this.serverMetaDataRegistryService.notifyListeners();
    }
}

