/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.httpclient4.interceptor;

import com.navercorp.pinpoint.bootstrap.config.HttpDumpConfig;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScope;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScopeInvocation;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.pair.NameIntValuePair;
import com.navercorp.pinpoint.bootstrap.plugin.request.ClientHeaderAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.ClientRequestAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.ClientRequestRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.request.ClientRequestWrapper;
import com.navercorp.pinpoint.bootstrap.plugin.request.ClientRequestWrapperAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.DefaultRequestTraceWriter;
import com.navercorp.pinpoint.bootstrap.plugin.request.RequestTraceWriter;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.CookieExtractor;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.CookieRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.CookieRecorderFactory;
import com.navercorp.pinpoint.common.plugin.util.HostAndPort;
import com.navercorp.pinpoint.common.trace.AnnotationKey;
import com.navercorp.pinpoint.common.util.IntBooleanIntBooleanValue;
import com.navercorp.pinpoint.plugin.httpclient4.HttpCallContext;
import com.navercorp.pinpoint.plugin.httpclient4.HttpCallContextFactory;
import com.navercorp.pinpoint.plugin.httpclient4.HttpClient4Constants;
import com.navercorp.pinpoint.plugin.httpclient4.HttpClient4CookieExtractor;
import com.navercorp.pinpoint.plugin.httpclient4.HttpClient4PluginConfig;
import com.navercorp.pinpoint.plugin.httpclient4.HttpClient4RequestWrapper;
import com.navercorp.pinpoint.plugin.httpclient4.HttpRequest4ClientHeaderAdaptor;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;

public class HttpRequestExecutorExecuteMethodInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final TraceContext traceContext;
    private final MethodDescriptor methodDescriptor;
    private final boolean statusCode;
    private final InterceptorScope interceptorScope;
    private final boolean io;
    private final ClientRequestRecorder<ClientRequestWrapper> clientRequestRecorder;
    private final CookieRecorder<HttpRequest> cookieRecorder;
    private final RequestTraceWriter<HttpRequest> requestTraceWriter;

    public HttpRequestExecutorExecuteMethodInterceptor(TraceContext traceContext, MethodDescriptor methodDescriptor, InterceptorScope interceptorScope) {
        this.traceContext = traceContext;
        this.methodDescriptor = methodDescriptor;
        this.interceptorScope = interceptorScope;
        HttpClient4PluginConfig profilerConfig = new HttpClient4PluginConfig(traceContext.getProfilerConfig());
        ClientRequestAdaptor clientRequestAdaptor = ClientRequestWrapperAdaptor.INSTANCE;
        this.clientRequestRecorder = new ClientRequestRecorder(profilerConfig.isParam(), clientRequestAdaptor);
        CookieExtractor<HttpRequest> cookieExtractor = HttpClient4CookieExtractor.INSTANCE;
        this.cookieRecorder = CookieRecorderFactory.newCookieRecorder((HttpDumpConfig)profilerConfig.getHttpDumpConfig(), cookieExtractor);
        this.statusCode = profilerConfig.isStatusCode();
        this.io = profilerConfig.isIo();
        HttpRequest4ClientHeaderAdaptor clientHeaderAdaptor = new HttpRequest4ClientHeaderAdaptor();
        this.requestTraceWriter = new DefaultRequestTraceWriter((ClientHeaderAdaptor)clientHeaderAdaptor, traceContext);
    }

    public void before(Object target, Object[] args) {
        InterceptorScopeInvocation invocation;
        Trace trace;
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, args);
        }
        if ((trace = this.traceContext.currentRawTraceObject()) == null) {
            return;
        }
        HttpRequest httpRequest = this.getHttpRequest(args);
        NameIntValuePair<String> host = this.getHost();
        boolean sampling = trace.canSampled();
        if (!sampling) {
            if (httpRequest != null) {
                this.requestTraceWriter.write((Object)httpRequest);
            }
            return;
        }
        SpanEventRecorder recorder = trace.traceBlockBegin();
        TraceId nextId = trace.getTraceId().getNextTraceId();
        recorder.recordNextSpanId(nextId.getSpanId());
        recorder.recordServiceType(HttpClient4Constants.HTTP_CLIENT_4);
        if (httpRequest != null) {
            String hostString = this.getHostString((String)host.getName(), host.getValue());
            this.requestTraceWriter.write((Object)httpRequest, nextId, hostString);
        }
        if ((invocation = this.interceptorScope.getCurrentInvocation()) != null) {
            invocation.getOrCreateAttachment(HttpCallContextFactory.HTTPCALL_CONTEXT_FACTORY);
        }
    }

    private String getHostString(String hostName, int port) {
        if (hostName != null) {
            return HostAndPort.toHostAndPortString((String)hostName, (int)port);
        }
        return null;
    }

    private HttpRequest getHttpRequest(Object[] args) {
        if (args != null && args.length >= 1 && args[0] != null && args[0] instanceof HttpRequest) {
            return (HttpRequest)args[0];
        }
        return null;
    }

    private NameIntValuePair<String> getHost() {
        InterceptorScopeInvocation transaction = this.interceptorScope.getCurrentInvocation();
        Object attachment = this.getAttachment(transaction);
        if (attachment instanceof HttpCallContext) {
            HttpCallContext callContext = (HttpCallContext)attachment;
            return new NameIntValuePair((Object)callContext.getHost(), callContext.getPort());
        }
        return new NameIntValuePair(null, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        Trace trace;
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        try {
            Integer statusCodeValue;
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            HttpRequest httpRequest = this.getHttpRequest(args);
            NameIntValuePair<String> host = this.getHost();
            if (httpRequest != null) {
                HttpClient4RequestWrapper clientRequest = new HttpClient4RequestWrapper(httpRequest, (String)host.getName(), host.getValue());
                this.clientRequestRecorder.record(recorder, (Object)clientRequest, throwable);
                this.cookieRecorder.record(recorder, (Object)httpRequest, throwable);
            }
            if (this.statusCode && (statusCodeValue = this.getStatusCode(result)) != null) {
                recorder.recordAttribute(AnnotationKey.HTTP_STATUS_CODE, (Object)statusCodeValue);
            }
            recorder.recordApi(this.methodDescriptor);
            recorder.recordException(throwable);
            InterceptorScopeInvocation invocation = this.interceptorScope.getCurrentInvocation();
            Object attachment = this.getAttachment(invocation);
            if (attachment instanceof HttpCallContext) {
                HttpCallContext callContext = (HttpCallContext)attachment;
                this.logger.debug("Check call context {}", (Object)callContext);
                if (this.io) {
                    IntBooleanIntBooleanValue value = new IntBooleanIntBooleanValue((int)callContext.getWriteElapsedTime(), callContext.isWriteFail(), (int)callContext.getReadElapsedTime(), callContext.isReadFail());
                    recorder.recordAttribute(AnnotationKey.HTTP_IO, (Object)value);
                }
                invocation.removeAttachment();
            }
        }
        finally {
            trace.traceBlockEnd();
        }
    }

    private Object getAttachment(InterceptorScopeInvocation invocation) {
        if (invocation == null) {
            return null;
        }
        return invocation.getAttachment();
    }

    private Integer getStatusCode(Object result) {
        return this.getStatusCodeFromResponse(result);
    }

    Integer getStatusCodeFromResponse(Object result) {
        if (result != null && result instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)result;
            StatusLine statusLine = response.getStatusLine();
            if (statusLine != null) {
                return statusLine.getStatusCode();
            }
            return null;
        }
        return null;
    }
}

