/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.druid;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.bootstrap.plugin.util.InstrumentUtils;
import com.navercorp.pinpoint.plugin.druid.DruidConfig;
import java.security.ProtectionDomain;

public class DruidPlugin
implements ProfilerPlugin,
TransformTemplateAware {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private DruidConfig config;
    private TransformTemplate transformTemplate;

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }

    public void setup(ProfilerPluginSetupContext context) {
        this.config = new DruidConfig(context.getConfig());
        if (!this.config.isPluginEnable()) {
            this.logger.info("Disable druid option. 'profiler.jdbc.druid=false'");
            return;
        }
        this.addDruidDataSourceTransformer();
        if (this.config.isProfileClose()) {
            this.addDruidPooledConnectionTransformer();
        }
    }

    private boolean isAvailableDataSourceMonitor(InstrumentClass target) {
        return target.hasMethod("getUrl", new String[0]) && target.hasMethod("getMaxActive", new String[0]) && target.hasMethod("getActiveCount", new String[0]);
    }

    private void addDruidPooledConnectionTransformer() {
        this.transformTemplate.transform("com.alibaba.druid.pool.DruidPooledConnection", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                InstrumentMethod closeMethod = InstrumentUtils.findMethod((InstrumentClass)target, (String)"close", (String[])new String[0]);
                closeMethod.addScopedInterceptor("com.navercorp.pinpoint.plugin.druid.interceptor.DataSourceCloseConnectionInterceptor", "DRUID_SCOPE");
                return target.toBytecode();
            }
        });
    }

    private void addDruidDataSourceTransformer() {
        this.transformTemplate.transform("com.alibaba.druid.pool.DruidDataSource", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                if (DruidPlugin.this.isAvailableDataSourceMonitor(target)) {
                    target.addField("com.navercorp.pinpoint.plugin.druid.DataSourceMonitorAccessor");
                    InstrumentMethod closeMethod = InstrumentUtils.findMethod((InstrumentClass)target, (String)"close", (String[])new String[0]);
                    closeMethod.addScopedInterceptor("com.navercorp.pinpoint.plugin.druid.interceptor.DataSourceCloseInterceptor", "DRUID_SCOPE");
                    InstrumentMethod defaultConstructor = InstrumentUtils.findConstructor((InstrumentClass)target, (String[])new String[0]);
                    defaultConstructor.addScopedInterceptor("com.navercorp.pinpoint.plugin.druid.interceptor.DataSourceConstructorInterceptor", "DRUID_SCOPE");
                }
                InstrumentMethod getConnectionMethod = InstrumentUtils.findMethod((InstrumentClass)target, (String)"getConnection", (String[])new String[0]);
                getConnectionMethod.addScopedInterceptor("com.navercorp.pinpoint.plugin.druid.interceptor.DataSourceGetConnectionInterceptor", "DRUID_SCOPE");
                getConnectionMethod = InstrumentUtils.findMethod((InstrumentClass)target, (String)"getConnection", (String[])new String[]{"java.lang.String", "java.lang.String"});
                getConnectionMethod.addScopedInterceptor("com.navercorp.pinpoint.plugin.druid.interceptor.DataSourceGetConnectionInterceptor", "DRUID_SCOPE");
                return target.toBytecode();
            }
        });
    }
}

