/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.okhttp.v2.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScope;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScopeInvocation;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.request.ClientHeaderAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.DefaultRequestTraceWriter;
import com.navercorp.pinpoint.bootstrap.plugin.request.RequestTraceWriter;
import com.navercorp.pinpoint.plugin.okhttp.v2.RequestBuilder2ClientHeaderAdaptor;
import com.squareup.okhttp.Request;

public abstract class AbstractRequestBuilderBuildMethodInterceptor
implements AroundInterceptor {
    protected final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    protected final boolean isDebug = this.logger.isDebugEnabled();
    protected final TraceContext traceContext;
    protected final MethodDescriptor methodDescriptor;
    protected final InterceptorScope interceptorScope;
    protected final RequestTraceWriter<Request.Builder> requestTraceWriter;

    public AbstractRequestBuilderBuildMethodInterceptor(TraceContext traceContext, MethodDescriptor methodDescriptor, InterceptorScope interceptorScope) {
        this.traceContext = traceContext;
        this.methodDescriptor = methodDescriptor;
        this.interceptorScope = interceptorScope;
        RequestBuilder2ClientHeaderAdaptor clientHeaderAdaptor = new RequestBuilder2ClientHeaderAdaptor();
        this.requestTraceWriter = new DefaultRequestTraceWriter((ClientHeaderAdaptor)clientHeaderAdaptor, traceContext);
    }

    abstract String toHost(Object var1);

    public void before(Object target, Object[] args) {
        Trace trace;
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, args);
        }
        if ((trace = this.traceContext.currentRawTraceObject()) == null) {
            return;
        }
        try {
            if (!(target instanceof Request.Builder)) {
                return;
            }
            Request.Builder builder = (Request.Builder)target;
            if (!trace.canSampled()) {
                if (builder != null) {
                    this.requestTraceWriter.write((Object)builder);
                }
                return;
            }
            InterceptorScopeInvocation invocation = this.interceptorScope.getCurrentInvocation();
            Object attachment = this.getAttachment(invocation);
            if (!(attachment instanceof TraceId)) {
                if (this.isDebug) {
                    this.logger.debug("Invalid interceptor scope invocation. {}", (Object)invocation);
                }
                return;
            }
            TraceId nextId = (TraceId)attachment;
            String host = this.toHost(target);
            this.requestTraceWriter.write((Object)builder, nextId, host);
        }
        catch (Throwable t) {
            this.logger.warn("Failed to BEFORE process. {}", (Object)t.getMessage(), (Object)t);
        }
    }

    private Object getAttachment(InterceptorScopeInvocation invocation) {
        if (invocation == null) {
            return null;
        }
        return invocation.getAttachment();
    }

    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args);
        }
    }
}

