/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.jboss.util;

import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.security.InetAddressPrincipal;

public class JbossUtility {
    private static final PLogger LOGGER = PLoggerFactory.getLogger(JbossUtility.class);

    public static String fetchRemoteAddress(Connection connection) {
        if (connection == null) {
            return "";
        }
        ArrayList<String> remoteAddressInfos = new ArrayList<String>();
        for (Principal principal : connection.getPrincipals()) {
            if (!(principal instanceof InetAddressPrincipal)) continue;
            InetAddress inetAddress = ((InetAddressPrincipal)principal).getInetAddress();
            JbossUtility.initializeRemoteAddressInfo(remoteAddressInfos, inetAddress);
            break;
        }
        return ((Object)remoteAddressInfos).toString();
    }

    private static void initializeRemoteAddressInfo(List<String> remoteAddressInfos, InetAddress inetAddress) {
        if (inetAddress == null) {
            return;
        }
        try {
            NetworkInterface networkInterface = NetworkInterface.getByInetAddress(inetAddress);
            Enumeration<NetworkInterface> networkInterfaceEnum = networkInterface.getNetworkInterfaces();
            while (networkInterfaceEnum.hasMoreElements()) {
                NetworkInterface nextNetworkInterfaceElement = networkInterfaceEnum.nextElement();
                Enumeration<InetAddress> inetAddressEnum = nextNetworkInterfaceElement.getInetAddresses();
                while (inetAddressEnum.hasMoreElements()) {
                    InetAddress nextInetAddressElement = inetAddressEnum.nextElement();
                    remoteAddressInfos.add(nextInetAddressElement.getHostAddress());
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("An error occurred while searching for a network interface that has specified address bound to it - {}" + inetAddress, (Throwable)exception);
        }
    }

    public static String fetchRemoteAddressDetails(String remoteAddress) {
        ArrayList<String> remoteAddressInfos = new ArrayList<String>();
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(remoteAddress);
        }
        catch (UnknownHostException unknownHostException) {
            LOGGER.error("An error occurred while fetching ip address from host name - {}", (Object)remoteAddress, (Object)unknownHostException);
            return remoteAddress;
        }
        JbossUtility.initializeRemoteAddressInfo(remoteAddressInfos, inetAddress);
        return ((Object)remoteAddressInfos).toString();
    }
}

