/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler;

import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.BaseClassFileTransformer;
import com.navercorp.pinpoint.profiler.ClassFileFilter;
import com.navercorp.pinpoint.profiler.ClassFileTransformerDispatcher;
import com.navercorp.pinpoint.profiler.DynamicTransformerRegistry;
import com.navercorp.pinpoint.profiler.PinpointClassFilter;
import com.navercorp.pinpoint.profiler.PinpointClassLoaderFilter;
import com.navercorp.pinpoint.profiler.UnmodifiableClassFilter;
import com.navercorp.pinpoint.profiler.instrument.transformer.LambdaClassFileResolver;
import com.navercorp.pinpoint.profiler.instrument.transformer.TransformerRegistry;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;

public class DefaultClassFileTransformerDispatcher
implements ClassFileTransformerDispatcher {
    private final BaseClassFileTransformer baseClassFileTransformer = new BaseClassFileTransformer(this.getClass().getClassLoader());
    private final TransformerRegistry transformerRegistry;
    private final DynamicTransformerRegistry dynamicTransformerRegistry;
    private final TransformerRegistry debugTransformerRegistry;
    private final ClassFileFilter classLoaderFilter;
    private final ClassFileFilter pinpointClassFilter;
    private final ClassFileFilter unmodifiableFilter;
    private final LambdaClassFileResolver lambdaClassFileResolver;

    public DefaultClassFileTransformerDispatcher(TransformerRegistry transformerRegistry, TransformerRegistry debugTransformerRegistry, DynamicTransformerRegistry dynamicTransformerRegistry, LambdaClassFileResolver lambdaClassFileResolver) {
        this.debugTransformerRegistry = (TransformerRegistry)Assert.requireNonNull((Object)debugTransformerRegistry, (String)"debugTransformerRegistry must not be null");
        this.classLoaderFilter = new PinpointClassLoaderFilter(this.getClass().getClassLoader());
        this.pinpointClassFilter = new PinpointClassFilter();
        this.unmodifiableFilter = new UnmodifiableClassFilter();
        this.transformerRegistry = (TransformerRegistry)Assert.requireNonNull((Object)transformerRegistry, (String)"transformerRegistry must not be null");
        this.dynamicTransformerRegistry = (DynamicTransformerRegistry)Assert.requireNonNull((Object)dynamicTransformerRegistry, (String)"dynamicTransformerRegistry must not be null");
        this.lambdaClassFileResolver = (LambdaClassFileResolver)Assert.requireNonNull((Object)lambdaClassFileResolver, (String)"lambdaClassFileResolver must not be null");
    }

    @Override
    public byte[] transform(ClassLoader classLoader, String classInternalName, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classFileBuffer) throws IllegalClassFormatException {
        if (!this.classLoaderFilter.accept(classLoader, classInternalName, classBeingRedefined, protectionDomain, classFileBuffer)) {
            return null;
        }
        String internalName = this.lambdaClassFileResolver.resolve(classLoader, classInternalName, protectionDomain, classFileBuffer);
        if (internalName == null) {
            return null;
        }
        if (!this.pinpointClassFilter.accept(classLoader, internalName, classBeingRedefined, protectionDomain, classFileBuffer)) {
            return null;
        }
        ClassFileTransformer dynamicTransformer = this.dynamicTransformerRegistry.getTransformer(classLoader, internalName);
        if (dynamicTransformer != null) {
            return this.baseClassFileTransformer.transform(classLoader, internalName, classBeingRedefined, protectionDomain, classFileBuffer, dynamicTransformer);
        }
        if (!this.unmodifiableFilter.accept(classLoader, internalName, classBeingRedefined, protectionDomain, classFileBuffer)) {
            return null;
        }
        ClassFileTransformer transformer = this.transformerRegistry.findTransformer(classLoader, internalName, classFileBuffer);
        if (transformer == null && (transformer = this.debugTransformerRegistry.findTransformer(classLoader, internalName, classFileBuffer)) == null) {
            return null;
        }
        return this.baseClassFileTransformer.transform(classLoader, internalName, classBeingRedefined, protectionDomain, classFileBuffer, transformer);
    }
}

