/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument;

import com.navercorp.pinpoint.bootstrap.instrument.ClassFilter;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentContext;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilter;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilters;
import com.navercorp.pinpoint.bootstrap.instrument.NotFoundInstrumentException;
import com.navercorp.pinpoint.bootstrap.interceptor.annotation.TargetConstructor;
import com.navercorp.pinpoint.bootstrap.interceptor.annotation.TargetConstructors;
import com.navercorp.pinpoint.bootstrap.interceptor.annotation.TargetFilter;
import com.navercorp.pinpoint.bootstrap.interceptor.annotation.TargetMethod;
import com.navercorp.pinpoint.bootstrap.interceptor.annotation.TargetMethods;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.ExecutionPolicy;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScope;
import com.navercorp.pinpoint.bootstrap.plugin.ObjectFactory;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.common.util.JvmUtils;
import com.navercorp.pinpoint.common.util.JvmVersion;
import com.navercorp.pinpoint.exception.PinpointException;
import com.navercorp.pinpoint.profiler.instrument.ASMAspectWeaver;
import com.navercorp.pinpoint.profiler.instrument.ASMClassNodeAdapter;
import com.navercorp.pinpoint.profiler.instrument.ASMFieldNodeAdapter;
import com.navercorp.pinpoint.profiler.instrument.ASMMethod;
import com.navercorp.pinpoint.profiler.instrument.ASMMethodNodeAdapter;
import com.navercorp.pinpoint.profiler.instrument.ASMNestedClass;
import com.navercorp.pinpoint.profiler.instrument.AccessorAnalyzer;
import com.navercorp.pinpoint.profiler.instrument.EngineComponent;
import com.navercorp.pinpoint.profiler.instrument.GetterAnalyzer;
import com.navercorp.pinpoint.profiler.instrument.SetterAnalyzer;
import com.navercorp.pinpoint.profiler.objectfactory.ArgumentProvider;
import com.navercorp.pinpoint.profiler.objectfactory.AutoBindingObjectFactory;
import com.navercorp.pinpoint.profiler.objectfactory.InterceptorArgumentProvider;
import com.navercorp.pinpoint.profiler.objectfactory.ObjectBinderFactory;
import com.navercorp.pinpoint.profiler.util.JavaAssistUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ASMClass
implements InstrumentClass {
    private static final String FIELD_PREFIX = "_$PINPOINT$_";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final EngineComponent engineComponent;
    private final InstrumentContext pluginContext;
    private final ClassLoader classLoader;
    private final ASMClassNodeAdapter classNode;
    private boolean modified = false;
    private String name;

    public ASMClass(EngineComponent engineComponent, InstrumentContext pluginContext, ClassLoader classLoader, ClassNode classNode) {
        this(engineComponent, pluginContext, classLoader, new ASMClassNodeAdapter(pluginContext, classLoader, classNode));
    }

    public ASMClass(EngineComponent engineComponent, InstrumentContext pluginContext, ClassLoader classLoader, ASMClassNodeAdapter classNode) {
        this.engineComponent = (EngineComponent)Assert.requireNonNull((Object)engineComponent, (String)"engineComponent must not be null");
        this.pluginContext = pluginContext;
        this.classLoader = classLoader;
        this.classNode = classNode;
        this.name = classNode.getName();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public boolean isInterceptable() {
        if (this.isAnnotation() || this.isModified()) {
            return false;
        }
        return !this.isInterface() || this.classNode.getMajorVersion() >= 52 && JvmUtils.getVersion().onOrAfter(JvmVersion.JAVA_8);
    }

    public boolean isInterface() {
        return this.classNode.isInterface();
    }

    private boolean isAnnotation() {
        return this.classNode.isAnnotation();
    }

    public String getName() {
        return this.name;
    }

    public String getSuperClass() {
        return this.classNode.getSuperClassName();
    }

    public String[] getInterfaces() {
        return this.classNode.getInterfaceNames();
    }

    public InstrumentMethod getDeclaredMethod(String name, String ... parameterTypes) {
        String desc = JavaAssistUtils.javaTypeToJvmSignature(parameterTypes);
        ASMMethodNodeAdapter methodNode = this.classNode.getDeclaredMethod(name, desc);
        if (methodNode == null) {
            return null;
        }
        return new ASMMethod(this.engineComponent, this.pluginContext, this, methodNode);
    }

    public List<InstrumentMethod> getDeclaredMethods() {
        return this.getDeclaredMethods(MethodFilters.ACCEPT_ALL);
    }

    public List<InstrumentMethod> getDeclaredMethods(MethodFilter methodFilter) {
        if (methodFilter == null) {
            throw new NullPointerException("methodFilter must not be null");
        }
        ArrayList<InstrumentMethod> candidateList = new ArrayList<InstrumentMethod>();
        for (ASMMethodNodeAdapter methodNode : this.classNode.getDeclaredMethods()) {
            ASMMethod method = new ASMMethod(this.engineComponent, this.pluginContext, this, methodNode);
            if (!methodFilter.accept((InstrumentMethod)method)) continue;
            candidateList.add(method);
        }
        return candidateList;
    }

    public InstrumentMethod getConstructor(String ... parameterTypes) {
        return this.getDeclaredMethod("<init>", parameterTypes);
    }

    public boolean hasDeclaredMethod(String methodName, String ... parameterTypes) {
        String desc = JavaAssistUtils.javaTypeToJvmSignature(parameterTypes);
        return this.classNode.hasDeclaredMethod(methodName, desc);
    }

    public boolean hasMethod(String methodName, String ... parameterTypes) {
        String desc = JavaAssistUtils.javaTypeToJvmSignature(parameterTypes);
        return this.classNode.hasMethod(methodName, desc);
    }

    public boolean hasEnclosingMethod(String methodName, String ... parameterTypes) {
        String desc = JavaAssistUtils.javaTypeToJvmSignature(parameterTypes);
        return this.classNode.hasOutClass(methodName, desc);
    }

    public boolean hasConstructor(String ... parameterTypeArray) {
        return this.getConstructor(parameterTypeArray) != null;
    }

    public boolean hasField(String name, String type) {
        String desc = type == null ? null : JavaAssistUtils.toJvmSignature(type);
        return this.classNode.getField(name, desc) != null;
    }

    public boolean hasField(String name) {
        return this.hasField(name, null);
    }

    public void weave(String adviceClassName) throws InstrumentException {
        if (adviceClassName == null) {
            throw new NotFoundInstrumentException("advice class name must not be null");
        }
        ASMClassNodeAdapter adviceClassNode = ASMClassNodeAdapter.get(this.pluginContext, this.classLoader, JavaAssistUtils.javaNameToJvmName(adviceClassName));
        if (adviceClassNode == null) {
            throw new NotFoundInstrumentException(adviceClassName + " not found.");
        }
        ASMAspectWeaver aspectWeaver = new ASMAspectWeaver();
        aspectWeaver.weaving(this.classNode, adviceClassNode);
        this.setModified(true);
    }

    public InstrumentMethod addDelegatorMethod(String methodName, String ... paramTypes) throws InstrumentException {
        if (this.getDeclaredMethod(methodName, paramTypes) != null) {
            throw new InstrumentException(this.getName() + " already have method(" + methodName + ").");
        }
        ASMClassNodeAdapter superClassNode = ASMClassNodeAdapter.get(this.pluginContext, this.classLoader, this.classNode.getSuperClassInternalName());
        if (superClassNode == null) {
            throw new NotFoundInstrumentException(this.getName() + " not found super class(" + this.classNode.getSuperClassInternalName() + ")");
        }
        String desc = JavaAssistUtils.javaTypeToJvmSignature(paramTypes);
        ASMMethodNodeAdapter superMethodNode = superClassNode.getDeclaredMethod(methodName, desc);
        if (superMethodNode == null) {
            throw new NotFoundInstrumentException(methodName + desc + " is not found in " + superClassNode.getInternalName());
        }
        ASMMethodNodeAdapter methodNode = this.classNode.addDelegatorMethod(superMethodNode);
        this.setModified(true);
        return new ASMMethod(this.engineComponent, this.pluginContext, this, methodNode);
    }

    public void addField(String accessorTypeName) throws InstrumentException {
        try {
            Class accessorType = this.pluginContext.injectClass(this.classLoader, accessorTypeName);
            AccessorAnalyzer accessorAnalyzer = new AccessorAnalyzer();
            AccessorAnalyzer.AccessorDetails accessorDetails = accessorAnalyzer.analyze(accessorType);
            Type type = Type.getType(accessorDetails.getFieldType());
            ASMFieldNodeAdapter fieldNode = this.classNode.addField(FIELD_PREFIX + JavaAssistUtils.javaClassNameToVariableName(accessorTypeName), type.getDescriptor());
            this.classNode.addInterface(accessorTypeName);
            this.classNode.addGetterMethod(accessorDetails.getGetter().getName(), fieldNode);
            this.classNode.addSetterMethod(accessorDetails.getSetter().getName(), fieldNode);
            this.setModified(true);
        }
        catch (Exception e) {
            throw new InstrumentException("Failed to add field with accessor [" + accessorTypeName + "]. Cause:" + e.getMessage(), (Throwable)e);
        }
    }

    public void addGetter(String getterTypeName, String fieldName) throws InstrumentException {
        try {
            Class getterType = this.pluginContext.injectClass(this.classLoader, getterTypeName);
            GetterAnalyzer.GetterDetails getterDetails = new GetterAnalyzer().analyze(getterType);
            ASMFieldNodeAdapter fieldNode = this.classNode.getField(fieldName, null);
            if (fieldNode == null) {
                throw new IllegalArgumentException("Not found field. name=" + fieldName);
            }
            String fieldTypeName = JavaAssistUtils.javaClassNameToObjectName(getterDetails.getFieldType().getName());
            if (!fieldNode.getClassName().equals(fieldTypeName)) {
                throw new IllegalArgumentException("different return type. return=" + fieldTypeName + ", field=" + fieldNode.getClassName());
            }
            this.classNode.addGetterMethod(getterDetails.getGetter().getName(), fieldNode);
            this.classNode.addInterface(getterTypeName);
            this.setModified(true);
        }
        catch (Exception e) {
            throw new InstrumentException("Failed to add getter: " + getterTypeName, (Throwable)e);
        }
    }

    public void addSetter(String setterTypeName, String fieldName) throws InstrumentException {
        this.addSetter(setterTypeName, fieldName, false);
    }

    public void addSetter(String setterTypeName, String fieldName, boolean removeFinal) throws InstrumentException {
        try {
            Class setterType = this.pluginContext.injectClass(this.classLoader, setterTypeName);
            SetterAnalyzer.SetterDetails setterDetails = new SetterAnalyzer().analyze(setterType);
            ASMFieldNodeAdapter fieldNode = this.classNode.getField(fieldName, null);
            if (fieldNode == null) {
                throw new IllegalArgumentException("Not found field. name=" + fieldName);
            }
            String fieldTypeName = JavaAssistUtils.javaClassNameToObjectName(setterDetails.getFieldType().getName());
            if (!fieldNode.getClassName().equals(fieldTypeName)) {
                throw new IllegalArgumentException("Argument type of the setter is different with the field type. setterMethod: " + fieldTypeName + ", fieldType: " + fieldNode.getClassName());
            }
            if (fieldNode.isStatic()) {
                throw new IllegalArgumentException("Cannot add setter to static fields. setterMethod: " + setterDetails.getSetter().getName() + ", fieldName: " + fieldName);
            }
            int original = fieldNode.getAccess();
            boolean finalRemoved = false;
            if (fieldNode.isFinal()) {
                if (!removeFinal) {
                    throw new IllegalArgumentException("Cannot add setter to final field. setterMethod: " + setterDetails.getSetter().getName() + ", fieldName: " + fieldName);
                }
                int removed = original & 0xFFFFFFEF;
                fieldNode.setAccess(removed);
                finalRemoved = true;
            }
            try {
                this.classNode.addSetterMethod(setterDetails.getSetter().getName(), fieldNode);
                this.classNode.addInterface(setterTypeName);
                this.setModified(true);
            }
            catch (Exception e) {
                if (finalRemoved) {
                    fieldNode.setAccess(original);
                }
                throw e;
            }
        }
        catch (Exception e) {
            throw new InstrumentException("Failed to add setter: " + setterTypeName, (Throwable)e);
        }
    }

    public int addInterceptor(String interceptorClassName) throws InstrumentException {
        Assert.requireNonNull((Object)interceptorClassName, (String)"interceptorClassName must not be null");
        return this.addInterceptor0(interceptorClassName, null, null, null);
    }

    public int addInterceptor(String interceptorClassName, Object[] constructorArgs) throws InstrumentException {
        Assert.requireNonNull((Object)interceptorClassName, (String)"interceptorClassName must not be null");
        Assert.requireNonNull((Object)constructorArgs, (String)"constructorArgs  must not be null");
        return this.addInterceptor0(interceptorClassName, constructorArgs, null, null);
    }

    public int addScopedInterceptor(String interceptorClassName, String scopeName) throws InstrumentException {
        Assert.requireNonNull((Object)interceptorClassName, (String)"interceptorClassName must not be null");
        Assert.requireNonNull((Object)scopeName, (String)"scopeName must not be null");
        InterceptorScope interceptorScope = this.pluginContext.getInterceptorScope(scopeName);
        return this.addInterceptor0(interceptorClassName, null, interceptorScope, ExecutionPolicy.BOUNDARY);
    }

    public int addScopedInterceptor(String interceptorClassName, InterceptorScope scope) throws InstrumentException {
        Assert.requireNonNull((Object)interceptorClassName, (String)"interceptorClassName must not be null");
        Assert.requireNonNull((Object)scope, (String)"scope must not be null");
        return this.addInterceptor0(interceptorClassName, null, scope, ExecutionPolicy.BOUNDARY);
    }

    public int addScopedInterceptor(String interceptorClassName, Object[] constructorArgs, String scopeName) throws InstrumentException {
        Assert.requireNonNull((Object)interceptorClassName, (String)"interceptorClassName must not be null");
        Assert.requireNonNull((Object)constructorArgs, (String)"constructorArgs must not be null");
        Assert.requireNonNull((Object)scopeName, (String)"scopeName must not be null");
        InterceptorScope interceptorScope = this.pluginContext.getInterceptorScope(scopeName);
        return this.addInterceptor0(interceptorClassName, constructorArgs, interceptorScope, ExecutionPolicy.BOUNDARY);
    }

    public int addScopedInterceptor(String interceptorClassName, Object[] constructorArgs, InterceptorScope scope) throws InstrumentException {
        Assert.requireNonNull((Object)interceptorClassName, (String)"interceptorClassName must not be null");
        Assert.requireNonNull((Object)constructorArgs, (String)"constructorArgs must not be null");
        Assert.requireNonNull((Object)scope, (String)"scope must not be null");
        return this.addInterceptor0(interceptorClassName, constructorArgs, scope, ExecutionPolicy.BOUNDARY);
    }

    public int addScopedInterceptor(String interceptorClassName, String scopeName, ExecutionPolicy executionPolicy) throws InstrumentException {
        Assert.requireNonNull((Object)interceptorClassName, (String)"interceptorClassName must not be null");
        Assert.requireNonNull((Object)scopeName, (String)"scopeName must not be null");
        Assert.requireNonNull((Object)executionPolicy, (String)"executionPolicy must not be null");
        InterceptorScope interceptorScope = this.pluginContext.getInterceptorScope(scopeName);
        return this.addInterceptor0(interceptorClassName, null, interceptorScope, executionPolicy);
    }

    public int addScopedInterceptor(String interceptorClassName, InterceptorScope scope, ExecutionPolicy executionPolicy) throws InstrumentException {
        Assert.requireNonNull((Object)interceptorClassName, (String)"interceptorClassName must not be null");
        Assert.requireNonNull((Object)scope, (String)"scope must not be null");
        Assert.requireNonNull((Object)executionPolicy, (String)"executionPolicy must not be null");
        return this.addInterceptor0(interceptorClassName, null, scope, executionPolicy);
    }

    public int addScopedInterceptor(String interceptorClassName, Object[] constructorArgs, String scopeName, ExecutionPolicy executionPolicy) throws InstrumentException {
        Assert.requireNonNull((Object)interceptorClassName, (String)"interceptorClassName must not be null");
        Assert.requireNonNull((Object)constructorArgs, (String)"constructorArgs must not be null");
        Assert.requireNonNull((Object)scopeName, (String)"scopeName must not be null");
        Assert.requireNonNull((Object)executionPolicy, (String)"executionPolicy must not be null");
        InterceptorScope interceptorScope = this.pluginContext.getInterceptorScope(scopeName);
        return this.addInterceptor0(interceptorClassName, constructorArgs, interceptorScope, executionPolicy);
    }

    public int addScopedInterceptor(String interceptorClassName, Object[] constructorArgs, InterceptorScope scope, ExecutionPolicy executionPolicy) throws InstrumentException {
        Assert.requireNonNull((Object)interceptorClassName, (String)"interceptorClassName must not be null");
        Assert.requireNonNull((Object)constructorArgs, (String)"constructorArgs must not be null");
        Assert.requireNonNull((Object)scope, (String)"scope must not be null");
        Assert.requireNonNull((Object)executionPolicy, (String)"executionPolicy must not be null");
        return this.addInterceptor0(interceptorClassName, constructorArgs, scope, executionPolicy);
    }

    private int addInterceptor0(String interceptorClassName, Object[] constructorArgs, InterceptorScope scope, ExecutionPolicy executionPolicy) throws InstrumentException {
        TargetFilter targetFilter;
        TargetConstructor targetConstructor;
        TargetConstructors targetConstructors;
        TargetMethod targetMethod;
        int interceptorId = -1;
        Class interceptorType = this.pluginContext.injectClass(this.classLoader, interceptorClassName);
        TargetMethods targetMethods = interceptorType.getAnnotation(TargetMethods.class);
        if (targetMethods != null) {
            for (TargetMethod m : targetMethods.value()) {
                interceptorId = this.addInterceptor0(m, interceptorClassName, constructorArgs, scope, executionPolicy);
            }
        }
        if ((targetMethod = interceptorType.getAnnotation(TargetMethod.class)) != null) {
            interceptorId = this.addInterceptor0(targetMethod, interceptorClassName, constructorArgs, scope, executionPolicy);
        }
        if ((targetConstructors = interceptorType.getAnnotation(TargetConstructors.class)) != null) {
            for (TargetConstructor c : targetConstructors.value()) {
                interceptorId = this.addInterceptor0(c, interceptorClassName, scope, executionPolicy, constructorArgs);
            }
        }
        if ((targetConstructor = interceptorType.getAnnotation(TargetConstructor.class)) != null) {
            interceptorId = this.addInterceptor0(targetConstructor, interceptorClassName, scope, executionPolicy, constructorArgs);
        }
        if ((targetFilter = interceptorType.getAnnotation(TargetFilter.class)) != null) {
            interceptorId = this.addInterceptor0(targetFilter, interceptorClassName, scope, executionPolicy, constructorArgs);
        }
        if (interceptorId == -1) {
            throw new PinpointException("No target is specified. At least one of @Targets, @TargetMethod, @TargetConstructor, @TargetFilter must present. interceptor: " + interceptorClassName);
        }
        return interceptorId;
    }

    private int addInterceptor0(TargetConstructor c, String interceptorClassName, InterceptorScope scope, ExecutionPolicy executionPolicy, Object ... constructorArgs) throws InstrumentException {
        InstrumentMethod constructor = this.getConstructor(c.value());
        if (constructor == null) {
            throw new NotFoundInstrumentException("Cannot find constructor with parameter types: " + Arrays.toString(c.value()));
        }
        return ((ASMMethod)constructor).addInterceptorInternal(interceptorClassName, constructorArgs, scope, executionPolicy);
    }

    private int addInterceptor0(TargetMethod m, String interceptorClassName, Object[] constructorArgs, InterceptorScope scope, ExecutionPolicy executionPolicy) throws InstrumentException {
        InstrumentMethod method = this.getDeclaredMethod(m.name(), m.paramTypes());
        if (method == null) {
            throw new NotFoundInstrumentException("Cannot find method " + m.name() + " with parameter types: " + Arrays.toString(m.paramTypes()));
        }
        return ((ASMMethod)method).addInterceptorInternal(interceptorClassName, constructorArgs, scope, executionPolicy);
    }

    private int addInterceptor0(TargetFilter annotation, String interceptorClassName, InterceptorScope scope, ExecutionPolicy executionPolicy, Object[] constructorArgs) throws InstrumentException {
        String filterTypeName = annotation.type();
        Assert.requireNonNull((Object)filterTypeName, (String)"type of @TargetFilter must not be null");
        ObjectBinderFactory objectBinderFactory = this.engineComponent.getObjectBinderFactory();
        InterceptorArgumentProvider interceptorArgumentProvider = objectBinderFactory.newInterceptorArgumentProvider(this);
        AutoBindingObjectFactory filterFactory = objectBinderFactory.newAutoBindingObjectFactory(this.pluginContext, this.classLoader, interceptorArgumentProvider);
        ObjectFactory objectFactory = ObjectFactory.byConstructor((String)filterTypeName, (Object[])annotation.constructorArguments());
        MethodFilter filter = (MethodFilter)filterFactory.createInstance(objectFactory, new ArgumentProvider[0]);
        boolean singleton = annotation.singleton();
        int interceptorId = -1;
        for (InstrumentMethod m : this.getDeclaredMethods(filter)) {
            if (singleton && interceptorId != -1) {
                m.addInterceptor(interceptorId);
                continue;
            }
            interceptorId = ((ASMMethod)m).addInterceptorInternal(interceptorClassName, constructorArgs, scope, executionPolicy);
        }
        if (interceptorId == -1) {
            this.logger.warn("No methods are intercepted. target:{}, interceptor:{}, methodFilter:{} ", new Object[]{this.classNode.getInternalName(), interceptorClassName, filterTypeName});
        }
        return interceptorId;
    }

    public int addInterceptor(MethodFilter filter, String interceptorClassName) throws InstrumentException {
        Assert.requireNonNull((Object)filter, (String)"filter must not be null");
        Assert.requireNonNull((Object)interceptorClassName, (String)"interceptorClassName must not be null");
        return this.addScopedInterceptor0(filter, interceptorClassName, null, null, null);
    }

    public int addInterceptor(MethodFilter filter, String interceptorClassName, Object[] constructorArgs) throws InstrumentException {
        Assert.requireNonNull((Object)filter, (String)"filter must not be null");
        Assert.requireNonNull((Object)interceptorClassName, (String)"interceptorClassName must not be null");
        Assert.requireNonNull((Object)constructorArgs, (String)"constructorArgs must not be null");
        return this.addScopedInterceptor0(filter, interceptorClassName, constructorArgs, null, null);
    }

    public int addScopedInterceptor(MethodFilter filter, String interceptorClassName, String scopeName, ExecutionPolicy executionPolicy) throws InstrumentException {
        Assert.requireNonNull((Object)filter, (String)"filter must not be null");
        Assert.requireNonNull((Object)interceptorClassName, (String)"interceptorClassName must not be null");
        Assert.requireNonNull((Object)scopeName, (String)"scopeName must not be null");
        Assert.requireNonNull((Object)executionPolicy, (String)"executionPolicy must not be null");
        InterceptorScope interceptorScope = this.pluginContext.getInterceptorScope(scopeName);
        return this.addScopedInterceptor0(filter, interceptorClassName, null, interceptorScope, executionPolicy);
    }

    public int addScopedInterceptor(MethodFilter filter, String interceptorClassName, InterceptorScope scope, ExecutionPolicy executionPolicy) throws InstrumentException {
        Assert.requireNonNull((Object)filter, (String)"filter must not be null");
        Assert.requireNonNull((Object)interceptorClassName, (String)"interceptorClassName must not be null");
        Assert.requireNonNull((Object)scope, (String)"scope must not be null");
        Assert.requireNonNull((Object)executionPolicy, (String)"executionPolicy must not be null");
        return this.addScopedInterceptor0(filter, interceptorClassName, null, scope, executionPolicy);
    }

    public int addScopedInterceptor(MethodFilter filter, String interceptorClassName, Object[] constructorArgs, String scopeName, ExecutionPolicy executionPolicy) throws InstrumentException {
        Assert.requireNonNull((Object)filter, (String)"filter must not be null");
        Assert.requireNonNull((Object)interceptorClassName, (String)"interceptorClassName must not be null");
        Assert.requireNonNull((Object)constructorArgs, (String)"constructorArgs must not be null");
        Assert.requireNonNull((Object)scopeName, (String)"scopeName must not be null");
        Assert.requireNonNull((Object)executionPolicy, (String)"executionPolicy must not be null");
        InterceptorScope interceptorScope = this.pluginContext.getInterceptorScope(scopeName);
        return this.addScopedInterceptor0(filter, interceptorClassName, null, interceptorScope, executionPolicy);
    }

    public int addScopedInterceptor(MethodFilter filter, String interceptorClassName, Object[] constructorArgs, InterceptorScope scope, ExecutionPolicy executionPolicy) throws InstrumentException {
        Assert.requireNonNull((Object)filter, (String)"filter must not be null");
        Assert.requireNonNull((Object)interceptorClassName, (String)"interceptorClassName must not be null");
        Assert.requireNonNull((Object)constructorArgs, (String)"constructorArgs must not be null");
        Assert.requireNonNull((Object)scope, (String)"scope must not be null");
        Assert.requireNonNull((Object)executionPolicy, (String)"executionPolicy must not be null");
        return this.addScopedInterceptor0(filter, interceptorClassName, constructorArgs, scope, executionPolicy);
    }

    private int addScopedInterceptor0(MethodFilter filter, String interceptorClassName, Object[] constructorArgs, InterceptorScope scope, ExecutionPolicy executionPolicy) throws InstrumentException {
        int interceptorId = -1;
        for (InstrumentMethod m : this.getDeclaredMethods(filter)) {
            if (interceptorId != -1) {
                m.addInterceptor(interceptorId);
                continue;
            }
            interceptorId = ((ASMMethod)m).addInterceptorInternal(interceptorClassName, constructorArgs, scope, executionPolicy);
        }
        if (interceptorId == -1) {
            this.logger.warn("No methods are intercepted. target:{}, interceptor:{}, methodFilter:{}", new Object[]{this.classNode.getInternalName(), interceptorClassName, filter.getClass().getName()});
        }
        return interceptorId;
    }

    public List<InstrumentClass> getNestedClasses(ClassFilter filter) {
        ArrayList<InstrumentClass> nestedClasses = new ArrayList<InstrumentClass>();
        for (ASMClassNodeAdapter innerClassNode : this.classNode.getInnerClasses()) {
            ASMNestedClass nestedClass = new ASMNestedClass(this.engineComponent, this.pluginContext, this.classLoader, innerClassNode);
            if (!filter.accept((InstrumentClass)nestedClass)) continue;
            nestedClasses.add(nestedClass);
        }
        return nestedClasses;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public byte[] toBytecode() {
        return this.classNode.toByteArray();
    }
}

