/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.activemq.client.interceptor;

import com.navercorp.pinpoint.bootstrap.config.Filter;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.common.trace.AnnotationKey;
import com.navercorp.pinpoint.plugin.activemq.client.ActiveMQClientConstants;
import com.navercorp.pinpoint.plugin.activemq.client.ActiveMQClientHeader;
import com.navercorp.pinpoint.plugin.activemq.client.field.getter.ActiveMQSessionGetter;
import com.navercorp.pinpoint.plugin.activemq.client.field.getter.SocketGetter;
import com.navercorp.pinpoint.plugin.activemq.client.field.getter.TransportGetter;
import javax.jms.Message;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQMessageProducer;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFilter;
import org.apache.activemq.transport.failover.FailoverTransport;

public class ActiveMQMessageProducerSendInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final TraceContext traceContext;
    private final MethodDescriptor descriptor;
    private final Filter<String> excludeDestinationFilter;

    public ActiveMQMessageProducerSendInterceptor(TraceContext traceContext, MethodDescriptor descriptor, Filter<String> excludeDestinationFilter) {
        this.traceContext = traceContext;
        this.descriptor = descriptor;
        this.excludeDestinationFilter = excludeDestinationFilter;
    }

    public void before(Object target, Object[] args) {
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, args);
        }
        if (!this.validate(target, args)) {
            return;
        }
        ActiveMQDestination activeMQDestination = (ActiveMQDestination)args[0];
        if (this.filterDestination(activeMQDestination)) {
            return;
        }
        Trace trace = this.traceContext.currentRawTraceObject();
        if (trace == null) {
            return;
        }
        Message message = (Message)args[1];
        try {
            if (trace.canSampled()) {
                SpanEventRecorder recorder = trace.traceBlockBegin();
                recorder.recordServiceType(ActiveMQClientConstants.ACTIVEMQ_CLIENT);
                TraceId nextId = trace.getTraceId().getNextTraceId();
                recorder.recordNextSpanId(nextId.getSpanId());
                ActiveMQClientHeader.setTraceId(message, nextId.getTransactionId());
                ActiveMQClientHeader.setSpanId(message, nextId.getSpanId());
                ActiveMQClientHeader.setParentSpanId(message, nextId.getParentSpanId());
                ActiveMQClientHeader.setFlags(message, nextId.getFlags());
                ActiveMQClientHeader.setParentApplicationName(message, this.traceContext.getApplicationName());
                ActiveMQClientHeader.setParentApplicationType(message, this.traceContext.getServerTypeCode());
            } else {
                ActiveMQClientHeader.setSampled(message, false);
            }
        }
        catch (Throwable t) {
            this.logger.warn("BEFORE. Cause:{}", (Object)t.getMessage(), (Object)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args);
        }
        if (!this.validate(target, args)) {
            return;
        }
        Trace trace = this.traceContext.currentTraceObject();
        if (trace == null) {
            return;
        }
        try {
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            recorder.recordApi(this.descriptor);
            if (throwable == null) {
                ActiveMQDestination destination = (ActiveMQDestination)args[0];
                recorder.recordAttribute(AnnotationKey.MESSAGE_QUEUE_URI, destination.getQualifiedName());
                recorder.recordDestinationId(destination.getPhysicalName());
                ActiveMQSession session = ((ActiveMQSessionGetter)target)._$PINPOINT$_getActiveMQSession();
                ActiveMQConnection connection = session.getConnection();
                Transport transport = this.getRootTransport(((TransportGetter)connection)._$PINPOINT$_getTransport());
                String remoteAddress = transport.getRemoteAddress();
                recorder.recordEndPoint(remoteAddress);
                recorder.recordAttribute(ActiveMQClientConstants.ACTIVEMQ_BROKER_URL, remoteAddress);
            } else {
                recorder.recordException(throwable);
            }
        }
        catch (Throwable t) {
            this.logger.warn("AFTER error. Cause:{}", (Object)t.getMessage(), (Object)t);
        }
        finally {
            trace.traceBlockEnd();
        }
    }

    private boolean filterDestination(ActiveMQDestination destination) {
        String destinationName = destination.getPhysicalName();
        return this.excludeDestinationFilter.filter((Object)destinationName);
    }

    private boolean validate(Object target, Object[] args) {
        if (!(target instanceof ActiveMQMessageProducer)) {
            return false;
        }
        if (!(target instanceof ActiveMQSessionGetter)) {
            if (this.isDebug) {
                this.logger.debug("Invalid target object. Need field accessor({}).", (Object)ActiveMQSessionGetter.class.getName());
            }
            return false;
        }
        if (!this.validateTransport(((ActiveMQSessionGetter)target)._$PINPOINT$_getActiveMQSession())) {
            return false;
        }
        if (args == null || args.length < 2) {
            return false;
        }
        if (!(args[0] instanceof ActiveMQDestination)) {
            return false;
        }
        return args[1] instanceof Message;
    }

    private boolean validateTransport(ActiveMQSession session) {
        if (session == null) {
            return false;
        }
        ActiveMQConnection connection = session.getConnection();
        if (!(connection instanceof TransportGetter)) {
            if (this.isDebug) {
                this.logger.debug("Invalid connection object. Need field accessor({}).", (Object)TransportGetter.class.getName());
            }
            return false;
        }
        Transport transport = this.getRootTransport(((TransportGetter)connection)._$PINPOINT$_getTransport());
        if (!(transport instanceof SocketGetter)) {
            if (this.isDebug) {
                this.logger.debug("Transport not traceable({}).", (Object)transport.getClass().getName());
            }
            return false;
        }
        return true;
    }

    private Transport getRootTransport(Transport transport) {
        Transport possiblyWrappedTransport = transport;
        while (possiblyWrappedTransport instanceof TransportFilter) {
            if (!((possiblyWrappedTransport = ((TransportFilter)possiblyWrappedTransport).getNext()) instanceof FailoverTransport)) continue;
            possiblyWrappedTransport = ((FailoverTransport)possiblyWrappedTransport).getConnectedTransport();
        }
        return possiblyWrappedTransport;
    }
}

