/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.java9.module;

import com.navercorp.pinpoint.bootstrap.java9.module.Java9Module;
import com.navercorp.pinpoint.bootstrap.java9.module.ModuleBuilder;
import com.navercorp.pinpoint.bootstrap.java9.module.ModuleException;
import com.navercorp.pinpoint.bootstrap.java9.module.ModuleLogger;
import com.navercorp.pinpoint.bootstrap.module.JavaModule;
import java.lang.instrument.Instrumentation;
import java.net.URL;
import jdk.internal.module.Modules;

public class ModuleSupport {
    private final Instrumentation instrumentation;
    private final ModuleLogger logger = ModuleLogger.getLogger(this.getClass().getName());
    private final JavaModule javaBaseModule;
    private final JavaModule bootstrapModule;

    ModuleSupport(Instrumentation instrumentation) {
        if (instrumentation == null) {
            throw new NullPointerException("instrumentation must not be null");
        }
        this.instrumentation = instrumentation;
        this.javaBaseModule = this.wrapJavaModule(Object.class);
        this.bootstrapModule = this.wrapJavaModule(this.getClass());
    }

    public void setup() {
        JavaModule bootstrapModule = this.getBootstrapModule();
        this.logger.info("pinpoint Module id:" + bootstrapModule);
        this.logger.info("pinpoint Module.isNamed:" + bootstrapModule.isNamed());
        this.logger.info("pinpoint Module.name:" + bootstrapModule.getName());
        JavaModule baseModule = this.getJavaBaseModule();
        baseModule.addExports("jdk.internal.loader", bootstrapModule);
        baseModule.addExports("jdk.internal.misc", bootstrapModule);
        baseModule.addExports("jdk.internal.module", bootstrapModule);
    }

    public void defineAgentModule(ClassLoader classLoader, URL[] jarFileList) {
        JavaModule agentModule = this.newAgentModule(classLoader, jarFileList);
        this.prepareAgentModule(agentModule);
        this.addPermissionToLog4jModule(agentModule);
        this.addPermissionToGuiceModule(agentModule);
    }

    private JavaModule newAgentModule(ClassLoader classLoader, URL[] jarFileList) {
        ModuleBuilder moduleBuilder = new ModuleBuilder();
        Module agentModule = moduleBuilder.defineModule("pinpoint.agent", classLoader, jarFileList);
        return this.wrapJavaModule(agentModule);
    }

    private void addPermissionToLog4jModule(JavaModule agentModule) {
        JavaModule xmlModule = this.loadModule("java.xml");
        agentModule.addReads(xmlModule);
        JavaModule desktopModule = this.loadModule("java.desktop");
        agentModule.addReads(desktopModule);
    }

    private void addPermissionToGuiceModule(JavaModule agentModule) {
        JavaModule loggingModule = this.loadModule("java.logging");
        agentModule.addReads(loggingModule);
        JavaModule javaBaseModule = this.getJavaBaseModule();
        javaBaseModule.addOpens("java.lang", agentModule);
    }

    private void prepareAgentModule(JavaModule agentModule) {
        JavaModule bootstrapModule = this.getBootstrapModule();
        agentModule.addExports("com.navercorp.pinpoint.profiler", bootstrapModule);
        agentModule.addReads(bootstrapModule);
        JavaModule baseModule = this.getJavaBaseModule();
        baseModule.addOpens("java.net", agentModule);
        baseModule.addExports("jdk.internal.misc", agentModule);
        JavaModule instrumentModule = this.loadModule("java.instrument");
        agentModule.addReads(instrumentModule);
        JavaModule managementModule = this.loadModule("java.management");
        agentModule.addReads(managementModule);
        JavaModule jdkManagement = this.loadModule("jdk.management");
        agentModule.addReads(jdkManagement);
        ClassLoader bootstrapClassLoader = Object.class.getClassLoader();
        Class<?> traceMataDataClass = this.forName("com.navercorp.pinpoint.common.trace.TraceMetadataProvider", bootstrapClassLoader);
        agentModule.addUses(traceMataDataClass);
        Class<?> pluginClazz = this.forName("com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin", bootstrapClassLoader);
        agentModule.addUses(pluginClazz);
    }

    private Class<?> forName(String className, ClassLoader classLoader) {
        try {
            return Class.forName(className, false, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new ModuleException(className + " not found Caused by:" + e.getMessage(), e);
        }
    }

    private JavaModule loadModule(String moduleName) {
        this.logger.info("loadModule:" + moduleName);
        Module module = Modules.loadModule(moduleName);
        return this.wrapJavaModule(module);
    }

    private JavaModule wrapJavaModule(Class clazz) {
        return new Java9Module(this.instrumentation, clazz.getModule());
    }

    private JavaModule wrapJavaModule(Module module) {
        return new Java9Module(this.instrumentation, module);
    }

    private JavaModule getJavaBaseModule() {
        return this.javaBaseModule;
    }

    private JavaModule getBootstrapModule() {
        return this.bootstrapModule;
    }
}

