/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.jdbc;

import com.navercorp.pinpoint.bootstrap.context.DatabaseInfo;
import com.navercorp.pinpoint.common.trace.ServiceType;
import java.util.List;

public class DefaultDatabaseInfo
implements DatabaseInfo {
    private final ServiceType type;
    private final ServiceType executeQueryType;
    private final String databaseId;
    private final String realUrl;
    private final String normalizedUrl;
    private final List<String> host;
    private final String multipleHost;
    private final boolean parsingComplete;

    public DefaultDatabaseInfo(ServiceType type, ServiceType executeQueryType, String realUrl, String normalizedUrl, List<String> host, String databaseId) {
        this(type, executeQueryType, realUrl, normalizedUrl, host, databaseId, true);
    }

    public DefaultDatabaseInfo(ServiceType type, ServiceType executeQueryType, String realUrl, String normalizedUrl, List<String> host, String databaseId, boolean parsingComplete) {
        if (type == null) {
            throw new NullPointerException("type must not be null");
        }
        if (executeQueryType == null) {
            throw new NullPointerException("executeQueryType must not be null");
        }
        this.type = type;
        this.executeQueryType = executeQueryType;
        this.realUrl = realUrl;
        this.normalizedUrl = normalizedUrl;
        this.host = host;
        this.multipleHost = this.merge(host);
        this.databaseId = databaseId;
        this.parsingComplete = parsingComplete;
    }

    private String merge(List<String> host) {
        if (host.isEmpty()) {
            return "";
        }
        String single = host.get(0);
        StringBuilder sb = new StringBuilder();
        sb.append(single);
        for (int i = 1; i < host.size(); ++i) {
            sb.append(',');
            sb.append(host.get(i));
        }
        return sb.toString();
    }

    @Override
    public List<String> getHost() {
        return this.host;
    }

    @Override
    public String getMultipleHost() {
        return this.multipleHost;
    }

    @Override
    public String getDatabaseId() {
        return this.databaseId;
    }

    @Override
    public String getRealUrl() {
        return this.realUrl;
    }

    @Override
    public String getUrl() {
        return this.normalizedUrl;
    }

    @Override
    public ServiceType getType() {
        return this.type;
    }

    @Override
    public ServiceType getExecuteQueryType() {
        return this.executeQueryType;
    }

    @Override
    public boolean isParsingComplete() {
        return this.parsingComplete;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultDatabaseInfo{");
        sb.append("type=").append(this.type);
        sb.append(", executeQueryType=").append(this.executeQueryType);
        sb.append(", databaseId='").append(this.databaseId).append('\'');
        sb.append(", realUrl='").append(this.realUrl).append('\'');
        sb.append(", normalizedUrl='").append(this.normalizedUrl).append('\'');
        sb.append(", host=").append(this.host);
        sb.append(", multipleHost='").append(this.multipleHost).append('\'');
        sb.append(", parsingComplete=").append(this.parsingComplete);
        sb.append('}');
        return sb.toString();
    }
}

