/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.resttemplate.interceptor;

import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AsyncContextSpanEventSimpleAroundInterceptor;
import com.navercorp.pinpoint.common.trace.AnnotationKey;
import com.navercorp.pinpoint.plugin.resttemplate.RestTemplateConstants;
import com.navercorp.pinpoint.plugin.resttemplate.field.accessor.TraceFutureFlagAccessor;
import java.io.IOException;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.AbstractClientHttpResponse;

public class ListenableFutureInterceptor
extends AsyncContextSpanEventSimpleAroundInterceptor {
    public ListenableFutureInterceptor(MethodDescriptor methodDescriptor, TraceContext traceContext) {
        super(traceContext, methodDescriptor);
    }

    public void before(Object target, Object[] args) {
        if (!(target instanceof TraceFutureFlagAccessor)) {
            this.logger.debug("skip. caused: target can't assign to TraceFutureFlagAccessor");
            return;
        }
        boolean traceFlag = ((TraceFutureFlagAccessor)target)._$PINPOINT$_getTraceFlag();
        if (!traceFlag) {
            this.logger.debug("skip. caused: traceFlag is false");
            return;
        }
        super.before(target, args);
    }

    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        if (!(target instanceof TraceFutureFlagAccessor)) {
            this.logger.debug("skip. caused: target can't assign to TraceFutureFlagAccessor");
            return;
        }
        boolean traceFlag = ((TraceFutureFlagAccessor)target)._$PINPOINT$_getTraceFlag();
        if (!traceFlag) {
            this.logger.debug("skip. caused: traceFlag is false");
            return;
        }
        super.after(target, args, result, throwable);
    }

    protected void doInBeforeTrace(SpanEventRecorder recorder, AsyncContext asyncContext, Object target, Object[] args) {
    }

    protected void doInAfterTrace(SpanEventRecorder recorder, Object target, Object[] args, Object result, Throwable throwable) {
        recorder.recordServiceType(RestTemplateConstants.SERVICE_TYPE);
        recorder.recordException(throwable);
        recorder.recordApi(this.methodDescriptor);
        if (args.length == 1 && args[0] instanceof AbstractClientHttpResponse) {
            AbstractClientHttpResponse response = (AbstractClientHttpResponse)args[0];
            try {
                HttpStatus statusCode = response.getStatusCode();
                if (statusCode != null) {
                    recorder.recordAttribute(AnnotationKey.HTTP_STATUS_CODE, statusCode.value());
                }
            }
            catch (IOException ioException) {
                this.logger.warn("Failed to after process. {}", (Object)ioException.getMessage(), (Object)ioException);
            }
        }
    }
}

