/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.jdbc.jtds;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilter;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.ExecutionPolicy;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.JdbcUrlParserV2;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.PreparedStatementBindingMethodFilter;
import com.navercorp.pinpoint.bootstrap.plugin.util.InstrumentUtils;
import com.navercorp.pinpoint.common.util.VarArgs;
import com.navercorp.pinpoint.plugin.jdbc.jtds.JtdsConfig;
import com.navercorp.pinpoint.plugin.jdbc.jtds.JtdsConstants;
import com.navercorp.pinpoint.plugin.jdbc.jtds.JtdsJdbcUrlParser;
import java.security.ProtectionDomain;
import java.util.List;

public class JtdsPlugin
implements ProfilerPlugin,
TransformTemplateAware {
    private static final String JTDS_SCOPE = "JTDS";
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final JdbcUrlParserV2 jdbcUrlParser = new JtdsJdbcUrlParser();
    private TransformTemplate transformTemplate;

    public void setup(ProfilerPluginSetupContext context) {
        JtdsConfig config = new JtdsConfig(context.getConfig());
        if (!config.isPluginEnable()) {
            this.logger.info("Jtds plugin is not executed because plugin enable value is false.");
            return;
        }
        context.addJdbcUrlParser(this.jdbcUrlParser);
        this.addConnectionTransformer(config);
        this.addDriverTransformer();
        this.addPreparedStatementTransformer(config);
        this.addCallableStatementTransformer();
        this.addStatementTransformer();
    }

    private void addConnectionTransformer(final JtdsConfig config) {
        TransformCallback transformer = new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.DatabaseInfoAccessor");
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"close", (String[])new String[0]).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.ConnectionCloseInterceptor", JtdsPlugin.JTDS_SCOPE);
                String statementCreate = "com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementCreateInterceptor";
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"createStatement", (String[])new String[0]).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementCreateInterceptor", JtdsPlugin.JTDS_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"createStatement", (String[])new String[]{"int", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementCreateInterceptor", JtdsPlugin.JTDS_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"createStatement", (String[])new String[]{"int", "int", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementCreateInterceptor", JtdsPlugin.JTDS_SCOPE);
                String preparedStatementCreate = "com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor";
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareStatement", (String[])new String[]{"java.lang.String"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor", JtdsPlugin.JTDS_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareStatement", (String[])new String[]{"java.lang.String", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor", JtdsPlugin.JTDS_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareStatement", (String[])new String[]{"java.lang.String", "int[]"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor", JtdsPlugin.JTDS_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareStatement", (String[])new String[]{"java.lang.String", "java.lang.String[]"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor", JtdsPlugin.JTDS_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareStatement", (String[])new String[]{"java.lang.String", "int", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor", JtdsPlugin.JTDS_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareStatement", (String[])new String[]{"java.lang.String", "int", "int", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor", JtdsPlugin.JTDS_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareCall", (String[])new String[]{"java.lang.String"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor", JtdsPlugin.JTDS_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareCall", (String[])new String[]{"java.lang.String", "int", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor", JtdsPlugin.JTDS_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareCall", (String[])new String[]{"java.lang.String", "int", "int", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor", JtdsPlugin.JTDS_SCOPE);
                if (config.isProfileSetAutoCommit()) {
                    InstrumentUtils.findMethod((InstrumentClass)target, (String)"setAutoCommit", (String[])new String[]{"boolean"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.TransactionSetAutoCommitInterceptor", JtdsPlugin.JTDS_SCOPE);
                }
                if (config.isProfileCommit()) {
                    InstrumentUtils.findMethod((InstrumentClass)target, (String)"commit", (String[])new String[0]).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.TransactionCommitInterceptor", JtdsPlugin.JTDS_SCOPE);
                }
                if (config.isProfileRollback()) {
                    InstrumentUtils.findMethod((InstrumentClass)target, (String)"rollback", (String[])new String[0]).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.TransactionRollbackInterceptor", JtdsPlugin.JTDS_SCOPE);
                }
                return target.toBytecode();
            }
        };
        this.transformTemplate.transform("net.sourceforge.jtds.jdbc.ConnectionJDBC2", transformer);
        this.transformTemplate.transform("net.sourceforge.jtds.jdbc.JtdsConnection", transformer);
    }

    private void addDriverTransformer() {
        this.transformTemplate.transform("net.sourceforge.jtds.jdbc.Driver", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"connect", (String[])new String[]{"java.lang.String", "java.util.Properties"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.DriverConnectInterceptorV2", VarArgs.va((Object[])new Object[]{JtdsConstants.MSSQL}), JtdsPlugin.JTDS_SCOPE, ExecutionPolicy.ALWAYS);
                return target.toBytecode();
            }
        });
    }

    private void addPreparedStatementTransformer(final JtdsConfig config) {
        this.transformTemplate.transform("net.sourceforge.jtds.jdbc.JtdsPreparedStatement", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.DatabaseInfoAccessor");
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.ParsingResultAccessor");
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.BindValueAccessor");
                int maxBindValueSize = config.getMaxSqlBindValueSize();
                String preparedStatementInterceptor = "com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementExecuteQueryInterceptor";
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"execute", (String[])new String[0]).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementExecuteQueryInterceptor", VarArgs.va((Object[])new Object[]{maxBindValueSize}), JtdsPlugin.JTDS_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"executeQuery", (String[])new String[0]).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementExecuteQueryInterceptor", VarArgs.va((Object[])new Object[]{maxBindValueSize}), JtdsPlugin.JTDS_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"executeUpdate", (String[])new String[0]).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementExecuteQueryInterceptor", VarArgs.va((Object[])new Object[]{maxBindValueSize}), JtdsPlugin.JTDS_SCOPE);
                if (config.isTraceSqlBindValue()) {
                    PreparedStatementBindingMethodFilter filter = new PreparedStatementBindingMethodFilter();
                    List declaredMethods = target.getDeclaredMethods((MethodFilter)filter);
                    for (InstrumentMethod method : declaredMethods) {
                        method.addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementBindVariableInterceptor", JtdsPlugin.JTDS_SCOPE);
                    }
                }
                return target.toBytecode();
            }
        });
    }

    private void addCallableStatementTransformer() {
        this.transformTemplate.transform("net.sourceforge.jtds.jdbc.JtdsCallableStatement", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.DatabaseInfoAccessor");
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.ParsingResultAccessor");
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.BindValueAccessor");
                String callableStatementInterceptor = "com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.CallableStatementRegisterOutParameterInterceptor";
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"registerOutParameter", (String[])new String[]{"int", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.CallableStatementRegisterOutParameterInterceptor", JtdsPlugin.JTDS_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"registerOutParameter", (String[])new String[]{"int", "int", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.CallableStatementRegisterOutParameterInterceptor", JtdsPlugin.JTDS_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"registerOutParameter", (String[])new String[]{"int", "int", "java.lang.String"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.CallableStatementRegisterOutParameterInterceptor", JtdsPlugin.JTDS_SCOPE);
                return target.toBytecode();
            }
        });
    }

    private void addStatementTransformer() {
        this.transformTemplate.transform("net.sourceforge.jtds.jdbc.JtdsStatement", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.DatabaseInfoAccessor");
                String executeQueryInterceptor = "com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementExecuteQueryInterceptor";
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"executeQuery", (String[])new String[]{"java.lang.String"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementExecuteQueryInterceptor", JtdsPlugin.JTDS_SCOPE);
                String executeUpdateInterceptor = "com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementExecuteUpdateInterceptor";
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"executeUpdate", (String[])new String[]{"java.lang.String"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementExecuteUpdateInterceptor", JtdsPlugin.JTDS_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"executeUpdate", (String[])new String[]{"java.lang.String", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementExecuteUpdateInterceptor", JtdsPlugin.JTDS_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"execute", (String[])new String[]{"java.lang.String"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementExecuteUpdateInterceptor", JtdsPlugin.JTDS_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"execute", (String[])new String[]{"java.lang.String", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementExecuteUpdateInterceptor", JtdsPlugin.JTDS_SCOPE);
                return target.toBytecode();
            }
        });
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }
}

