/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.undertow;

import com.navercorp.pinpoint.bootstrap.context.Header;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import io.undertow.util.HttpString;
import java.util.ArrayList;

public class UndertowHttpHeaderFilter {
    private final boolean enable;

    public UndertowHttpHeaderFilter(boolean enable) {
        this.enable = enable;
    }

    public void filter(HttpServerExchange request) {
        if (!this.enable || request == null || request.getRequestHeaders() == null) {
            return;
        }
        HeaderMap headerMap = request.getRequestHeaders();
        ArrayList<String> pinpointHeaderNameList = new ArrayList<String>();
        for (HttpString httpString : headerMap.getHeaderNames()) {
            String headerName = httpString.toString();
            if (!Header.startWithPinpointHeader((String)headerName)) continue;
            pinpointHeaderNameList.add(headerName);
        }
        for (String string : pinpointHeaderNameList) {
            headerMap.remove(string);
        }
    }
}

