/*
 * Decompiled with CFR 0.152.
 */
package com.tapm.starter;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.jar.JarFile;

public class AgentJarHelper {
    private static final String AGENT_FILE_NAME = "tapm-agent-core.jar";
    private static final String ATTRIBUTE_AGENT_VERSION = "Agent-Version";

    public static File getAgentJarDirectory() throws IOException {
        File file;
        URL agentJarUrl = AgentJarHelper.getStarterJarUrl();
        if (agentJarUrl != null && (file = new File(AgentJarHelper.getStarterJarFileName(agentJarUrl))).exists()) {
            return file.getParentFile();
        }
        return null;
    }

    private static URL getStarterJarUrl() {
        return AgentJarHelper.class.getProtectionDomain().getCodeSource().getLocation();
    }

    private static JarFile getAgentJarFile() throws IOException {
        File agentDir = AgentJarHelper.getAgentJarDirectory();
        File agentFile = new File(agentDir, AGENT_FILE_NAME);
        return new JarFile(agentFile);
    }

    private static String getStarterJarFileName(URL agentJarUrl) throws UnsupportedEncodingException {
        if (agentJarUrl == null) {
            return null;
        }
        return URLDecoder.decode(agentJarUrl.getFile().replace("+", "%2B"), "UTF-8");
    }

    public static String getAgentVersion() throws IOException {
        return AgentJarHelper.getAgentJarAttribute(ATTRIBUTE_AGENT_VERSION);
    }

    public static String getAgentJarAttribute(String name) throws IOException {
        JarFile jarFile = AgentJarHelper.getAgentJarFile();
        if (jarFile == null) {
            return null;
        }
        return jarFile.getManifest().getMainAttributes().getValue(name);
    }
}

