/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.jdbc.oracle.parser;

import com.navercorp.pinpoint.plugin.jdbc.oracle.parser.Address;
import com.navercorp.pinpoint.plugin.jdbc.oracle.parser.KeyValue;
import com.navercorp.pinpoint.plugin.jdbc.oracle.parser.OracleConnectionStringException;
import java.util.ArrayList;
import java.util.List;

public class Description {
    private String serviceName;
    private String sid;
    private ArrayList<Address> addressList = new ArrayList();

    public Description() {
    }

    public Description(KeyValue keyValue) {
        if (keyValue == null) {
            throw new NullPointerException("keyValue");
        }
        this.mapping(keyValue);
    }

    private void mapping(KeyValue keyValue) {
        if (!this.compare("description", keyValue)) {
            throw new OracleConnectionStringException("description node not found");
        }
        for (KeyValue kv : keyValue.getKeyValueList()) {
            if (this.compare("address", kv)) {
                String host = null;
                String port = null;
                String protocol = null;
                for (KeyValue address : kv.getKeyValueList()) {
                    if (this.compare("host", address)) {
                        host = address.getValue();
                        continue;
                    }
                    if (this.compare("port", address)) {
                        port = address.getValue();
                        continue;
                    }
                    if (!this.compare("protocol", address)) continue;
                    protocol = address.getValue();
                }
                this.addAddress(protocol, host, port);
                continue;
            }
            if (!this.compare("connect_data", kv)) continue;
            for (KeyValue connectData : kv.getKeyValueList()) {
                if (this.compare("service_name", connectData)) {
                    this.serviceName = connectData.getValue();
                    continue;
                }
                if (!this.compare("sid", connectData)) continue;
                this.sid = connectData.getValue();
            }
        }
    }

    private boolean compare(String value, KeyValue kv) {
        if (kv == null) {
            return false;
        }
        return value.equals(kv.getKey());
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getSid() {
        return this.sid;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public List<String> getJdbcHost() {
        ArrayList<String> hostList = new ArrayList<String>();
        for (Address address : this.addressList) {
            String host = address.getHost();
            String port = address.getPort();
            if (port == null) {
                port = "1521";
            }
            hostList.add(host + ":" + port);
        }
        return hostList;
    }

    public String getDatabaseId() {
        String serviceName = this.getServiceName();
        if (serviceName != null) {
            return serviceName;
        }
        String sid = this.getSid();
        if (sid != null) {
            return sid;
        }
        return "oracleDatabaseId not found";
    }

    public void addAddress(String protocol, String host, String port) {
        this.addressList.add(new Address(protocol, host, port));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Description that = (Description)o;
        if (this.addressList != null ? !this.addressList.equals(that.addressList) : that.addressList != null) {
            return false;
        }
        if (this.serviceName != null ? !this.serviceName.equals(that.serviceName) : that.serviceName != null) {
            return false;
        }
        return !(this.sid != null ? !this.sid.equals(that.sid) : that.sid != null);
    }

    public int hashCode() {
        int result = this.serviceName != null ? this.serviceName.hashCode() : 0;
        result = 31 * result + (this.sid != null ? this.sid.hashCode() : 0);
        result = 31 * result + (this.addressList != null ? this.addressList.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Description");
        sb.append("{serviceName='").append(this.serviceName).append('\'');
        sb.append(", sid='").append(this.sid).append('\'');
        sb.append(", addressList=").append(this.addressList);
        sb.append('}');
        return sb.toString();
    }
}

