/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor;

import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.StaticAroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.BindValueAccessor;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.bindvalue.BindValueConverter;
import com.navercorp.pinpoint.bootstrap.util.NumberUtils;
import java.util.HashMap;
import java.util.Map;

public class PreparedStatementBindVariableInterceptor
implements StaticAroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final TraceContext traceContext;

    public PreparedStatementBindVariableInterceptor(TraceContext traceContext) {
        this.traceContext = traceContext;
    }

    @Override
    public void before(Object target, String className, String methodName, String parameterDescription, Object[] args) {
    }

    @Override
    public void after(Object target, String className, String methodName, String parameterDescription, Object[] args, Object result, Throwable throwable) {
        Trace trace;
        if (this.isDebug) {
            this.logger.afterInterceptor(target, className, methodName, parameterDescription, args, result, throwable);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        if (!(target instanceof BindValueAccessor)) {
            return;
        }
        Integer index = NumberUtils.toInteger(args[0]);
        if (index == null) {
            return;
        }
        Map<Integer, String> bindList = ((BindValueAccessor)target)._$PINPOINT$_getBindValue();
        if (bindList == null) {
            bindList = new HashMap<Integer, String>();
            ((BindValueAccessor)target)._$PINPOINT$_setBindValue(bindList);
        }
        String value = BindValueConverter.convert(methodName, args);
        bindList.put(index, value);
    }
}

