/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.httpclient4;

import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.EntityExtractor;
import com.navercorp.pinpoint.bootstrap.util.FixedByteArrayOutputStream;
import com.navercorp.pinpoint.common.Charsets;
import java.io.OutputStream;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;

public class HttpClient4EntityExtractor
implements EntityExtractor<HttpRequest> {
    public static final EntityExtractor<HttpRequest> INSTANCE = new HttpClient4EntityExtractor();
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());

    public String getEntity(HttpRequest httpRequest) {
        if (httpRequest instanceof HttpEntityEnclosingRequest) {
            HttpEntityEnclosingRequest entityRequest = (HttpEntityEnclosingRequest)httpRequest;
            try {
                HttpEntity entity = entityRequest.getEntity();
                if (entity != null && entity.isRepeatable() && entity.getContentLength() > 0L) {
                    return HttpClient4EntityExtractor.entityUtilsToString(entity, Charsets.UTF_8_NAME, 1024);
                }
            }
            catch (Exception e) {
                this.logger.debug("Failed to get entity. httpRequest={}", (Object)httpRequest, (Object)e);
            }
        }
        return null;
    }

    private static String entityUtilsToString(HttpEntity entity, String defaultCharset, int maxLength) throws Exception {
        if (entity == null) {
            throw new IllegalArgumentException("HTTP entity must not be null");
        }
        if (entity.getContentLength() > Integer.MAX_VALUE) {
            return "HTTP entity is too large to be buffered in memory length:" + entity.getContentLength();
        }
        if (entity.getContentType().getValue().startsWith("multipart/form-data")) {
            return "content type is multipart/form-data. content length:" + entity.getContentLength();
        }
        String charset = HttpClient4EntityExtractor.getContentCharSet(entity);
        if (charset == null) {
            charset = defaultCharset;
        }
        if (charset == null) {
            charset = "ISO-8859-1";
        }
        FixedByteArrayOutputStream outStream = new FixedByteArrayOutputStream(maxLength);
        entity.writeTo((OutputStream)outStream);
        String entityValue = outStream.toString(charset);
        if (entity.getContentLength() > (long)maxLength) {
            StringBuilder sb = new StringBuilder();
            sb.append(entityValue);
            sb.append("HTTP entity large length: ");
            sb.append(entity.getContentLength());
            sb.append(" )");
            return sb.toString();
        }
        return entityValue;
    }

    private static String getContentCharSet(HttpEntity entity) throws ParseException {
        NameValuePair param;
        HeaderElement[] values;
        if (entity == null) {
            throw new IllegalArgumentException("HTTP entity must not be null");
        }
        String charset = null;
        if (entity.getContentType() != null && (values = entity.getContentType().getElements()).length > 0 && (param = values[0].getParameterByName("charset")) != null) {
            charset = param.getValue();
        }
        return charset;
    }
}

