/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.tomcat.common.servlet.util;

import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.plugin.tomcat.common.servlet.util.ArgumentValidator;

public class ServletArgumentValidator
implements ArgumentValidator {
    private final PLogger logger;
    private final int requestIndex;
    private final Class<?> requestClass;
    private final int responseIndex;
    private final Class<?> responseClass;
    private final int minArgsSize;

    public ServletArgumentValidator(PLogger logger, int requestIndex, Class<?> requestClass, int responseIndex, Class<?> responseClass) {
        this(logger, requestIndex, requestClass, responseIndex, responseClass, ServletArgumentValidator.defaultArgumentMin(requestIndex, responseIndex));
    }

    public ServletArgumentValidator(PLogger logger, int requestIndex, Class<?> requestClass, int responseIndex, Class<?> responseClass, int minArgsSize) {
        this.logger = (PLogger)Assert.requireNonNull((Object)logger, (String)"logger must not be null");
        Assert.isTrue((requestIndex >= 0 ? 1 : 0) != 0, (String)"requestIndex must be positive");
        this.requestIndex = requestIndex;
        this.requestClass = (Class)Assert.requireNonNull(requestClass, (String)"requestClass must not be null");
        Assert.isTrue((responseIndex >= 0 ? 1 : 0) != 0, (String)"responseIndex must be positive");
        this.responseIndex = responseIndex;
        this.responseClass = (Class)Assert.requireNonNull(responseClass, (String)"responseClass must not be null");
        Assert.isTrue((requestIndex != responseIndex ? 1 : 0) != 0, (String)"requestIndex==responseIndex");
        this.minArgsSize = minArgsSize;
    }

    private static int defaultArgumentMin(int requestIndex, int responseIndex) {
        return Math.max(requestIndex, responseIndex) + 1;
    }

    @Override
    public boolean validate(Object[] args) {
        if (args == null) {
            return false;
        }
        if (args.length < this.minArgsSize) {
            return false;
        }
        Object request = args[this.requestIndex];
        if (!this.requestClass.isInstance(request)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Invalid args[{}] object, Not implemented of {}. args[{}]={}", new Object[]{this.requestIndex, this.requestClass, this.requestIndex, request});
            }
            return false;
        }
        Object response = args[this.responseIndex];
        if (!this.responseClass.isInstance(response)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Invalid args[{}] object, Not implemented of {}. args[{}]={}.", new Object[]{this.responseIndex, this.responseClass, this.responseIndex, response});
            }
            return false;
        }
        return true;
    }
}

