/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.client;

import com.navercorp.pinpoint.common.annotations.VisibleForTesting;
import com.navercorp.pinpoint.common.plugin.util.HostAndPort;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.rpc.client.SocketAddressProvider;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnsSocketAddressProvider
implements SocketAddressProvider {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String host;
    private final int port;
    private InetSocketAddress oldAddress;

    public DnsSocketAddressProvider(String host, int port) {
        this.host = (String)Assert.requireNonNull((Object)host, (String)"host must not be null");
        this.port = DnsSocketAddressProvider.checkPort(port);
    }

    private static int checkPort(int port) {
        if (!HostAndPort.isValidPort((int)port)) {
            throw new IllegalArgumentException("port out of range:" + port);
        }
        return port;
    }

    @Override
    public InetSocketAddress resolve() {
        try {
            InetAddress inetAddress = this.getByName(this.host);
            InetSocketAddress updateAddress = new InetSocketAddress(inetAddress, this.port);
            this.checkDnsUpdate(updateAddress);
            return updateAddress;
        }
        catch (UnknownHostException e) {
            this.logger.info("dns lookup fail. host:{}", (Object)this.host);
            return InetSocketAddress.createUnresolved(this.host, this.port);
        }
    }

    @VisibleForTesting
    InetAddress getByName(String host) throws UnknownHostException {
        return InetAddress.getByName(host);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDnsUpdate(InetSocketAddress updateAddress) {
        DnsSocketAddressProvider dnsSocketAddressProvider = this;
        synchronized (dnsSocketAddressProvider) {
            InetSocketAddress oldAddress = this.oldAddress;
            if (oldAddress != null && !oldAddress.equals(updateAddress)) {
                this.logger.info("host address updated, host:{} old:{}, update:{}", new Object[]{this.host, oldAddress, updateAddress});
            }
            this.oldAddress = updateAddress;
        }
    }

    public String toString() {
        return "DnsSocketAddressProvider{host='" + this.host + '\'' + ", port=" + this.port + '}';
    }
}

