/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.user;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilters;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.plugin.user.UserPluginConfig;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UserPlugin
implements ProfilerPlugin,
TransformTemplateAware {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private TransformTemplate transformTemplate;

    public void setup(ProfilerPluginSetupContext context) {
        UserPluginConfig config = new UserPluginConfig(context.getConfig());
        Map<String, Set<String>> methods = this.parseUserMethods(config.getIncludeList());
        if (this.logger.isInfoEnabled()) {
            this.logger.info("UserPlugin entry points={}", methods);
        }
        for (Map.Entry<String, Set<String>> entry : methods.entrySet()) {
            try {
                this.addUserIncludeClass(entry.getKey(), entry.getValue());
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Add user include class interceptor {}.{}", (Object)entry.getKey(), entry.getValue());
            }
            catch (Exception e) {
                this.logger.warn("Failed to add user include class(" + entry.getKey() + "." + entry.getValue() + ").", (Throwable)e);
            }
        }
        List<String> clientHandlerMethods = config.getMqClientHandlerMethods();
        this.addMessageQueueClientHandlerMethods(clientHandlerMethods);
    }

    private void addUserIncludeClass(String className, final Set<String> methodNames) {
        this.transformTemplate.transform(className, new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                String[] names = methodNames.toArray(new String[0]);
                for (InstrumentMethod method : target.getDeclaredMethods(MethodFilters.name((String[])names))) {
                    try {
                        method.addInterceptor("com.navercorp.pinpoint.plugin.user.interceptor.UserIncludeMethodInterceptor");
                    }
                    catch (Exception e) {
                        if (!UserPlugin.this.logger.isWarnEnabled()) continue;
                        UserPlugin.this.logger.warn("Unsupported method " + method, (Throwable)e);
                    }
                }
                return target.toBytecode();
            }
        });
    }

    private void addMessageQueueClientHandlerMethods(List<String> clientHandlerMethods) {
        Map<String, Set<String>> clientHandlers = this.parseUserMethods(clientHandlerMethods);
        for (Map.Entry<String, Set<String>> clientHandler : clientHandlers.entrySet()) {
            String className = clientHandler.getKey();
            final Set<String> methodNames = clientHandler.getValue();
            this.transformTemplate.transform(className, new TransformCallback(){

                public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                    InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                    String[] names = methodNames.toArray(new String[0]);
                    for (InstrumentMethod method : target.getDeclaredMethods(MethodFilters.name((String[])names))) {
                        try {
                            method.addInterceptor("com.navercorp.pinpoint.plugin.user.interceptor.MQExternalClientHandlerInterceptor");
                        }
                        catch (Exception e) {
                            if (!UserPlugin.this.logger.isWarnEnabled()) continue;
                            UserPlugin.this.logger.warn("Unsupported method " + method, (Throwable)e);
                        }
                    }
                    return target.toBytecode();
                }
            });
        }
    }

    private Map<String, Set<String>> parseUserMethods(List<String> fullyQualifiedMethodNames) {
        HashMap<String, Set<String>> userMethods = new HashMap<String, Set<String>>();
        for (String fullyQualifiedMethodName : fullyQualifiedMethodNames) {
            try {
                String className = this.toClassName(fullyQualifiedMethodName);
                String methodName = this.toMethodName(fullyQualifiedMethodName);
                HashSet<String> methodNames = (HashSet<String>)userMethods.get(className);
                if (methodNames == null) {
                    methodNames = new HashSet<String>();
                    userMethods.put(className, methodNames);
                }
                methodNames.add(methodName);
            }
            catch (Exception e) {
                this.logger.warn("Failed to parse user method(" + fullyQualifiedMethodName + ").", (Throwable)e);
            }
        }
        return userMethods;
    }

    String toClassName(String fullQualifiedMethodName) {
        int classEndPosition = fullQualifiedMethodName.lastIndexOf(46);
        if (classEndPosition <= 0) {
            throw new IllegalArgumentException("invalid full qualified method name(" + fullQualifiedMethodName + "). not found method");
        }
        return fullQualifiedMethodName.substring(0, classEndPosition);
    }

    String toMethodName(String fullQualifiedMethodName) {
        int methodBeginPosition = fullQualifiedMethodName.lastIndexOf(46);
        if (methodBeginPosition <= 0 || methodBeginPosition + 1 >= fullQualifiedMethodName.length()) {
            throw new IllegalArgumentException("invalid full qualified method name(" + fullQualifiedMethodName + "). not found method");
        }
        return fullQualifiedMethodName.substring(methodBeginPosition + 1);
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }
}

