/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.sender.planer;

import com.navercorp.pinpoint.profiler.sender.PartitionedByteBufferLocator;
import com.navercorp.pinpoint.profiler.sender.SpanStreamSendDataFactory;
import com.navercorp.pinpoint.profiler.sender.planer.AbstractSpanStreamSendDataPlaner;
import com.navercorp.pinpoint.thrift.dto.TSpan;
import com.navercorp.pinpoint.thrift.dto.TSpanChunk;
import com.navercorp.pinpoint.thrift.io.HeaderTBaseSerializer;
import com.navercorp.pinpoint.thrift.io.HeaderTBaseSerializerFactory;
import java.nio.ByteBuffer;
import java.util.Collections;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpanStreamSendDataPlaner
extends AbstractSpanStreamSendDataPlaner {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final TSpan span;
    private byte[] spanChunkBuffer;
    private int spanChunkSize;

    public SpanStreamSendDataPlaner(PartitionedByteBufferLocator partitionedByteBufferLocator, SpanStreamSendDataFactory spanStreamSendDataFactory, TSpan span) {
        super(partitionedByteBufferLocator, spanStreamSendDataFactory);
        this.span = span;
    }

    @Override
    protected int getSpanChunkLength() {
        this.getSpanChunkBuffer0();
        return this.spanChunkSize;
    }

    @Override
    protected ByteBuffer getSpanChunkBuffer() {
        return ByteBuffer.wrap(this.getSpanChunkBuffer0(), 0, this.spanChunkSize);
    }

    private byte[] getSpanChunkBuffer0() {
        if (this.spanChunkBuffer == null) {
            TSpanChunk spanChunk = this.toSpanChunk(this.span);
            HeaderTBaseSerializer serializer = new HeaderTBaseSerializerFactory(false, 65507, false).createSerializer();
            try {
                byte[] spanChunkBuffer = serializer.serialize((TBase)spanChunk);
                this.spanChunkBuffer = spanChunkBuffer;
                this.spanChunkSize = serializer.getInterBufferSize();
            }
            catch (TException e) {
                this.logger.warn("Spanchunk serializer failed. {}.", (Object)spanChunk);
            }
        }
        if (this.spanChunkBuffer == null) {
            return new byte[0];
        }
        return this.spanChunkBuffer;
    }

    private TSpanChunk toSpanChunk(TSpan span) {
        TSpanChunk spanChunk = new TSpanChunk();
        spanChunk.setSpanEventList(Collections.emptyList());
        spanChunk.setSpanEventListIsSet(true);
        spanChunk.setAgentId(span.getAgentId());
        spanChunk.setAgentIdIsSet(true);
        spanChunk.setApplicationName(span.getApplicationName());
        spanChunk.setApplicationNameIsSet(true);
        spanChunk.setAgentStartTime(span.getStartTime());
        spanChunk.setAgentStartTimeIsSet(true);
        spanChunk.setTransactionId(span.getTransactionId());
        spanChunk.setTransactionIdIsSet(true);
        spanChunk.setSpanId(span.getSpanId());
        spanChunk.setSpanIdIsSet(true);
        spanChunk.setEndPoint(span.getEndPoint());
        spanChunk.setEndPointIsSet(true);
        return spanChunk;
    }
}

