/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.sender;

import com.navercorp.pinpoint.common.util.ArrayUtils;
import com.navercorp.pinpoint.profiler.sender.SpanStreamSendDataMode;
import com.navercorp.pinpoint.profiler.sender.SpanStreamSendDataSerializer;
import com.navercorp.pinpoint.profiler.util.ByteBufferUtils;
import com.navercorp.pinpoint.profiler.util.ObjectPool;
import com.navercorp.pinpoint.thrift.io.HeaderTBaseSerializer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpanStreamSendData {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ByteBuffer[] components;
    private final SpanStreamSendDataSerializer encoder;
    private final List<HeaderTBaseSerializer> usedSerializerList;
    private final ObjectPool<HeaderTBaseSerializer> serializerPool;
    private final int maxBufferSize;
    private final int maxGatheringComponentCount;
    private final int maxAvailableBufferCapacity;
    private int availableBufferCapacity;
    private int chunkCount = 0;
    private int componentsIndex = 0;
    private SpanStreamSendDataMode mode;
    private long firstAccessTime = -1L;

    public SpanStreamSendData(int maxPacketSize, int maxGatheringComponentCount, ObjectPool<HeaderTBaseSerializer> serializerPool) {
        this.maxBufferSize = maxPacketSize;
        this.maxGatheringComponentCount = maxGatheringComponentCount - 2;
        this.availableBufferCapacity = this.maxAvailableBufferCapacity = maxPacketSize - 3 - 1;
        if (this.maxAvailableBufferCapacity <= 0) {
            throw new IllegalArgumentException("Illegal maxPacketSize(" + maxPacketSize + ")");
        }
        if (this.maxGatheringComponentCount <= 0) {
            throw new IllegalArgumentException("Illegal maxGatheringComponentCount(" + maxGatheringComponentCount + ")");
        }
        this.components = new ByteBuffer[maxGatheringComponentCount];
        this.encoder = new SpanStreamSendDataSerializer();
        this.usedSerializerList = new ArrayList<HeaderTBaseSerializer>();
        this.serializerPool = serializerPool;
        this.mode = SpanStreamSendDataMode.WAIT_BUFFER;
    }

    public boolean addBuffer(byte[] buffer) {
        return this.addBuffer(ByteBuffer.wrap(buffer), null);
    }

    public boolean addBuffer(byte[] buffer, HeaderTBaseSerializer headerTbaseSerializer) {
        return this.addBuffer(ByteBuffer.wrap(buffer), headerTbaseSerializer);
    }

    public boolean addBuffer(ByteBuffer buffer) {
        return this.addBuffer(buffer, null);
    }

    public boolean addBuffer(ByteBuffer buffer, HeaderTBaseSerializer headerTbaseSerializer) {
        ByteBuffer[] bufferArray = new ByteBuffer[]{buffer};
        return this.addBuffer(bufferArray, null);
    }

    public boolean addBuffer(ByteBuffer[] buffers) {
        return this.addBuffer(buffers, null);
    }

    public boolean addBuffer(ByteBuffer[] buffers, HeaderTBaseSerializer headerTbaseSerializer) {
        if (this.firstAccessTime == -1L) {
            this.firstAccessTime = System.currentTimeMillis();
        }
        if (!this.checkAddAvailable(buffers)) {
            return false;
        }
        if (headerTbaseSerializer != null) {
            this.usedSerializerList.add(headerTbaseSerializer);
        }
        ++this.chunkCount;
        ByteBuffer chunkFlagBuffer = ByteBufferUtils.createByteBuffer(2);
        this.components[this.componentsIndex++] = chunkFlagBuffer;
        int usedBufferLength = 0;
        for (ByteBuffer buffer : buffers) {
            if (buffer.remaining() <= 0) continue;
            this.components[this.componentsIndex++] = buffer;
            usedBufferLength += buffer.remaining();
        }
        ByteBufferUtils.putShort(chunkFlagBuffer, (short)usedBufferLength);
        chunkFlagBuffer.flip();
        this.availableBufferCapacity = this.availableBufferCapacity - usedBufferLength - 2;
        return true;
    }

    private boolean checkAddAvailable(ByteBuffer[] bufferArray) {
        if (ArrayUtils.isEmpty((Object[])bufferArray)) {
            return false;
        }
        if (bufferArray.length + 1 > this.getAvailableGatheringComponentsCount()) {
            return false;
        }
        int usedBufferLength = 0;
        for (ByteBuffer buffer : bufferArray) {
            usedBufferLength += buffer.remaining();
        }
        if (usedBufferLength == 0) {
            return false;
        }
        return this.isAvailableBufferCapacity(usedBufferLength);
    }

    public boolean isAvailableBufferCapacity(int length) {
        this.logger.debug("inputdata-length:{}, chunk-length:{}, available-length:{}", new Object[]{length, 2, this.availableBufferCapacity});
        return length + 2 < this.availableBufferCapacity;
    }

    public boolean isAvailableComponentsCount(int componentsCount) {
        int availableGatheringComponentsCount = this.getAvailableGatheringComponentsCount();
        this.logger.debug("inputcomponents-count:{}, availablecomponents-count:{}", (Object)componentsCount, (Object)availableGatheringComponentsCount);
        return componentsCount < availableGatheringComponentsCount;
    }

    public int getMaxBufferCapacity() {
        return this.maxBufferSize;
    }

    public int getAvailableBufferCapacity() {
        return this.availableBufferCapacity;
    }

    public int getAvailableGatheringComponentsCount() {
        return this.maxGatheringComponentCount - this.componentsIndex;
    }

    public ByteBuffer[] getSendBuffers() {
        int writeIndex = 0;
        ByteBuffer[] sendData = new ByteBuffer[2 + this.componentsIndex];
        sendData[writeIndex++] = this.encoder.createStartBuffer((byte)this.chunkCount);
        for (int i = 0; i < this.componentsIndex; ++i) {
            sendData[writeIndex++] = this.components[i];
        }
        sendData[writeIndex++] = this.encoder.createEndBuffer();
        return sendData;
    }

    public void setWaitBufferAndFlushMode() {
        this.setFlushMode(SpanStreamSendDataMode.WAIT_BUFFER_AND_FLUSH);
    }

    public void setFlushMode() {
        this.setFlushMode(SpanStreamSendDataMode.FLUSH);
    }

    public void setFlushMode(SpanStreamSendDataMode mode) {
        this.mode = mode;
    }

    public SpanStreamSendDataMode getFlushMode() {
        return this.mode;
    }

    public void done() {
        for (HeaderTBaseSerializer eachSerializer : this.usedSerializerList) {
            this.serializerPool.returnObject(eachSerializer);
        }
    }

    public long getFirstAccessTime() {
        return this.firstAccessTime;
    }

    public String toString() {
        return "SpanStreamSendData [components=" + Arrays.toString(this.components) + ", encoder=" + this.encoder + ", usedSerializerList=" + this.usedSerializerList + ", serializerPool=" + this.serializerPool + ", maxBufferSize=" + this.maxBufferSize + ", maxGatheringComponentCount=" + this.maxGatheringComponentCount + ", maxAvailableBufferCapacity=" + this.maxAvailableBufferCapacity + ", availableBufferCapacity=" + this.availableBufferCapacity + ", chunkCount=" + this.chunkCount + ", componentsIndex=" + this.componentsIndex + ", mode=" + (Object)((Object)this.mode) + "]";
    }
}

